/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.WorldGen;

import com.supercat765.MazeMod.MazeMod;
import com.supercat765.MazeMod.WorldGen.MazeSegmentInfo;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ChestGenHooks;

public class GenMaze
extends WorldGenerator
implements IWorldGenerator {
    MazeSegmentInfo[][] MazeInfo;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == MazeMod.DimID) {
            int b;
            int a;
            this.MazeInfo = new MazeSegmentInfo[4][MazeMod.MazeLayers];
            for (a = 0; a < MazeMod.MazeLayers; ++a) {
                this.MazeInfo[0][a] = new MazeSegmentInfo(world, chunkX * 2, chunkZ * 2, a);
                this.MazeInfo[1][a] = new MazeSegmentInfo(world, chunkX * 2 + 1, chunkZ * 2, a);
                this.MazeInfo[2][a] = new MazeSegmentInfo(world, chunkX * 2, chunkZ * 2 + 1, a);
                this.MazeInfo[3][a] = new MazeSegmentInfo(world, chunkX * 2 + 1, chunkZ * 2 + 1, a);
            }
            for (a = 0; a < MazeMod.MazeLayers; ++a) {
                for (b = 0; b < 4; ++b) {
                    this.GenMazeSegment(this.MazeInfo[b][a]);
                }
            }
            for (a = 0; a < MazeMod.MazeLayers; ++a) {
                for (b = 0; b < 4; ++b) {
                    this.populateMaze(this.MazeInfo[b][a]);
                }
            }
            for (a = 0; a < MazeMod.MazeLayers; ++a) {
                for (b = 0; b < 4; ++b) {
                    this.GenMazeStairs(this.MazeInfo[b][a]);
                }
            }
        }
    }

    private void GenMazeSegment(MazeSegmentInfo Info) {
        int b;
        int a;
        World world = Info.world;
        int x = Info.x;
        int y = Info.y;
        int z = Info.z;
        for (a = 0; a < 9; ++a) {
            world.func_147465_d(x + 8, y, z + a, Blocks.field_150357_h, 0, 2);
            if ((double)Info.distx < 0.2) {
                world.func_147465_d(x + 8, y + 1, z + a, Blocks.field_150357_h, 0, 2);
                world.func_147465_d(x + 8, y + 2, z + a, Blocks.field_150357_h, 0, 2);
                world.func_147465_d(x + 8, y + 3, z + a, Blocks.field_150357_h, 0, 2);
                world.func_147465_d(x + 8, y + 4, z + a, Blocks.field_150357_h, 0, 2);
            }
            world.func_147465_d(x + a, y, z + 8, Blocks.field_150357_h, 0, 2);
            if (!((double)Info.distz < 0.2)) continue;
            world.func_147465_d(x + a, y + 1, z + 8, Blocks.field_150357_h, 0, 2);
            world.func_147465_d(x + a, y + 2, z + 8, Blocks.field_150357_h, 0, 2);
            world.func_147465_d(x + a, y + 3, z + 8, Blocks.field_150357_h, 0, 2);
            world.func_147465_d(x + a, y + 4, z + 8, Blocks.field_150357_h, 0, 2);
        }
        for (a = 0; a < 9; ++a) {
            for (b = 0; b < 9; ++b) {
                world.func_147465_d(x + a, y - 1, z + b, Blocks.field_150357_h, 0, 2);
                world.func_147465_d(x + a, y + 5, z + b, Blocks.field_150357_h, 0, 2);
            }
        }
        if (Info.layer == MazeMod.MazeLayers - 1) {
            for (a = 0; a < 9; ++a) {
                for (b = 0; b < 9; ++b) {
                    this.addtoplayer(world, x + a, y + 6, z + b);
                }
            }
        }
    }

    private void addtoplayer(World world, int x, int y, int z) {
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Bedrock Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150357_h, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Dungeon Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150347_e, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Stronghold Maze")) {
            this.setStoneBrick(world, x, y, z);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Quartz Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150371_ca, 1, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Withering Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150385_bj, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Firey Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150424_aL, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Cave Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150348_b, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Precious Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150484_ah, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Flooded Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150355_j, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Peaceful Maze")) {
            this.setGrass(world, x, y, z);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Mesa Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150405_ch, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Desert Maze")) {
            this.setDesert(world, x, y, z);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Ice Maze")) {
            this.setIce(world, x, y, z);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Rainbow Maze")) {
            this.setRainbow(world, x, y, z);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Ender Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150377_bs, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Forest Maze")) {
            this.setleaves(world, x, y, z, true);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Village Maze")) {
            world.func_147465_d(x, y, z, Blocks.field_150475_bE, 0, 2);
        }
        if (world.func_72807_a(x, z) == MazeMod.getBiome("Swampy Maze")) {
            this.setSwampWater(world, x, y, z);
        }
    }

    private void GenMazeStairs(MazeSegmentInfo Info) {
        if (Info.stairsUP) {
            this.addStairs(Info.world, Info.chunkX, Info.chunkZ, Info.layer + 1);
        }
        if (Info.stairsDN) {
            this.addStairs(Info.world, Info.chunkX, Info.chunkZ, Info.layer);
        }
    }

    private void addStairs(World world, int chunkX, int chunkZ, int layer) {
        if (layer > 0 && layer < MazeMod.MazeLayers) {
            int x = chunkX * 8 + 4;
            int z = chunkZ * 8 + 4;
            int y = 4 + 6 * layer;
            block6: for (int a = 0; a < 6; ++a) {
                world.func_147468_f(x - 1, y - a, z - 1);
                world.func_147468_f(x, y - a, z - 1);
                world.func_147468_f(x + 1, y - a, z - 1);
                world.func_147468_f(x + 1, y - a, z);
                world.func_147468_f(x - 1, y - a, z);
                world.func_147468_f(x - 1, y - a, z + 1);
                world.func_147468_f(x, y - a, z + 1);
                world.func_147468_f(x + 1, y - a, z + 1);
                world.func_147465_d(x, y - a, z, Blocks.field_150357_h, 0, 2);
                switch ((y - a) % 4) {
                    case 3: {
                        world.func_147465_d(x + 1, y - a, z, (Block)Blocks.field_150333_U, 8, 2);
                        world.func_147465_d(x + 1, y - a, z + 1, (Block)Blocks.field_150333_U, 0, 2);
                        continue block6;
                    }
                    case 2: {
                        world.func_147465_d(x, y - a, z + 1, (Block)Blocks.field_150333_U, 8, 2);
                        world.func_147465_d(x - 1, y - a, z + 1, (Block)Blocks.field_150333_U, 0, 2);
                        continue block6;
                    }
                    case 1: {
                        world.func_147465_d(x - 1, y - a, z, (Block)Blocks.field_150333_U, 8, 2);
                        world.func_147465_d(x - 1, y - a, z - 1, (Block)Blocks.field_150333_U, 0, 2);
                        continue block6;
                    }
                    case 0: {
                        world.func_147465_d(x, y - a, z - 1, (Block)Blocks.field_150333_U, 8, 2);
                        world.func_147465_d(x + 1, y - a, z - 1, (Block)Blocks.field_150333_U, 0, 2);
                    }
                }
            }
        }
    }

    private void populateMaze(MazeSegmentInfo Info) {
        BiomeGenBase biome = Info.Biome;
        if (biome == MazeMod.getBiome("Bedrock Maze")) {
            this.populateMaze1(Info);
        }
        if (biome == MazeMod.getBiome("Dungeon Maze")) {
            this.populateMaze2(Info);
        }
        if (biome == MazeMod.getBiome("Stronghold Maze")) {
            this.populateMaze3(Info);
        }
        if (biome == MazeMod.getBiome("Quartz Maze")) {
            this.populateMaze4(Info);
        }
        if (biome == MazeMod.getBiome("Withering Maze")) {
            this.populateWitheringMaze(Info);
        }
        if (biome == MazeMod.getBiome("Firey Maze")) {
            this.populateFlamingMaze(Info);
        }
        if (biome == MazeMod.getBiome("Cave Maze")) {
            this.populateCaveMaze(Info);
        }
        if (biome == MazeMod.getBiome("Precious Maze")) {
            this.populatePreciousMaze(Info);
        }
        if (biome == MazeMod.getBiome("Flooded Maze")) {
            this.populateFloodedMaze(Info);
        }
        if (biome == MazeMod.getBiome("Peaceful Maze")) {
            this.populatePeacefulMaze(Info);
        }
        if (biome == MazeMod.getBiome("Mesa Maze")) {
            this.populateMesaMaze(Info);
        }
        if (biome == MazeMod.getBiome("Desert Maze")) {
            this.populateDesertMaze(Info);
        }
        if (biome == MazeMod.getBiome("Ice Maze")) {
            this.populateIceMaze(Info);
        }
        if (biome == MazeMod.getBiome("Rainbow Maze")) {
            this.populateRainbowMaze(Info);
        }
        if (biome == MazeMod.getBiome("Ender Maze")) {
            this.populateEnderMaze(Info);
        }
        if (biome == MazeMod.getBiome("Forest Maze")) {
            this.populateForestMaze(Info);
        }
        if (biome == MazeMod.getBiome("Village Maze")) {
            this.populateVillageMaze(Info);
        }
        if (biome == MazeMod.getBiome("Swampy Maze")) {
            this.populateSwampyMaze(Info);
        }
    }

    private void populateWitheringMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                world.func_147465_d(x + a2, y, z + b, Blocks.field_150385_bj, 0, 2);
            }
        }
        for (a2 = 1; a2 < 5; ++a2) {
            if ((double)Info.distx2 < 0.2 || (double)Info.distz2 < 0.2) {
                world.func_147465_d(x, y + a2, z, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x + 1, y + a2, z + 1, Blocks.field_150385_bj, 0, 2);
            }
            if ((double)Info.distx < 0.2 || (double)Info.distz2 < 0.2) {
                world.func_147465_d(x + 6, y + a2, z, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x + 5, y + a2, z + 1, Blocks.field_150385_bj, 0, 2);
            }
            if ((double)Info.distx2 < 0.2 || (double)Info.distz < 0.2) {
                world.func_147465_d(x, y + a2, z + 6, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x + 1, y + a2, z + 5, Blocks.field_150385_bj, 0, 2);
            }
            if ((double)Info.distx < 0.2 || (double)Info.distz < 0.2) {
                world.func_147465_d(x + 6, y + a2, z + 6, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x + 5, y + a2, z + 5, Blocks.field_150385_bj, 0, 2);
            }
            for (b = 1; b < 6; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    world.func_147465_d(x, y + a2, z + b, Blocks.field_150353_l, 0, 2);
                }
                if ((double)Info.distx < 0.2) {
                    world.func_147465_d(x + 6, y + a2, z + b, Blocks.field_150353_l, 0, 2);
                }
                if ((double)Info.distz2 < 0.2) {
                    world.func_147465_d(x + b, y + a2, z, Blocks.field_150353_l, 0, 2);
                }
                if (!((double)Info.distz < 0.2)) continue;
                world.func_147465_d(x + b, y + a2, z + 6, Blocks.field_150353_l, 0, 2);
            }
            for (b = 2; b < 5; ++b) {
                Block block = Blocks.field_150386_bk;
                if (a2 == 4) {
                    block = Blocks.field_150385_bj;
                }
                if ((double)Info.distx2 < 0.2) {
                    world.func_147465_d(x + 1, y + a2, z + b, block, 0, 2);
                }
                if ((double)Info.distx < 0.2) {
                    world.func_147465_d(x + 5, y + a2, z + b, block, 0, 2);
                }
                if ((double)Info.distz2 < 0.2) {
                    world.func_147465_d(x + b, y + a2, z + 1, block, 0, 2);
                }
                if (!((double)Info.distz < 0.2)) continue;
                world.func_147465_d(x + b, y + a2, z + 5, block, 0, 2);
            }
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Withering Maze")) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + 7, y, z + a, Blocks.field_150385_bj, 0, 2);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Withering Maze")) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + a, y, z + 7, Blocks.field_150385_bj, 0, 2);
            }
        }
    }

    private void populateMaze3(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        world.func_147465_d(x + 1, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 1, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                this.setStoneBrick(world, x + a2, y, z + b);
            }
        }
        for (a2 = 1; a2 < 5; ++a2) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    this.setStoneBrick(world, x, y + a2, z + b);
                }
                if ((double)Info.distx < 0.2) {
                    this.setStoneBrick(world, x + 6, y + a2, z + b);
                }
                if ((double)Info.distz2 < 0.2) {
                    this.setStoneBrick(world, x + b, y + a2, z);
                }
                if (!((double)Info.distz < 0.2)) continue;
                this.setStoneBrick(world, x + b, y + a2, z + 6);
            }
            if ((double)Info.distx2 < 0.2) {
                this.setStoneBrick(world, x + 1, y + a2, z + 3);
            }
            if ((double)Info.distx < 0.2) {
                this.setStoneBrick(world, x + 5, y + a2, z + 3);
            }
            if ((double)Info.distz2 < 0.2) {
                this.setStoneBrick(world, x + 3, y + a2, z + 1);
            }
            if (!((double)Info.distz < 0.2)) continue;
            this.setStoneBrick(world, x + 3, y + a2, z + 5);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Stronghold Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setStoneBrick(world, x + 7, y, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Stronghold Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setStoneBrick(world, x + a, y, z + 7);
            }
        }
    }

    private void populateCaveMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                this.setOre(world, x + a2, y, z + b);
                this.setOre(world, x + a2, y + 3, z + b);
                this.setOre(world, x + a2, y + 4, z + b);
            }
        }
        for (a2 = 1; a2 < 5; ++a2) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    this.setOre(world, x, y + a2, z + b);
                    this.setOre(world, x + 1, y + a2, z + b);
                }
                if ((double)Info.distx < 0.2) {
                    this.setOre(world, x + 6, y + a2, z + b);
                    this.setOre(world, x + 5, y + a2, z + b);
                }
                if ((double)Info.distz2 < 0.2) {
                    this.setOre(world, x + b, y + a2, z);
                    this.setOre(world, x + b, y + a2, z + 1);
                }
                if (!((double)Info.distz < 0.2)) continue;
                this.setOre(world, x + b, y + a2, z + 6);
                this.setOre(world, x + b, y + a2, z + 5);
            }
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Cave Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setOre(world, x + 7, y, z + a);
                this.setOre(world, x + 7, y + 3, z + a);
                this.setOre(world, x + 7, y + 4, z + a);
                if (a >= 5) continue;
                this.setOre(world, x + 7, y + a, z);
                this.setOre(world, x + 7, y + a, z + 6);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Cave Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setOre(world, x + a, y, z + 7);
                this.setOre(world, x + a, y + 3, z + 7);
                this.setOre(world, x + a, y + 4, z + 7);
                if (a >= 5) continue;
                this.setOre(world, x, y + a, z + 7);
                this.setOre(world, x + 6, y + a, z + 7);
            }
        }
    }

    private void populateFlamingMaze(MazeSegmentInfo Info) {
        int a;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a2 = 0; a2 < 7; ++a2) {
            for (int b = 0; b < 7; ++b) {
                world.func_147465_d(x + a2, y, z + b, Blocks.field_150353_l, 0, 2);
            }
        }
        for (a2 = 2; a2 < 5; ++a2) {
            this.setNetherrack(world, x + 1, y, z + a2);
            this.setNetherrack(world, x + 5, y, z + a2);
            this.setNetherrack(world, x + a2, y, z + 1);
            this.setNetherrack(world, x + a2, y, z + 2);
            this.setNetherrack(world, x + a2, y, z + 3);
            this.setNetherrack(world, x + a2, y, z + 4);
            this.setNetherrack(world, x + a2, y, z + 5);
        }
        if ((double)Info.distx2 > 0.2) {
            this.setNetherrack(world, x, y, z + 1 + (int)(((double)Info.distx2 - 0.2) / 0.8 * 5.0));
        }
        if ((double)Info.distx > 0.2) {
            this.setNetherrack(world, x + 6, y, z + 1 + (int)(((double)Info.distx - 0.2) / 0.8 * 5.0));
            BiomeGenBase biome = Info.BiomeX;
            if (biome == MazeMod.getBiome("Firey Maze")) {
                for (a = 0; a < 7; ++a) {
                    world.func_147465_d(x + 7, y, z + a, Blocks.field_150353_l, 0, 2);
                }
                this.setNetherrack(world, x + 7, y, z + 1 + (int)(((double)Info.distx - 0.2) / 0.8 * 5.0));
            }
        }
        if ((double)Info.distz2 > 0.2) {
            this.setNetherrack(world, x + 1 + (int)(((double)Info.distz2 - 0.2) / 0.8 * 5.0), y, z);
        }
        if ((double)Info.distz > 0.2) {
            this.setNetherrack(world, x + 1 + (int)(((double)Info.distz - 0.2) / 0.8 * 5.0), y, z + 6);
            BiomeGenBase biome = Info.BiomeZ;
            if (biome == MazeMod.getBiome("Firey Maze")) {
                for (a = 0; a < 7; ++a) {
                    world.func_147465_d(x + a, y, z + 7, Blocks.field_150353_l, 0, 2);
                }
                this.setNetherrack(world, x + 1 + (int)(((double)Info.distz - 0.2) / 0.8 * 5.0), y, z + 7);
            }
        }
    }

    private void populateMaze2(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                this.setCobbleStone(world, x + a2, y, z + b);
            }
        }
        for (a2 = 1; a2 < 5; ++a2) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    this.setCobbleStone(world, x, y + a2, z + b);
                }
                if ((double)Info.distx < 0.2) {
                    this.setCobbleStone(world, x + 6, y + a2, z + b);
                }
                if ((double)Info.distz2 < 0.2) {
                    this.setCobbleStone(world, x + b, y + a2, z);
                }
                if (!((double)Info.distz < 0.2)) continue;
                this.setCobbleStone(world, x + b, y + a2, z + 6);
            }
            if ((double)Info.distx2 < 0.2) {
                this.setCobbleStone(world, x + 1, y + a2, z + 3);
            }
            if ((double)Info.distx < 0.2) {
                this.setCobbleStone(world, x + 5, y + a2, z + 3);
            }
            if ((double)Info.distz2 < 0.2) {
                this.setCobbleStone(world, x + 3, y + a2, z + 1);
            }
            if (!((double)Info.distz < 0.2)) continue;
            this.setCobbleStone(world, x + 3, y + a2, z + 5);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Dungeon Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setCobbleStone(world, x + 7, y, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Dungeon Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setCobbleStone(world, x + a, y, z + 7);
            }
        }
    }

    private void populateMaze1(MazeSegmentInfo Info) {
        int b;
        int a;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        world.func_147465_d(x + 1, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 1, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        for (a = 0; a < 7; ++a) {
            for (b = 0; b < 7; ++b) {
                world.func_147465_d(x + a, y, z + b, Blocks.field_150357_h, 0, 2);
            }
        }
        for (a = 1; a < 5; ++a) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    world.func_147465_d(x, y + a, z + b, Blocks.field_150357_h, 0, 2);
                }
                if ((double)Info.distx < 0.2) {
                    world.func_147465_d(x + 6, y + a, z + b, Blocks.field_150357_h, 0, 2);
                }
                if ((double)Info.distz2 < 0.2) {
                    world.func_147465_d(x + b, y + a, z, Blocks.field_150357_h, 0, 2);
                }
                if (!((double)Info.distz < 0.2)) continue;
                world.func_147465_d(x + b, y + a, z + 6, Blocks.field_150357_h, 0, 2);
            }
            if ((double)Info.distx2 < 0.2) {
                world.func_147465_d(x + 1, y + a, z + 3, Blocks.field_150357_h, 0, 2);
            }
            if ((double)Info.distx < 0.2) {
                world.func_147465_d(x + 5, y + a, z + 3, Blocks.field_150357_h, 0, 2);
            }
            if ((double)Info.distz2 < 0.2) {
                world.func_147465_d(x + 3, y + a, z + 1, Blocks.field_150357_h, 0, 2);
            }
            if (!((double)Info.distz < 0.2)) continue;
            world.func_147465_d(x + 3, y + a, z + 5, Blocks.field_150357_h, 0, 2);
        }
        if ((double)Info.distx > 0.2) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + 7, y, z + a, Blocks.field_150357_h, 0, 2);
            }
        }
        if ((double)Info.distz > 0.2) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + a, y, z + 7, Blocks.field_150357_h, 0, 2);
            }
        }
    }

    private void populatePeacefulMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        world.func_147465_d(x + 1, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 1, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        for (int a2 = 0; a2 < 7; ++a2) {
            for (int b = 0; b < 7; ++b) {
                this.setGrass(world, x + a2, y, z + b);
            }
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Peaceful Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setGrass(world, x + 7, y, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Peaceful Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setGrass(world, x + a, y, z + 7);
            }
        }
    }

    private void populateMaze4(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                this.setQuartz(world, x + a2, y, z + b);
            }
        }
        for (a2 = 1; a2 < 5; ++a2) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    this.setQuartz(world, x, y + a2, z + b);
                }
                if ((double)Info.distx < 0.2) {
                    this.setQuartz(world, x + 6, y + a2, z + b);
                }
                if ((double)Info.distz2 < 0.2) {
                    this.setQuartz(world, x + b, y + a2, z);
                }
                if (!((double)Info.distz < 0.2)) continue;
                this.setQuartz(world, x + b, y + a2, z + 6);
            }
            if ((double)Info.distx2 < 0.2) {
                this.setQuartz(world, x + 1, y + a2, z + 3);
            }
            if ((double)Info.distx < 0.2) {
                this.setQuartz(world, x + 5, y + a2, z + 3);
            }
            if ((double)Info.distz2 < 0.2) {
                this.setQuartz(world, x + 3, y + a2, z + 1);
            }
            if (!((double)Info.distz < 0.2)) continue;
            this.setQuartz(world, x + 3, y + a2, z + 5);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Quartz Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setQuartz(world, x + 7, y, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Quartz Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setQuartz(world, x + a, y, z + 7);
            }
        }
    }

    private void populateIceMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                this.setIce(world, x + a2, y, z + b);
            }
        }
        for (a2 = 1; a2 < 5; ++a2) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    this.setIce(world, x, y + a2, z + b);
                }
                if ((double)Info.distx < 0.2) {
                    this.setIce(world, x + 6, y + a2, z + b);
                }
                if ((double)Info.distz2 < 0.2) {
                    this.setIce(world, x + b, y + a2, z);
                }
                if (!((double)Info.distz < 0.2)) continue;
                this.setIce(world, x + b, y + a2, z + 6);
            }
            if ((double)Info.distx2 < 0.2) {
                this.setIce(world, x + 1, y + a2, z + 3);
            }
            if ((double)Info.distx < 0.2) {
                this.setIce(world, x + 5, y + a2, z + 3);
            }
            if ((double)Info.distz2 < 0.2) {
                this.setIce(world, x + 3, y + a2, z + 1);
            }
            if (!((double)Info.distz < 0.2)) continue;
            this.setIce(world, x + 3, y + a2, z + 5);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Ice Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setIce(world, x + 7, y, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Ice Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setIce(world, x + a, y, z + 7);
            }
        }
    }

    private void populateRainbowMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        world.func_147465_d(x + 1, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 1, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                this.setRainbow(world, x + a2, y, z + b);
                this.setRainbow(world, x + a2, y + 4, z + b);
            }
        }
        for (a2 = 1; a2 < 5; ++a2) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    this.setRainbow(world, x, y + a2, z + b);
                }
                if ((double)Info.distx < 0.2) {
                    this.setRainbow(world, x + 6, y + a2, z + b);
                }
                if ((double)Info.distz2 < 0.2) {
                    this.setRainbow(world, x + b, y + a2, z);
                }
                if (!((double)Info.distz < 0.2)) continue;
                this.setRainbow(world, x + b, y + a2, z + 6);
            }
            if ((double)Info.distx2 < 0.2) {
                this.setRainbow(world, x + 1, y + a2, z + 3);
            }
            if ((double)Info.distx < 0.2) {
                this.setRainbow(world, x + 5, y + a2, z + 3);
            }
            if ((double)Info.distz2 < 0.2) {
                this.setRainbow(world, x + 3, y + a2, z + 1);
            }
            if (!((double)Info.distz < 0.2)) continue;
            this.setRainbow(world, x + 3, y + a2, z + 5);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Rainbow Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setRainbow(world, x + 7, y, z + a);
                this.setRainbow(world, x + 7, y + 4, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Rainbow Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setRainbow(world, x + a, y, z + 7);
                this.setRainbow(world, x + a, y + 4, z + 7);
            }
        }
    }

    private void populateMesaMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                world.func_147465_d(x + a2, y, z + b, (Block)Blocks.field_150354_m, 1, 2);
            }
        }
        for (a2 = 0; a2 < 5; ++a2) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    this.setClay(world, x, y + a2, z + b);
                }
                if ((double)Info.distx < 0.2) {
                    this.setClay(world, x + 6, y + a2, z + b);
                }
                if ((double)Info.distz2 < 0.2) {
                    this.setClay(world, x + b, y + a2, z);
                }
                if (!((double)Info.distz < 0.2)) continue;
                this.setClay(world, x + b, y + a2, z + 6);
            }
            if ((double)Info.distx2 < 0.2) {
                this.setClay(world, x + 1, y + a2, z + 3);
            }
            if ((double)Info.distx < 0.2) {
                this.setClay(world, x + 5, y + a2, z + 3);
            }
            if ((double)Info.distz2 < 0.2) {
                this.setClay(world, x + 3, y + a2, z + 1);
            }
            if (!((double)Info.distz < 0.2)) continue;
            this.setClay(world, x + 3, y + a2, z + 5);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Mesa Maze")) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + 7, y, z + a, (Block)Blocks.field_150354_m, 1, 2);
                if (a >= 5) continue;
                this.setClay(world, x + 7, y + 4 - a, z);
                this.setClay(world, x + 7, y + 4 - a, z + 6);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Mesa Maze")) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + a, y, z + 7, (Block)Blocks.field_150354_m, 1, 2);
                if (a >= 5) continue;
                this.setClay(world, x, y + 4 - a, z + 7);
                this.setClay(world, x + 6, y + 4 - a, z + 7);
            }
        }
    }

    private void populateFloodedMaze(MazeSegmentInfo Info) {
        BiomeGenBase biome;
        int a;
        int c;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (int a2 = 0; a2 < 7; ++a2) {
            for (int b = 0; b < 7; ++b) {
                world.func_147465_d(x + a2, y, z + b, Blocks.field_150351_n, 0, 2);
                for (c = 1; c < 5; ++c) {
                    world.func_147465_d(x + a2, y + c, z + b, Blocks.field_150355_j, 0, 2);
                }
            }
        }
        if ((double)Info.distx > 0.2) {
            BiomeGenBase biome2 = Info.BiomeX;
            if (biome2 == MazeMod.getBiome("Flooded Maze")) {
                for (a = 0; a < 7; ++a) {
                    world.func_147465_d(x + 7, y, z + a, Blocks.field_150351_n, 0, 2);
                    for (c = 1; c < 5; ++c) {
                        world.func_147465_d(x + 7, y + c, z + a, Blocks.field_150355_j, 0, 2);
                    }
                }
            } else {
                for (a = 0; a < 7; ++a) {
                    for (c = 1; c < 5; ++c) {
                        this.setFence(world, x + 7, y + c, z + a);
                    }
                }
            }
        }
        if ((double)Info.distz > 0.2) {
            BiomeGenBase biome3 = Info.BiomeZ;
            if (biome3 == MazeMod.getBiome("Flooded Maze")) {
                for (a = 0; a < 7; ++a) {
                    world.func_147465_d(x + a, y, z + 7, Blocks.field_150351_n, 0, 2);
                    for (c = 1; c < 5; ++c) {
                        world.func_147465_d(x + a, y + c, z + 7, Blocks.field_150355_j, 0, 2);
                    }
                }
            } else {
                for (a = 0; a < 7; ++a) {
                    for (c = 1; c < 5; ++c) {
                        this.setFence(world, x + a, y + c, z + 7);
                    }
                }
            }
        }
        if ((double)Info.distx2 > 0.2 && (biome = Info.BiomeX2) != MazeMod.getBiome("Flooded Maze")) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x - 1, y, z + a, Blocks.field_150357_h, 0, 2);
                for (c = 1; c < 5; ++c) {
                    this.setFence(world, x - 1, y + c, z + a);
                }
            }
        }
        if ((double)Info.distz2 > 0.2 && (biome = Info.BiomeZ2) != MazeMod.getBiome("Flooded Maze")) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + a, y, z - 1, Blocks.field_150357_h, 0, 2);
                for (c = 1; c < 5; ++c) {
                    this.setFence(world, x + a, y + c, z - 1);
                }
            }
        }
    }

    private void populatePreciousMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int b;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        world.func_147465_d(x + 1, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 1, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        for (a2 = 0; a2 < 7; ++a2) {
            for (b = 0; b < 7; ++b) {
                world.func_147465_d(x + a2, y, z + b, Blocks.field_150402_ci, 0, 2);
            }
        }
        for (a2 = 0; a2 < 5; ++a2) {
            for (b = 0; b < 7; ++b) {
                if ((double)Info.distx2 < 0.2) {
                    if (a2 < 2) {
                        world.func_147465_d(x, y + a2, z + b, Blocks.field_150340_R, 0, 2);
                    } else {
                        world.func_147465_d(x, y + a2, z + b, Blocks.field_150339_S, 0, 2);
                    }
                }
                if ((double)Info.distx < 0.2) {
                    if (a2 < 2) {
                        world.func_147465_d(x + 6, y + a2, z + b, Blocks.field_150340_R, 0, 2);
                    } else {
                        world.func_147465_d(x + 6, y + a2, z + b, Blocks.field_150339_S, 0, 2);
                    }
                }
                if ((double)Info.distz2 < 0.2) {
                    if (a2 < 2) {
                        world.func_147465_d(x + b, y + a2, z, Blocks.field_150340_R, 0, 2);
                    } else {
                        world.func_147465_d(x + b, y + a2, z, Blocks.field_150339_S, 0, 2);
                    }
                }
                if (!((double)Info.distz < 0.2)) continue;
                if (a2 < 2) {
                    world.func_147465_d(x + b, y + a2, z + 6, Blocks.field_150340_R, 0, 2);
                    continue;
                }
                world.func_147465_d(x + b, y + a2, z + 6, Blocks.field_150339_S, 0, 2);
            }
            if ((double)Info.distx2 < 0.2) {
                if (a2 < 3) {
                    world.func_147465_d(x + 1, y + a2, z + 3, Blocks.field_150475_bE, 0, 2);
                } else {
                    world.func_147465_d(x + 1, y + a2, z + 3, Blocks.field_150484_ah, 0, 2);
                }
            }
            if ((double)Info.distx < 0.2) {
                if (a2 < 3) {
                    world.func_147465_d(x + 5, y + a2, z + 3, Blocks.field_150475_bE, 0, 2);
                } else {
                    world.func_147465_d(x + 5, y + a2, z + 3, Blocks.field_150484_ah, 0, 2);
                }
            }
            if ((double)Info.distz2 < 0.2) {
                if (a2 < 3) {
                    world.func_147465_d(x + 3, y + a2, z + 1, Blocks.field_150475_bE, 0, 2);
                } else {
                    world.func_147465_d(x + 3, y + a2, z + 1, Blocks.field_150484_ah, 0, 2);
                }
            }
            if (!((double)Info.distz < 0.2)) continue;
            if (a2 < 3) {
                world.func_147465_d(x + 3, y + a2, z + 5, Blocks.field_150475_bE, 0, 2);
                continue;
            }
            world.func_147465_d(x + 3, y + a2, z + 5, Blocks.field_150484_ah, 0, 2);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Precious Maze")) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + 7, y, z + a, Blocks.field_150451_bX, 0, 2);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Precious Maze")) {
            for (a = 0; a < 7; ++a) {
                world.func_147465_d(x + a, y, z + 7, Blocks.field_150368_y, 0, 2);
            }
        }
    }

    private void populateEnderMaze(MazeSegmentInfo Info) {
        BiomeGenBase biome;
        int a;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a = 0; a < 7; ++a) {
            for (int b = 0; b < 7; ++b) {
                world.func_147465_d(x + a, y, z + b, Blocks.field_150377_bs, 0, 2);
            }
        }
        for (a = 1; a < 3; ++a) {
            if ((double)Info.distx2 < 0.2 || (double)Info.distz2 < 0.2) {
                world.func_147465_d(x + 1, y + a, z + 1, Blocks.field_150343_Z, 0, 2);
            }
            if ((double)Info.distx < 0.2 || (double)Info.distz2 < 0.2) {
                world.func_147465_d(x + 5, y + a, z + 1, Blocks.field_150343_Z, 0, 2);
            }
            if ((double)Info.distx2 < 0.2 || (double)Info.distz < 0.2) {
                world.func_147465_d(x + 1, y + a, z + 5, Blocks.field_150343_Z, 0, 2);
            }
            if (!((double)Info.distx < 0.2) && !((double)Info.distz < 0.2)) continue;
            world.func_147465_d(x + 5, y + a, z + 5, Blocks.field_150343_Z, 0, 2);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Ender Maze")) {
            for (int a2 = 0; a2 < 7; ++a2) {
                world.func_147465_d(x + 7, y, z + a2, Blocks.field_150377_bs, 0, 2);
            }
            Random rand = this.getRandomiser(new long[]{world.func_72905_C(), Info.chunkX, 48652L, Info.chunkZ, 14562L, Info.layer, 79614L});
            if (rand.nextInt(7) == 0) {
                world.func_147465_d(x + 7, y + 1, z + 3, Blocks.field_150343_Z, 0, 2);
                this.addEndCristal(world, x + 7, y + 1, z + 3);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Ender Maze")) {
            for (int a3 = 0; a3 < 7; ++a3) {
                world.func_147465_d(x + a3, y, z + 7, Blocks.field_150377_bs, 0, 2);
            }
            Random rand = this.getRandomiser(new long[]{world.func_72905_C(), Info.chunkX, 34256L, Info.chunkZ, 97643L, Info.layer, 14562L});
            if (rand.nextInt(7) == 0) {
                world.func_147465_d(x + 3, y + 1, z + 7, Blocks.field_150343_Z, 0, 2);
                this.addEndCristal(world, x + 3, y + 1, z + 7);
            }
        }
    }

    private void populateDesertMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (int a2 = 0; a2 < 7; ++a2) {
            for (int b = 0; b < 7; ++b) {
                this.setDesert(world, x + a2, y, z + b);
            }
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Desert Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setDesert(world, x + 7, y, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Desert Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setDesert(world, x + a, y, z + 7);
            }
        }
    }

    private void populateForestMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (int a2 = 0; a2 < 7; ++a2) {
            for (int b = 0; b < 7; ++b) {
                this.setGrass(world, x + a2, y, z + b);
                this.setleaves(world, x + a2, y + 3, z + b, false);
                this.setleaves(world, x + a2, y + 4, z + b, false);
                this.addTrunks(world, x + a2, y, z + b);
            }
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Forest Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setGrass(world, x + 7, y, z + a);
                this.setleaves(world, x + 7, y + 3, z + a, false);
                this.setleaves(world, x + 7, y + 4, z + a, false);
                this.addTrunks(world, x + 7, y, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Forest Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setGrass(world, x + a, y, z + 7);
                this.setleaves(world, x + a, y + 3, z + 7, false);
                this.setleaves(world, x + a, y + 4, z + 7, false);
                this.addTrunks(world, x + a, y, z + 7);
            }
        }
    }

    private void populateSwampyMaze(MazeSegmentInfo Info) {
        int a;
        BiomeGenBase biome;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (a2 = 0; a2 < 7; ++a2) {
            for (int b = 0; b < 7; ++b) {
                this.setSwampWater(world, x + a2, y, z + b);
            }
        }
        for (a2 = 2; a2 < 5; ++a2) {
            world.func_147465_d(x + 1, y, z + a2, (Block)Blocks.field_150349_c, 0, 2);
            world.func_147465_d(x + 5, y, z + a2, (Block)Blocks.field_150349_c, 0, 2);
            world.func_147465_d(x + a2, y, z + 1, (Block)Blocks.field_150349_c, 0, 2);
            world.func_147465_d(x + a2, y, z + 2, (Block)Blocks.field_150349_c, 0, 2);
            world.func_147465_d(x + a2, y, z + 3, (Block)Blocks.field_150349_c, 0, 2);
            world.func_147465_d(x + a2, y, z + 4, (Block)Blocks.field_150349_c, 0, 2);
            world.func_147465_d(x + a2, y, z + 5, (Block)Blocks.field_150349_c, 0, 2);
            world.func_147468_f(x + 1, y + 1, z + a2);
            world.func_147468_f(x + 5, y + 1, z + a2);
            world.func_147468_f(x + a2, y + 1, z + 1);
            world.func_147468_f(x + a2, y + 1, z + 2);
            world.func_147468_f(x + a2, y + 1, z + 3);
            world.func_147468_f(x + a2, y + 1, z + 4);
            world.func_147468_f(x + a2, y + 1, z + 5);
        }
        if ((double)Info.distx > 0.2 && (biome = Info.BiomeX) == MazeMod.getBiome("Swampy Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setSwampWater(world, x + 7, y, z + a);
            }
        }
        if ((double)Info.distz > 0.2 && (biome = Info.BiomeZ) == MazeMod.getBiome("Swampy Maze")) {
            for (a = 0; a < 7; ++a) {
                this.setSwampWater(world, x + a, y, z + 7);
            }
        }
    }

    private void populateVillageMaze(MazeSegmentInfo Info) {
        Random rand;
        int b;
        int a;
        int b2;
        int a2;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        world.func_147465_d(x + 1, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 1, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 1, MazeMod.CarpetLight, 0, 2);
        world.func_147465_d(x + 5, y + 4, z + 5, MazeMod.CarpetLight, 0, 2);
        for (a2 = 0; a2 < 7; ++a2) {
            for (b2 = 0; b2 < 7; ++b2) {
                world.func_147465_d(x + a2, y, z + b2, (Block)Blocks.field_150349_c, 0, 2);
            }
        }
        for (a2 = 2; a2 < 5; ++a2) {
            for (b2 = 2; b2 < 5; ++b2) {
                world.func_147465_d(x + a2, y, z + b2, Blocks.field_150351_n, 0, 2);
            }
        }
        if ((double)Info.distx > 0.2) {
            BiomeGenBase biome = Info.BiomeX;
            if (biome == MazeMod.getBiome("Village Maze")) {
                for (a = 0; a < 7; ++a) {
                    world.func_147465_d(x + 7, y, z + a, (Block)Blocks.field_150349_c, 0, 2);
                }
                for (a = 2; a < 5; ++a) {
                    world.func_147465_d(x + 7, y, z + a, Blocks.field_150351_n, 0, 2);
                }
            }
            for (a = 5; a < 7; ++a) {
                for (b = 2; b < 5; ++b) {
                    world.func_147465_d(x + a, y, z + b, Blocks.field_150351_n, 0, 2);
                }
            }
        }
        if ((double)Info.distz > 0.2) {
            BiomeGenBase biome = Info.BiomeZ;
            if (biome == MazeMod.getBiome("Village Maze")) {
                for (a = 0; a < 7; ++a) {
                    world.func_147465_d(x + a, y, z + 7, (Block)Blocks.field_150349_c, 0, 2);
                }
                for (a = 2; a < 5; ++a) {
                    world.func_147465_d(x + a, y, z + 7, Blocks.field_150351_n, 0, 2);
                }
            }
            for (a = 5; a < 7; ++a) {
                for (b = 2; b < 5; ++b) {
                    world.func_147465_d(x + b, y, z + a, Blocks.field_150351_n, 0, 2);
                }
            }
        }
        if ((double)Info.distx2 > 0.2) {
            for (int a3 = 0; a3 < 2; ++a3) {
                for (b2 = 2; b2 < 5; ++b2) {
                    world.func_147465_d(x + a3, y, z + b2, Blocks.field_150351_n, 0, 2);
                }
            }
        }
        if ((double)Info.distz2 > 0.2) {
            for (int a4 = 0; a4 < 2; ++a4) {
                for (b2 = 2; b2 < 5; ++b2) {
                    world.func_147465_d(x + b2, y, z + a4, Blocks.field_150351_n, 0, 2);
                }
            }
        }
        MazeSegmentInfo Info2 = Info;
        MazeSegmentInfo Info3 = Info;
        if (Info.layer + 1 < MazeMod.MazeLayers) {
            Info2 = this.getMazeInfo(Info.chunkX, Info.chunkZ, Info.layer + 1);
        }
        if (Info.layer > 0) {
            Info3 = this.getMazeInfo(Info.chunkX, Info.chunkZ, Info.layer - 1);
        }
        if ((rand = this.getRandomiser(new long[]{world.func_72905_C(), Info.chunkX, 48652L, Info.chunkZ, 14562L, Info.layer, 79614L})).nextInt(3) == 0) {
            if (Math.abs(Info.chunkX + Info.chunkZ) % 2 == 0) {
                this.addLargeHouse(Info);
            }
        } else if (!(Info.stairsDN || Info.stairsUP || Info2.stairsDN || Info3.stairsUP)) {
            if (rand.nextInt(30) == 0) {
                this.addWell(Info);
            } else if (rand.nextInt(6) == 0) {
                this.addFarm(Info);
            } else if (rand.nextInt(3) == 0) {
                switch (rand.nextInt(3)) {
                    case 0: {
                        this.addButcher(Info);
                        break;
                    }
                    case 1: {
                        this.addLibrary(Info);
                        break;
                    }
                    case 2: {
                        this.addSmithy(Info);
                    }
                }
            } else {
                this.addTiniHouse(world, x, y, z);
            }
        }
    }

    private void addSmithy(MazeSegmentInfo Info) {
        int a;
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        this.addHut(world, x + 1, y, z + 1, x + 3, y + 3, z + 5, true);
        for (a = 1; a < 6; ++a) {
            world.func_147465_d(x + 4, y, z + a, Blocks.field_150347_e, 0, 2);
            world.func_147465_d(x + 4, y, z + a, Blocks.field_150347_e, 0, 2);
        }
        for (a = 3; a < 6; ++a) {
            for (int b = 1; b < 4; ++b) {
                world.func_147465_d(x + a, y + 1, z + b, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(x + a, y + 3, z + b, Blocks.field_150347_e, 0, 2);
            }
        }
        world.func_147465_d(x + 3, y + 2, z + 1, Blocks.field_150347_e, 0, 2);
        world.func_147465_d(x + 3, y + 2, z + 2, Blocks.field_150347_e, 0, 2);
        world.func_147465_d(x + 3, y + 2, z + 3, Blocks.field_150460_al, 3, 2);
        world.func_147465_d(x + 4, y + 2, z + 1, Blocks.field_150411_aY, 0, 2);
        world.func_147465_d(x + 4, y + 2, z + 3, Blocks.field_150411_aY, 0, 2);
        world.func_147465_d(x + 5, y + 2, z + 1, Blocks.field_150411_aY, 0, 2);
        world.func_147465_d(x + 5, y + 2, z + 2, Blocks.field_150411_aY, 0, 2);
        world.func_147465_d(x + 4, y + 1, z + 2, Blocks.field_150353_l, 0, 2);
        world.func_147468_f(x + 3, y + 1, z + 4);
        world.func_147468_f(x + 3, y + 2, z + 4);
        world.func_147465_d(x + 1, y + 2, z + 4, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 2, y + 2, z + 5, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 5, y + 1, z + 5, Blocks.field_150467_bQ, new Random().nextInt(4) + 8, 2);
        world.func_147465_d(x + 2, y + 1, z + 2, (Block)Blocks.field_150486_ae, 4, 2);
        TileEntityChest tileentitychest = (TileEntityChest)world.func_147438_o(x + 2, y + 1, z + 2);
        Random rand = this.getRandomiser(new long[]{world.func_72905_C(), Info.chunkX, 38451L, Info.chunkZ, 2114L, Info.layer, 36842L});
        if (tileentitychest != null) {
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"villageBlacksmith", (Random)rand), (IInventory)tileentitychest, (int)5);
        }
    }

    private void addButcher(MazeSegmentInfo Info) {
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        this.addHut(world, x + 2, y, z + 1, x + 5, y + 3, z + 5, true);
        this.addDoor(world, x + 2, y + 1, z + 4, 0);
        this.addDoor(world, x + 5, y + 1, z + 2, 2);
        world.func_147465_d(x + 5, y + 2, z + 4, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 2, y + 2, z + 2, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 3, y + 2, z + 5, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 4, y + 1, z + 3, (Block)Blocks.field_150334_T, 0, 2);
        world.func_147465_d(x + 1, y + 1, z + 1, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x, y + 1, z + 1, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x + 1, y + 1, z + 5, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x, y + 1, z + 5, Blocks.field_150422_aJ, 0, 2);
        for (int a = 2; a < 5; ++a) {
            world.func_147465_d(x, y, z + a, (Block)Blocks.field_150349_c, 0, 2);
            world.func_147465_d(x + 1, y, z + a, (Block)Blocks.field_150349_c, 0, 2);
            if (!((double)Info.distx2 > 0.2)) continue;
            world.func_147465_d(x, y + 1, z + a, Blocks.field_150422_aJ, 0, 2);
        }
    }

    private void addLibrary(MazeSegmentInfo Info) {
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        this.addHut(world, x + 1, y, z + 2, x + 5, y + 3, z + 5, true);
        this.addDoor(world, x + 2, y + 1, z + 2, 1);
        world.func_147465_d(x + 4, y + 1, z + 2, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 4, y + 2, z + 2, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 5, y + 2, z + 3, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 4, y + 2, z + 5, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 2, y + 2, z + 5, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 1, y + 2, z + 4, Blocks.field_150410_aZ, 0, 2);
        world.func_147465_d(x + 4, y + 1, z + 4, Blocks.field_150462_ai, 0, 2);
        world.func_147465_d(x + 4, y + 3, z + 4, Blocks.field_150342_X, 0, 2);
        world.func_147465_d(x + 3, y + 3, z + 4, Blocks.field_150342_X, 0, 2);
        world.func_147465_d(x + 2, y + 3, z + 4, Blocks.field_150342_X, 0, 2);
        world.func_147465_d(x + 4, y + 3, z + 3, (Block)Blocks.field_150376_bx, 8, 2);
        world.func_147465_d(x + 3, y + 3, z + 3, (Block)Blocks.field_150376_bx, 8, 2);
        world.func_147465_d(x + 2, y + 3, z + 3, (Block)Blocks.field_150376_bx, 8, 2);
    }

    private void addLargeHouse(MazeSegmentInfo Info) {
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        this.addHut(world, x, y, z, x + 6, y + 4, z + 6, false);
        this.boxReplace(world, Blocks.field_150344_f, 0, Blocks.field_150347_e, 0, x, y, z, x + 6, y + 1, z + 6, "all");
        if ((double)Info.distx2 > 0.2) {
            world.func_147465_d(x, y + 2, z + 1, Blocks.field_150410_aZ, 0, 2);
            this.addDoor(world, x, y + 1, z + 3, 0);
            world.func_147465_d(x, y + 2, z + 5, Blocks.field_150410_aZ, 0, 2);
        }
        if ((double)Info.distz2 > 0.2) {
            world.func_147465_d(x + 1, y + 2, z, Blocks.field_150410_aZ, 0, 2);
            this.addDoor(world, x + 3, y + 1, z, 1);
            world.func_147465_d(x + 5, y + 2, z, Blocks.field_150410_aZ, 0, 2);
        }
        if ((double)Info.distx > 0.2) {
            world.func_147465_d(x + 6, y + 2, z + 1, Blocks.field_150410_aZ, 0, 2);
            this.addDoor(world, x + 6, y + 1, z + 3, 2);
            world.func_147465_d(x + 6, y + 2, z + 5, Blocks.field_150410_aZ, 0, 2);
        }
        if ((double)Info.distz > 0.2) {
            world.func_147465_d(x + 1, y + 2, z + 6, Blocks.field_150410_aZ, 0, 2);
            this.addDoor(world, x + 3, y + 1, z + 6, 3);
            world.func_147465_d(x + 5, y + 2, z + 6, Blocks.field_150410_aZ, 0, 2);
        }
    }

    private void addWell(MazeSegmentInfo Info) {
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (int a = 2; a < 5; ++a) {
            for (int b = 2; b < 5; ++b) {
                world.func_147465_d(x + a, y, z + b, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(x + a, y + 1, z + b, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(x + a, y + 4, z + b, Blocks.field_150347_e, 0, 2);
                world.func_147465_d(x + a, y, z + 1, Blocks.field_150351_n, 0, 2);
                world.func_147465_d(x + a, y, z + 5, Blocks.field_150351_n, 0, 2);
                world.func_147465_d(x + 1, y, z + b, Blocks.field_150351_n, 0, 2);
                world.func_147465_d(x + 5, y, z + b, Blocks.field_150351_n, 0, 2);
            }
        }
        world.func_147465_d(x + 3, y, z + 3, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(x + 3, y + 1, z + 3, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(x + 2, y + 2, z + 2, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x + 4, y + 2, z + 2, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x + 2, y + 2, z + 4, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x + 4, y + 2, z + 4, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x + 2, y + 3, z + 2, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x + 4, y + 3, z + 2, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x + 2, y + 3, z + 4, Blocks.field_150422_aJ, 0, 2);
        world.func_147465_d(x + 4, y + 3, z + 4, Blocks.field_150422_aJ, 0, 2);
    }

    private void addFarm(MazeSegmentInfo Info) {
        World world = Info.world;
        int x = Info.x + 1;
        int z = Info.z + 1;
        int y = Info.y;
        for (int a = 0; a < 7; ++a) {
            for (int b = 0; b < 7; ++b) {
                world.func_147465_d(x + a, y + 1, z + b, Blocks.field_150364_r, 0, 2);
            }
        }
        Block crop1 = Blocks.field_150464_aj;
        Block crop2 = Blocks.field_150464_aj;
        Random rand = this.getRandomiser(new long[]{world.func_72905_C(), Info.chunkX, 48652L, Info.chunkZ, 14562L, Info.layer, 79614L});
        if (rand.nextBoolean()) {
            crop1 = rand.nextBoolean() ? Blocks.field_150459_bM : Blocks.field_150469_bN;
        }
        if (rand.nextBoolean()) {
            crop2 = rand.nextBoolean() ? Blocks.field_150459_bM : Blocks.field_150469_bN;
        }
        boolean dir = rand.nextBoolean();
        for (int a = 1; a < 6; ++a) {
            if (dir) {
                world.func_147465_d(x + a, y + 1, z + 1, Blocks.field_150458_ak, 7, 2);
                world.func_147465_d(x + a, y + 1, z + 2, Blocks.field_150458_ak, 7, 2);
                world.func_147465_d(x + a, y + 1, z + 3, Blocks.field_150355_j, 0, 2);
                world.func_147465_d(x + a, y + 1, z + 4, Blocks.field_150458_ak, 7, 2);
                world.func_147465_d(x + a, y + 1, z + 5, Blocks.field_150458_ak, 7, 2);
                world.func_147465_d(x + a, y + 2, z + 1, crop2, 7, 2);
                world.func_147465_d(x + a, y + 2, z + 2, crop2, 7, 2);
                world.func_147465_d(x + a, y + 2, z + 4, crop1, 7, 2);
                world.func_147465_d(x + a, y + 2, z + 5, crop1, 7, 2);
                continue;
            }
            world.func_147465_d(x + 1, y + 1, z + a, Blocks.field_150458_ak, 7, 2);
            world.func_147465_d(x + 2, y + 1, z + a, Blocks.field_150458_ak, 7, 2);
            world.func_147465_d(x + 3, y + 1, z + a, Blocks.field_150355_j, 0, 2);
            world.func_147465_d(x + 4, y + 1, z + a, Blocks.field_150458_ak, 7, 2);
            world.func_147465_d(x + 5, y + 1, z + a, Blocks.field_150458_ak, 7, 2);
            world.func_147465_d(x + 1, y + 2, z + a, crop2, 7, 2);
            world.func_147465_d(x + 2, y + 2, z + a, crop2, 7, 2);
            world.func_147465_d(x + 4, y + 2, z + a, crop1, 7, 2);
            world.func_147465_d(x + 5, y + 2, z + a, crop1, 7, 2);
        }
    }

    private void addTiniHouse(World world, int x, int y, int z) {
        this.addHut(world, x + 2, y, z + 2, x + 4, y + 3, z + 4, true);
        switch (new Random().nextInt(4)) {
            case 0: {
                this.addDoor(world, x + 2, y + 1, z + 3, 0);
                break;
            }
            case 1: {
                this.addDoor(world, x + 3, y + 1, z + 2, 1);
                break;
            }
            case 2: {
                this.addDoor(world, x + 4, y + 1, z + 3, 2);
                break;
            }
            case 3: {
                this.addDoor(world, x + 3, y + 1, z + 4, 3);
            }
        }
    }

    private void addDoor(World world, int x, int y, int z, int dir) {
        world.func_147465_d(x, y, z, Blocks.field_150466_ao, dir, 2);
        world.func_147465_d(x, y + 1, z, Blocks.field_150466_ao, 9, 2);
    }

    private void addHut(World world, int x, int y, int z, int x2, int y2, int z2, boolean roof) {
        for (int i = x; i <= x2; ++i) {
            for (int k = z; k <= z2; ++k) {
                world.func_147465_d(i, y, k, Blocks.field_150347_e, 0, 2);
                block7: for (int j = y + 1; j <= y2; ++j) {
                    int type = 0;
                    if (i == x || i == x2) {
                        ++type;
                    }
                    if (j == y || j == y2) {
                        ++type;
                    }
                    if (k == z || k == z2) {
                        ++type;
                    }
                    switch (type) {
                        case 1: {
                            if (j == y2 && !roof) continue block7;
                            world.func_147465_d(i, j, k, Blocks.field_150344_f, 0, 2);
                            continue block7;
                        }
                        case 2: {
                            if (i != x && i != x2) {
                                world.func_147465_d(i, j, k, Blocks.field_150364_r, 4, 2);
                                continue block7;
                            }
                            if (j != y && j != y2) {
                                world.func_147465_d(i, j, k, Blocks.field_150364_r, 0, 2);
                                continue block7;
                            }
                            if (k == z || k == z2) continue block7;
                            world.func_147465_d(i, j, k, Blocks.field_150364_r, 8, 2);
                            continue block7;
                        }
                        case 3: {
                            world.func_147465_d(i, j, k, Blocks.field_150364_r, 0, 2);
                        }
                    }
                }
            }
        }
    }

    private void setSwampWater(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 11758L, z, 95144L, y, 33455L});
        world.func_147465_d(x, y, z, Blocks.field_150355_j, 0, 2);
        if (random.nextInt(10) == 0) {
            world.func_147465_d(x, y + 1, z, Blocks.field_150392_bi, 0, 2);
        }
    }

    private void addTrunks(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 24513L, z, 48516L, y, 34678L});
        if (random.nextInt(20) == 0) {
            int n = random.nextInt(6);
            block8: for (int a = 1; a < 5; ++a) {
                switch (n) {
                    case 0: {
                        world.func_147465_d(x, y + a, z, Blocks.field_150364_r, 0, 2);
                        continue block8;
                    }
                    case 1: {
                        world.func_147465_d(x, y + a, z, Blocks.field_150364_r, 1, 2);
                        continue block8;
                    }
                    case 2: {
                        world.func_147465_d(x, y + a, z, Blocks.field_150364_r, 2, 2);
                        continue block8;
                    }
                    case 3: {
                        world.func_147465_d(x, y + a, z, Blocks.field_150364_r, 3, 2);
                        continue block8;
                    }
                    case 4: {
                        world.func_147465_d(x, y + a, z, Blocks.field_150363_s, 0, 2);
                        continue block8;
                    }
                    case 5: {
                        world.func_147465_d(x, y + a, z, Blocks.field_150363_s, 1, 2);
                    }
                }
            }
        }
    }

    private void setleaves(World world, int x, int y, int z, boolean decay) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 24513L, z, 48516L, y, 34678L});
        switch (random.nextInt(6)) {
            case 0: {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150362_t, 0 + (decay ? 4 : 0), 2);
                break;
            }
            case 1: {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150362_t, 1 + (decay ? 4 : 0), 2);
                break;
            }
            case 2: {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150362_t, 2 + (decay ? 4 : 0), 2);
                break;
            }
            case 3: {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150362_t, 3 + (decay ? 4 : 0), 2);
                break;
            }
            case 4: {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150361_u, 0 + (decay ? 4 : 0), 2);
                break;
            }
            case 5: {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150361_u, 1 + (decay ? 4 : 0), 2);
            }
        }
    }

    private void addEndCristal(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            EntityEnderCrystal entity = new EntityEnderCrystal(world, (double)x + 0.5, (double)y + 0.75, (double)z + 0.5);
            world.func_72838_d((Entity)entity);
        }
    }

    private void setDesert(World world, int x, int y, int z) {
        Random rand = this.getRandomiser(new long[]{world.func_72905_C(), x, 16324L, z, 75642L, y, 11224L});
        world.func_147465_d(x, y, z, (Block)Blocks.field_150354_m, 0, 2);
        int a = 0;
        if (rand.nextInt(5) == 0) {
            world.func_147465_d(x, y, z, Blocks.field_150322_A, rand.nextInt(3), 2);
            world.func_147465_d(x, y + 1, z, (Block)Blocks.field_150354_m, 0, 2);
            ++a;
        }
        if (rand.nextInt(15) == 0) {
            int c = rand.nextInt(3) + 2;
            for (int b = 1; b < c; ++b) {
                world.func_147465_d(x, y + a + b, z, Blocks.field_150434_aF, 0, 2);
            }
        }
    }

    private void setFence(World world, int x, int y, int z) {
        if ((x + z) % 2 == 0) {
            world.func_147465_d(x, y, z, Blocks.field_150422_aJ, 0, 2);
        } else {
            world.func_147465_d(x, y, z, Blocks.field_150386_bk, 0, 2);
        }
    }

    private void setClay(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), y, 75624L, x / 64, 24861L, z / 64, 33511L});
        if (random.nextBoolean()) {
            world.func_147465_d(x, y, z, Blocks.field_150406_ce, random.nextInt(16), 2);
        } else {
            world.func_147465_d(x, y, z, Blocks.field_150405_ch, 0, 2);
        }
    }

    private void setRainbow(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 79542L, z, 62145L, y, 74581L});
        world.func_147465_d(x, y, z, Blocks.field_150325_L, random.nextInt(16), 2);
    }

    private void setIce(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 13675L, z, 11111L, y, 44455L});
        Block block = Blocks.field_150432_aD;
        if (random.nextBoolean()) {
            block = Blocks.field_150403_cj;
        }
        world.func_147465_d(x, y, z, block, 0, 2);
    }

    private void setQuartz(World world, int x, int y, int z) {
        switch ((y - 4) % 6) {
            case 0: {
                world.func_147465_d(x, y, z, Blocks.field_150371_ca, 0, 2);
                break;
            }
            case 1: {
                world.func_147465_d(x, y, z, Blocks.field_150371_ca, 1, 2);
                break;
            }
            case 2: {
                world.func_147465_d(x, y, z, Blocks.field_150371_ca, 2, 2);
                break;
            }
            case 3: {
                world.func_147465_d(x, y, z, Blocks.field_150371_ca, 2, 2);
                break;
            }
            case 4: {
                world.func_147465_d(x, y, z, Blocks.field_150371_ca, 2, 2);
            }
        }
    }

    private void setGrass(World world, int x, int y, int z) {
        Random rand = this.getRandomiser(new long[]{world.func_72905_C(), x, 46275L, z, 76241L, y, 97642L});
        world.func_147465_d(x, y, z, (Block)Blocks.field_150349_c, 0, 2);
        if (rand.nextInt(30) == 0) {
            Blocks.field_150349_c.func_149853_b(world, rand, x, y, z);
        }
    }

    private void setCobbleStone(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 33448L, z, 75541L, y, 16654L});
        Block block = Blocks.field_150347_e;
        if (random.nextBoolean()) {
            block = Blocks.field_150341_Y;
        }
        world.func_147465_d(x, y, z, block, 0, 2);
    }

    private void setNetherrack(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 11758L, z, 95144L, y, 33455L});
        world.func_147465_d(x, y, z, Blocks.field_150424_aL, 0, 2);
        if (random.nextInt(10) == 0) {
            world.func_147465_d(x, y + 1, z, (Block)Blocks.field_150480_ab, 0, 2);
        }
    }

    private void setStoneBrick(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 77577L, z, 44666L, y, 666L});
        Block block = Blocks.field_150417_aV;
        int meta = 0;
        if (random.nextInt(10) == 0) {
            block = Blocks.field_150418_aU;
            meta = 2;
        }
        if (random.nextInt(6) == 0) {
            meta = random.nextBoolean() ? (meta += 2) : ++meta;
        }
        world.func_147465_d(x, y, z, block, meta, 2);
    }

    private void setOre(World world, int x, int y, int z) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), x, 46512L, z, 46515L, y, 16845L});
        int num = random.nextInt(400);
        if (num < 20) {
            world.func_147465_d(x, y, z, Blocks.field_150365_q, 0, 2);
        } else if (num < 30) {
            world.func_147465_d(x, y, z, Blocks.field_150366_p, 0, 2);
        } else if (num < 38) {
            world.func_147465_d(x, y, z, Blocks.field_150450_ax, 0, 2);
        } else if (num < 46) {
            world.func_147465_d(x, y, z, Blocks.field_150369_x, 0, 2);
        } else if (num < 52) {
            world.func_147465_d(x, y, z, Blocks.field_150352_o, 0, 2);
        } else if (num < 55) {
            world.func_147465_d(x, y, z, Blocks.field_150482_ag, 0, 2);
        } else if (num < 56) {
            world.func_147465_d(x, y, z, Blocks.field_150412_bA, 0, 2);
        } else {
            world.func_147465_d(x, y, z, Blocks.field_150348_b, 0, 2);
        }
    }

    private Random getRandomiser(long[] n) {
        Random random = new Random();
        random.setSeed(n[0]);
        for (int a = 1; a < n.length; a += 2) {
            random.setSeed(random.nextLong() + n[a] * n[a + 1]);
        }
        return random;
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        return false;
    }

    public MazeSegmentInfo getMazeInfo(int chunkX, int chunkZ, int layer) {
        if (layer < 0) {
            layer = 0;
        }
        if (layer >= MazeMod.MazeLayers) {
            layer = MazeMod.MazeLayers - 1;
        }
        MazeSegmentInfo[] MazeInfochunk = this.MazeInfo[Math.abs(chunkX) % 2 + 2 * (Math.abs(chunkZ) % 2)];
        return MazeInfochunk[layer];
    }

    public void boxReplace(World world, Block BlockID, int meta, Block BlockID2, int meta2, int i, int j, int k, int i2, int j2, int k2, String Pattern) {
        for (int x = i; x <= i2; ++x) {
            for (int y = j; y <= j2; ++y) {
                for (int z = k; z <= k2; ++z) {
                    if (world.func_147439_a(x, y, z) != BlockID || world.func_72805_g(x, y, z) != meta) continue;
                    if (Pattern == "chekers" && (x + y + z) % 2 == 0) {
                        world.func_147465_d(x, y, z, BlockID2, meta2, 2);
                    }
                    if (Pattern == "all") {
                        world.func_147465_d(x, y, z, BlockID2, meta2, 2);
                    }
                    if (Pattern != "random" || !new Random().nextBoolean()) continue;
                    world.func_147465_d(x, y, z, BlockID2, meta2, 2);
                }
            }
        }
    }
}

