/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.extratic.tileentities;

import glassmaker.extratic.common.BlockHandler;
import glassmaker.extratic.tileentities.TileEntitySocket;
import mantle.blocks.abstracts.MultiServantLogic;
import mantle.blocks.iface.IMasterLogic;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import tconstruct.smeltery.logic.SmelteryLogic;

public class TileEntityArcSmeltery
extends SmelteryLogic {
    boolean validBlock(Block block) {
        return block == BlockHandler.arcSmeltery;
    }

    boolean validSocket(Block block) {
        return block == BlockHandler.arcSocket;
    }

    int checkSmelteryBlocks(int x, int y, int z) {
        int tempBricks = 0;
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (this.validBlock(block) || this.validSocket(block)) {
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (te == this) {
                ++tempBricks;
            } else if (te instanceof MultiServantLogic) {
                MultiServantLogic servant = (MultiServantLogic)te;
                if (servant.hasValidMaster()) {
                    if (servant.verifyMaster((IMasterLogic)this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                        ++tempBricks;
                    }
                } else {
                    servant.overrideMaster(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    ++tempBricks;
                }
                if (te instanceof TileEntitySocket) {
                    this.lavaTanks.add(new CoordTuple((double)x, (double)y, (double)z));
                }
            }
        }
        return tempBricks;
    }

    public int recurseStructureDown(int x, int y, int z, int[] sides, int count) {
        boolean check = this.checkBricksOnLevel(x, y, z, sides);
        if (!check) {
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (block != null && !this.field_145850_b.func_147437_c(x, y, z) && this.validBlock(block)) {
                return this.validateBottom(x, y, z, sides, count);
            }
            return count;
        }
        return this.recurseStructureDown(x, y - 1, z, sides, ++count);
    }

    public int validateBottom(int x, int y, int z, int[] sides, int count) {
        int bottomBricks = 0;
        int xMin = x - sides[0] + 1;
        int xMax = x + sides[1] - 1;
        int zMin = z - sides[2] + 1;
        int zMax = z + sides[3] - 1;
        for (int xPos = xMin; xPos <= xMax; ++xPos) {
            for (int zPos = zMin; zPos <= zMax; ++zPos) {
                TileEntity te;
                if (!this.validBlock(this.field_145850_b.func_147439_a(xPos, y, zPos)) || this.field_145850_b.func_72805_g(xPos, y, zPos) < 2 || !((te = this.field_145850_b.func_147438_o(xPos, y, zPos)) instanceof MultiServantLogic)) continue;
                MultiServantLogic servant = (MultiServantLogic)te;
                if (servant.hasValidMaster()) {
                    if (!servant.verifyMaster((IMasterLogic)this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) continue;
                    ++bottomBricks;
                    continue;
                }
                servant.overrideMaster(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                ++bottomBricks;
            }
        }
        int neededBricks = (xMax + 1 - xMin) * (zMax + 1 - zMin);
        if (bottomBricks == neededBricks) {
            this.tempValidStructure = true;
            this.minPos = new CoordTuple((double)xMin, (double)(y + 1), (double)zMin);
            this.maxPos = new CoordTuple((double)xMax, (double)(y + 1), (double)zMax);
        }
        return count;
    }

    public boolean checkBricksOnLevel(int x, int y, int z, int[] sides) {
        int xPos;
        int numBricks = 0;
        int xMin = x - sides[0];
        int xMax = x + sides[1];
        int zMin = z - sides[2];
        int zMax = z + sides[3];
        for (xPos = xMin + 1; xPos <= xMax - 1; ++xPos) {
            for (int zPos = zMin + 1; zPos <= zMax - 1; ++zPos) {
                Block block = this.field_145850_b.func_147439_a(xPos, y, zPos);
                if (block == null || this.field_145850_b.func_147437_c(xPos, y, zPos)) continue;
                return false;
            }
        }
        for (xPos = xMin + 1; xPos <= xMax - 1; ++xPos) {
            numBricks += this.checkSmelteryBlocks(xPos, y, zMin);
            numBricks += this.checkSmelteryBlocks(xPos, y, zMax);
        }
        for (int zPos = zMin + 1; zPos <= zMax - 1; ++zPos) {
            numBricks += this.checkSmelteryBlocks(xMin, y, zPos);
            numBricks += this.checkSmelteryBlocks(xMax, y, zPos);
        }
        int neededBricks = (xMax - xMin) * 2 + (zMax - zMin) * 2 - 4;
        return numBricks == neededBricks;
    }

    public void checkValidStructure(int x, int y, int z, int[] sides) {
        int checkLayers = 0;
        this.tempValidStructure = false;
        if (this.checkSameLevel(x, y, z, sides)) {
            ++checkLayers;
            checkLayers += this.recurseStructureUp(x, y + 1, z, sides, 0);
            checkLayers += this.recurseStructureDown(x, y - 1, z, sides, 0);
        }
        if (this.tempValidStructure != this.validStructure || checkLayers != this.layers) {
            if (this.tempValidStructure) {
                this.activeLavaTank = null;
                for (CoordTuple tank : this.lavaTanks) {
                    TileEntity tankContainer = this.field_145850_b.func_147438_o(tank.x, tank.y, tank.z);
                    if (!(tankContainer instanceof TileEntitySocket)) continue;
                    this.internalTemp = 300;
                    this.activeLavaTank = tank;
                    break;
                }
                if (this.activeLavaTank == null) {
                    this.activeLavaTank = (CoordTuple)this.lavaTanks.get(0);
                }
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.validStructure = true;
            } else {
                this.internalTemp = 20;
                if (this.validStructure) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                this.validStructure = false;
            }
        }
    }
}

