/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.RenderUtils;
import codechicken.nei.KeyManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

public class WorldOverlayRenderer
implements KeyManager.IKeyStateTracker {
    public static int mobOverlay = 0;
    public static int chunkOverlay = 0;
    private static Entity dummyEntity = new EntityPig(null);
    private static AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public static void reset() {
        mobOverlay = 0;
        chunkOverlay = 0;
    }

    @Override
    public void tickKeyStates() {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (KeyManager.keyStates.get((Object)"world.moboverlay").down) {
            mobOverlay = (mobOverlay + 1) % 2;
        }
        if (KeyManager.keyStates.get((Object)"world.chunkoverlay").down) {
            chunkOverlay = (chunkOverlay + 1) % 3;
        }
    }

    public static void render(float frame) {
        GL11.glPushMatrix();
        EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
        RenderUtils.translateToWorldCoords((Entity)entity, (float)frame);
        WorldOverlayRenderer.renderChunkBounds((Entity)entity);
        WorldOverlayRenderer.renderMobSpawnOverlay((Entity)entity);
        GL11.glPopMatrix();
    }

    private static void renderMobSpawnOverlay(Entity entity) {
        if (mobOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        int curSpawnMode = 2;
        World world = entity.field_70170_p;
        int x1 = (int)entity.field_70165_t;
        int z1 = (int)entity.field_70161_v;
        int y1 = (int)MathHelper.clip((double)entity.field_70163_u, (double)16.0, (double)(world.func_72800_K() - 16));
        for (int x = x1 - 16; x <= x1 + 16; ++x) {
            for (int z = z1 - 16; z <= z1 + 16; ++z) {
                Chunk chunk = world.func_72938_d(x, z);
                BiomeGenBase biome = world.func_72807_a(x, z);
                if (biome.func_76747_a(EnumCreatureType.monster).isEmpty() || biome.func_76741_f() <= 0.0f) continue;
                for (int y = y1 - 16; y < y1 + 16; ++y) {
                    int spawnMode = WorldOverlayRenderer.getSpawnMode(chunk, x, y, z);
                    if (spawnMode == 0) continue;
                    if (spawnMode != curSpawnMode) {
                        if (spawnMode == 1) {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        curSpawnMode = spawnMode;
                    }
                    GL11.glVertex3d((double)x, (double)((double)y + 0.004), (double)z);
                    GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.004), (double)(z + 1));
                    GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.004), (double)z);
                    GL11.glVertex3d((double)x, (double)((double)y + 0.004), (double)(z + 1));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static int getSpawnMode(Chunk chunk, int x, int y, int z) {
        if (!SpawnerAnimals.func_77190_a((EnumCreatureType)EnumCreatureType.monster, (World)chunk.field_76637_e, (int)x, (int)y, (int)z) || chunk.func_76614_a(EnumSkyBlock.Block, x & 0xF, y, z & 0xF) >= 8) {
            return 0;
        }
        WorldOverlayRenderer.aabb.field_72340_a = (double)x + 0.2;
        WorldOverlayRenderer.aabb.field_72336_d = (double)x + 0.8;
        WorldOverlayRenderer.aabb.field_72338_b = (double)y + 0.01;
        WorldOverlayRenderer.aabb.field_72337_e = (double)y + 1.8;
        WorldOverlayRenderer.aabb.field_72339_c = (double)z + 0.2;
        WorldOverlayRenderer.aabb.field_72334_f = (double)z + 0.8;
        if (!chunk.field_76637_e.func_72855_b(aabb) || !chunk.field_76637_e.func_72945_a(dummyEntity, aabb).isEmpty() || chunk.field_76637_e.func_72953_d(aabb)) {
            return 0;
        }
        if (chunk.func_76614_a(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF) >= 8) {
            return 1;
        }
        return 2;
    }

    private static void renderChunkBounds(Entity entity) {
        if (chunkOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        for (int cx = -4; cx <= 4; ++cx) {
            for (int cz = -4; cz <= 4; ++cz) {
                double x1 = entity.field_70176_ah + cx << 4;
                double z1 = entity.field_70164_aj + cz << 4;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.field_70163_u - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.field_70170_p.func_72800_K()) {
                    y2 = entity.field_70170_p.func_72800_K();
                    y1 = y2 - dy;
                }
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                GL11.glColor4d((double)0.9, (double)0.0, (double)0.0, (double)dist);
                if (cx >= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                }
                if (cx >= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                }
                if (cx <= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                }
                if (cx <= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                }
                if (chunkOverlay != 2 || cx != 0 || cz != 0) continue;
                dy = 32.0;
                y1 = Math.floor(entity.field_70163_u - dy / 2.0);
                y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.field_70170_p.func_72800_K()) {
                    y2 = entity.field_70170_p.func_72800_K();
                    y1 = y2 - dy;
                }
                GL11.glColor4d((double)0.0, (double)0.9, (double)0.0, (double)0.4);
                for (double y = (double)((int)y1); y <= y2; y += 1.0) {
                    GL11.glVertex3d((double)x2, (double)y, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y, (double)z1);
                }
                for (double h = 1.0; h <= 15.0; h += 1.0) {
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z2);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x1, (double)y2, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y2, (double)(z1 + h));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void load() {
        KeyManager.trackers.add(new WorldOverlayRenderer());
    }
}

