/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.common;

import glenn.gases.common.gastype.GasTypeChlorine;
import glenn.moddingutils.Configurations;
import java.io.File;

public class GasesMainConfigurations
extends Configurations {
    @Configurations.ConfigField(path="worldgen.overworld.gases.Natural gas", comment="The frequency of natural gas pockets per 16x16x16 blocks", defaultValue="1.0")
    public float worldGenGreenGas;
    @Configurations.ConfigField(path="worldgen.overworld.gases.Red gas", comment="The frequency of red gas pockets per 16x16x16 blocks", defaultValue="0.5")
    public float worldGenRedGas;
    @Configurations.ConfigField(path="worldgen.overworld.gases.Nitrous gas", comment="The frequency of nitrous gas pockets per 16x16x16 blocks", defaultValue="0.5")
    public float worldGenNitrousGas;
    @Configurations.ConfigField(path="worldgen.overworld.gases.Chlorine gas", comment="The frequency of chlorine gas pockets per 16x16x16 blocks", defaultValue="0.25")
    public float worldGenChlorineGas;
    @Configurations.ConfigField(path="worldgen.overworld.gases.Iocalfaeus gas", comment="The frequency of iocalfaeus gas pockets per 16x16x16 blocks", defaultValue="0.125")
    public float worldGenLightSensitiveGas;
    @Configurations.ConfigField(path="worldgen.overworld.gases.Iocalfaeus gas", comment="The frequency of helium pockets per 16x16x16 blocks", defaultValue="0.5")
    public float worldGenHelium;
    @Configurations.ConfigField(path="worldgen.overworld.gases.Black damp", comment="The frequency of black damp clouds per 16x16x16 blocks", defaultValue="0.25")
    public float worldGenBlackDamp;
    @Configurations.ConfigField(path="worldgen.overworld.Gas pipe.Generation checks", comment="The amount of times pipes will be attempted generated underground", defaultValue="32")
    public int world_generatePipes;
    @Configurations.ConfigField(path="worldgen.nether.gases.Electric gas", comment="The frequency of electric gas clouds in the nether per 16x16x16 blocks", defaultValue="0.125")
    public float worldGenElectricGas;
    @Configurations.ConfigField(path="worldgen.end.gases.Finine", comment="The frequency of finine gas clouds in the nether per 16x16x16 blocks", defaultValue="0.03125")
    public float worldGenFinineGas;
    @Configurations.ConfigField(path="worldgen.nether.gases.Corrosive gas", comment="The frequency of corrosive gas clouds in the nether per 16x16x16 blocks", defaultValue="0.125")
    public float worldGenCorrosiveGas;
    @Configurations.ConfigField(path="worldgen.Diabaline ore.Commonness", comment="The commonness of diabaline in the walls of gas pockets", defaultValue="0.0625")
    public float world_gasPocketDiabalineChance;
    @Configurations.ConfigField(path="gases.Void gas.Max height", comment="The maximal height at which void gas can appear", defaultValue="64")
    public int gases_voidGasMaxHeight;
    @Configurations.ConfigField(path="gases.Corrosive gas.Corrosive power", comment="The block hardness threshold for block corrosion", defaultValue="2.0")
    public float gases_maxHardnessForCorrosion;
    @Configurations.ConfigField(path="gases.Coal dust.Amount", comment="The amount of coal dust that will be generated by breaking coal ore from 0 to 16", defaultValue="16")
    public int gases_coalDustOnMine;
    @Configurations.ConfigField(path="gases.Steam.Amount", comment="The amount of steam that will be generated by reactions from 0 to 16", defaultValue="16")
    public int gases_steamOnReaction;
    @Configurations.ConfigField(path="gases.Dust.Amount", comment="The amount of dust that will be generated by breaking stone from 0 to 16", defaultValue="3")
    public int gases_dustOnMine;
    @Configurations.ConfigField(path="gases.Chlorine gas.Destroyable materials", comment="Tool/armor materials that can be destroyed by chlorine gas", defaultValue="IRON\nCHAIN")
    public String[] gases_destroyableByChlorine;
    @Configurations.ConfigField(path="gases.Finine.Max teleportation searches", comment="Maximum searches Finine will conduct to find a suitable teleportation location", defaultValue="20")
    public int maxFinineTeleportSearches;
    @Configurations.ConfigField(path="other.Enable diamond smelt", comment="If true, a full stack of coal can be smelted into a diamond in a gas furnace", defaultValue="true")
    public boolean other_enableDiamondSmelt;
    @Configurations.ConfigField(path="updatechecker.Enable", comment="Allow Glenn's Gases to automatically check for updates", defaultValue="true")
    public boolean other_enableUpdateCheck;

    public GasesMainConfigurations(File configurationsFile) {
        super(configurationsFile);
    }

    @Override
    protected void onLoaded() {
        for (String s : this.gases_destroyableByChlorine) {
            GasTypeChlorine.materialsToDamage.add(s);
        }
    }
}

