/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.common.gastype;

import glenn.gases.Gases;
import glenn.gasesframework.api.Combustibility;
import glenn.gasesframework.api.gastype.GasType;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.AxisAlignedBB;

public class GasTypeFinine
extends GasType {
    private final Set<Class<?>> typeFilter = Collections.newSetFromMap(new IdentityHashMap());

    private boolean isValidEntityClass(Class<?> clazz) {
        for (Class<?> clazz1 : this.typeFilter) {
            if (!clazz1.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public GasTypeFinine(boolean isIndustrial, int gasID, String name, int color, int opacity, int density, Combustibility combustibility) {
        super(isIndustrial, gasID, name, color, opacity, density, combustibility);
        this.typeFilter.add(EntityLivingBase.class);
        this.typeFilter.add(EntityItem.class);
        this.typeFilter.add(IProjectile.class);
        this.typeFilter.add(EntityBoat.class);
        this.typeFilter.add(EntityMinecart.class);
        this.typeFilter.add(EntityTNTPrimed.class);
        this.typeFilter.add(EntityFireworkRocket.class);
        this.typeFilter.add(EntityXPOrb.class);
    }

    @Override
    public Block tweakGasBlock(Block block) {
        block.func_149715_a(0.5f);
        return super.tweakGasBlock(block);
    }

    @Override
    public void onTouched(Entity entity) {
        Random rand = entity.field_70170_p.field_73012_v;
        if (this.isValidEntityClass(entity.getClass()) && rand.nextInt(4) == 0) {
            for (int i = 0; i < Gases.configurations.maxFinineTeleportSearches; ++i) {
                double x = (rand.nextDouble() - rand.nextDouble()) * 4.0;
                double y = (rand.nextDouble() - rand.nextDouble()) * 4.0;
                double z = (rand.nextDouble() - rand.nextDouble()) * 4.0;
                AxisAlignedBB aabb = entity.field_70121_D.func_72329_c().func_72317_d(x, y, z);
                if (!entity.field_70170_p.func_72945_a(entity, aabb).isEmpty()) continue;
                entity.func_85030_a("minecraft:mob.endermen.portal", 1.0f, 1.0f);
                entity.func_70107_b(entity.field_70165_t + x, entity.field_70163_u + y, entity.field_70161_v + z);
                entity.func_70016_h(0.0, 0.0, 0.0);
                entity.field_70125_A = rand.nextFloat() * 180.0f - 90.0f;
                entity.field_70177_z = rand.nextFloat() * 360.0f;
                entity.func_85030_a("minecraft:mob.endermen.portal", 1.0f, 1.0f);
                break;
            }
        }
    }
}

