/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.common.worldgen;

import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.moddingutils.IVec;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenPipes
extends WorldGenerator {
    protected Block pipeBlock;
    protected HashSet<IVec> pipePlacements;

    public WorldGenPipes(Block pipeBlock) {
        this.pipeBlock = pipeBlock;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150350_a) {
            return false;
        }
        this.pipePlacements = new HashSet();
        this.branch(world, random, x, y, z);
        if (this.pipePlacements.size() > 6) {
            for (IVec pipe : this.pipePlacements) {
                if (random.nextInt(12) == 0) continue;
                world.func_147449_b(pipe.x, pipe.y, pipe.z, this.pipeBlock);
            }
        }
        return true;
    }

    protected Block getBlock(World world, int x, int y, int z) {
        if (this.pipePlacements.contains(new IVec(x, y, z))) {
            return this.pipeBlock;
        }
        return world.func_147439_a(x, y, z);
    }

    protected void branch(World world, Random random, int x, int y, int z) {
        boolean[] sides = new boolean[6];
        int generationChance = 1;
        for (int i = 0; i < 6; ++i) {
            int yDirection;
            int xDirection;
            int n = i == 4 ? 1 : (xDirection = i == 5 ? -1 : 0);
            int n2 = i == 0 ? 1 : (yDirection = i == 1 ? -1 : 0);
            int zDirection = i == 2 ? 1 : (i == 3 ? -1 : 0);
            Block block = this.getBlock(world, x + xDirection, y + yDirection, z + zDirection);
            if (block.func_149662_c()) {
                sides[i] = true;
                continue;
            }
            if (block != Blocks.field_150350_a) continue;
            ++generationChance;
        }
        generationChance = generationChance / 2 + 1;
        boolean[] blArray = new boolean[6];
        boolean bl = random.nextInt(generationChance) == 0 && this.getBlock(world, x, y + 1, z) == Blocks.field_150350_a & (sides[2] | sides[3] | sides[4] | sides[5]) ? true : (blArray[0] = false);
        boolean bl2 = random.nextInt(generationChance) == 0 && this.getBlock(world, x, y - 1, z) == Blocks.field_150350_a & (sides[2] | sides[3] | sides[4] | sides[5]) ? true : (blArray[1] = false);
        boolean bl3 = random.nextInt(generationChance) == 0 && this.getBlock(world, x, y, z + 1) == Blocks.field_150350_a & (sides[0] | sides[1] | sides[4] | sides[5]) ? true : (blArray[2] = false);
        boolean bl4 = random.nextInt(generationChance) == 0 && this.getBlock(world, x, y, z - 1) == Blocks.field_150350_a & (sides[0] | sides[1] | sides[4] | sides[5]) ? true : (blArray[3] = false);
        boolean bl5 = random.nextInt(generationChance) == 0 && this.getBlock(world, x + 1, y, z) == Blocks.field_150350_a & (sides[0] | sides[1] | sides[2] | sides[3]) ? true : (blArray[4] = false);
        blArray[5] = random.nextInt(generationChance) == 0 && this.getBlock(world, x - 1, y, z) == Blocks.field_150350_a & (sides[0] | sides[1] | sides[2] | sides[3]);
        boolean[] possibleDirections = blArray;
        int nPossibleDirections = 0;
        for (int i = 0; i < 6; ++i) {
            if (!possibleDirections[i]) continue;
            ++nPossibleDirections;
        }
        if (nPossibleDirections > 0) {
            this.pipePlacements.add(new IVec(x, y, z));
        }
        while (nPossibleDirections > 0) {
            int direction = random.nextInt(6);
            if (!possibleDirections[direction]) continue;
            possibleDirections[direction] = false;
            --nPossibleDirections;
            this.generatePipe(world, random, x, y, z, ForgeDirection.VALID_DIRECTIONS[direction]);
        }
    }

    protected void generatePipe(World world, Random random, int x, int y, int z, ForgeDirection startDirection) {
        int support = 2;
        for (int i = 0; i < 10 && support > 0 && world.func_147437_c(x += startDirection.offsetX, y += startDirection.offsetY, z += startDirection.offsetZ); ++i) {
            boolean flag = false;
            boolean flag2 = false;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (direction.getOpposite() == startDirection) continue;
                int x1 = x + direction.offsetX;
                int y1 = y + direction.offsetY;
                int z1 = z + direction.offsetZ;
                Block block = this.getBlock(world, x1, y1, z1);
                if (block.func_149662_c()) {
                    flag = true;
                    continue;
                }
                if (GasesFrameworkAPI.getGasPipeType(world, x1, y1, z1) == null) continue;
                flag2 = true;
            }
            support = flag2 ? -1 : (flag ? 2 : --support);
            int x1 = x + startDirection.offsetX;
            int y1 = y + startDirection.offsetY;
            int z1 = z + startDirection.offsetZ;
            Block block = this.getBlock(world, x1, y1, z1);
            if (support == 2 && random.nextInt(10) == 0 || random.nextInt(2) == 0 && block != Blocks.field_150350_a && GasesFrameworkAPI.getGasPipeType(world, x1, y1, z1) == null) {
                this.branch(world, random, x, y, z);
                break;
            }
            this.pipePlacements.add(new IVec(x, y, z));
        }
    }
}

