/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleRegistry;
import magicbees.api.MagicBeesAPI;
import magicbees.bees.AlleleFloat;
import magicbees.bees.AlleleFlower;
import magicbees.bees.BeeSpecies;
import magicbees.bees.allele.effect.AlleleEffectCrumbling;
import magicbees.bees.allele.effect.AlleleEffectCure;
import magicbees.bees.allele.effect.AlleleEffectEmpowering;
import magicbees.bees.allele.effect.AlleleEffectNodeConversion;
import magicbees.bees.allele.effect.AlleleEffectNodeRepair;
import magicbees.bees.allele.effect.AlleleEffectPotion;
import magicbees.bees.allele.effect.AlleleEffectRecharge;
import magicbees.bees.allele.effect.AlleleEffectSpawnMob;
import magicbees.bees.allele.effect.AlleleEffectSpawnMobWeighted;
import magicbees.bees.allele.effect.AlleleEffectSpawnWisp;
import magicbees.bees.allele.effect.AlleleEffectTransmuting;
import magicbees.bees.allele.effect.TransmutationEffectController;
import magicbees.bees.allele.effect.TransmutationEffectLBotaniaLiving;
import magicbees.bees.allele.effect.TransmutationEffectRailcraft;
import magicbees.bees.allele.effect.TransmutationEffectVanilla;
import magicbees.bees.allele.flowerProvider.FlowerProviderArsMagicaFlower;
import magicbees.bees.allele.flowerProvider.FlowerProviderAuraNode;
import magicbees.bees.allele.flowerProvider.FlowerProviderBookshelf;
import magicbees.bees.allele.flowerProvider.FlowerProviderBotania;
import magicbees.bees.allele.flowerProvider.FlowerProviderThaumcraftFlower;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.BotaniaHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.main.utils.compat.ThermalExpansionHelper;
import net.minecraft.potion.Potion;
import thaumcraft.api.nodes.NodeType;

public class Allele
implements IAllele {
    public static AlleleFloat speedBlinding;
    public static IAlleleBeeEffect forestryBaseEffect;
    public static IAlleleFlowers flowerBookshelf;
    public static IAlleleFlowers flowerThaumcraft;
    public static IAlleleFlowers flowerArsMagica;
    public static IAlleleFlowers flowerAuraNode;
    public static IAlleleFlowers flowerBotania;
    public static IAlleleEffect effectCleansing;
    public static IAlleleEffect effectDigSpeed;
    public static IAlleleEffect effectMoveSpeed;
    public static IAlleleEffect effectSlowSpeed;
    public static IAlleleEffect effectWithering;
    public static IAlleleEffect effectVisRecharge;
    public static IAlleleEffect effectNodeEmpower;
    public static IAlleleEffect effectNodeRepair;
    public static IAlleleEffect effectNodeConversionTaint;
    public static IAlleleEffect effectNodeConversionPure;
    public static IAlleleEffect effectNodeConversionHungry;
    public static IAlleleEffect effectTransmuting;
    public static IAlleleEffect effectCrumbling;
    public static IAlleleEffect effectInvisibility;
    public static IAlleleEffect effectDreaming;
    public static IAlleleEffect spawnGhast;
    public static IAlleleEffect spawnSpider;
    public static IAlleleEffect spawnBlaze;
    public static IAlleleEffect spawnWolf;
    public static IAlleleEffect spawnBrainyZombie;
    public static IAlleleEffect spawnWisp;
    public static IAlleleEffect spawnBats;
    public static IAlleleEffect spawnBlizz;
    public static IAlleleEffect spawnManaDrainer;
    public static IAlleleEffect spawnWispOrHecate;
    private String uid;
    private boolean dominant;

    public static void setupAdditionalAlleles() {
        forestryBaseEffect = (IAlleleBeeEffect)Allele.getBaseAllele("effectNone");
        speedBlinding = new AlleleFloat("speedBlinding", 2.0f, false);
        flowerBookshelf = new AlleleFlower("Bookshelf", new FlowerProviderBookshelf(), true);
        if (ThaumcraftHelper.isActive()) {
            flowerThaumcraft = new AlleleFlower("ThaumcraftPlant", new FlowerProviderThaumcraftFlower(), false);
            flowerAuraNode = new AlleleFlower("AuraNode", new FlowerProviderAuraNode(), true);
            effectVisRecharge = new AlleleEffectRecharge("VisRecharge", false);
            effectNodeEmpower = new AlleleEffectEmpowering("NodeEmpower", false);
            effectNodeRepair = new AlleleEffectNodeRepair("NodeRepair", false);
            effectNodeConversionTaint = new AlleleEffectNodeConversion("NodeTainting", NodeType.TAINTED, false, 250);
            effectNodeConversionPure = new AlleleEffectNodeConversion("NodePurifying", NodeType.PURE, false, 250);
            effectNodeConversionHungry = new AlleleEffectNodeConversion("NodeRavening", NodeType.HUNGRY, false, 2);
            spawnBrainyZombie = new AlleleEffectSpawnMob("Brainy", false, ThaumcraftHelper.Entity.BRAINY_ZOMBIE.entityID).setAggrosPlayerOnSpawn().setThrottle(800).setSpawnsOnPlayerNear(null).setMaxMobsInSpawnZone(2);
            spawnBats = new AlleleEffectSpawnMob("Batty", false, ThaumcraftHelper.Entity.FIREBAT.entityID).setThrottle(300).setSpawnsOnPlayerNear("Bat");
            spawnWisp = new AlleleEffectSpawnWisp("Wispy", false, ThaumcraftHelper.Entity.WISP.entityID, "thaumcraft.wisplive").setThrottle(1800).setChanceToSpawn(79);
        } else {
            flowerThaumcraft = flowerAuraNode = (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
        }
        flowerBotania = BotaniaHelper.isActive() ? new AlleleFlower("flowerBotania", new FlowerProviderBotania(), true) : (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
        if (ArsMagicaHelper.isActive()) {
            flowerArsMagica = new AlleleFlower("flowerArsMagicaPlant", new FlowerProviderArsMagicaFlower(), false);
            spawnManaDrainer = new AlleleEffectSpawnMobWeighted("ManaDrain", true, 20, new String[]{"arsmagica2.MobManaCreeper", "arsmagica2.ManaVortex"}, new int[]{60, 2});
            spawnWispOrHecate = new AlleleEffectSpawnMobWeighted("AMWisp", true, 20, new String[]{"arsmagica2.MobWisp", "arsmagica2.MobHecate"}, new int[]{40, 3});
        } else {
            flowerArsMagica = (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
            spawnManaDrainer = spawnWispOrHecate = (IAlleleEffect)Allele.getBaseAllele("effectNone");
        }
        spawnBlizz = ThermalExpansionHelper.isActive() ? new AlleleEffectSpawnMob("TEBlizzy", true, ThermalExpansionHelper.Entity.BLIZZ.entityID).setThrottle(100).setChanceToSpawn(80) : (IAlleleEffect)Allele.getBaseAllele("effectNone");
        if (BotaniaHelper.isActive()) {
            effectDreaming = new AlleleEffectTransmuting("Dreaming", false, new TransmutationEffectController(new TransmutationEffectLBotaniaLiving()), 100);
        }
        effectCleansing = new AlleleEffectCure("Curative", false);
        effectDigSpeed = new AlleleEffectPotion("DigSpeed", Potion.field_76422_e, 15, false);
        effectMoveSpeed = new AlleleEffectPotion("MoveSpeed", Potion.field_76424_c, 10, false);
        effectSlowSpeed = new AlleleEffectPotion("SlowSpeed", Potion.field_76421_d, 3, false).setMalicious();
        effectWithering = new AlleleEffectPotion("Withering", Potion.field_82731_v, 10, false).setMalicious();
        TransmutationEffectController controller = new TransmutationEffectController(new TransmutationEffectRailcraft(), new TransmutationEffectVanilla());
        MagicBeesAPI.transmutationEffectController = controller;
        effectTransmuting = new AlleleEffectTransmuting("Transmuting", true, controller, 200);
        effectCrumbling = new AlleleEffectCrumbling("Crumbling", true);
        effectInvisibility = new AlleleEffectPotion("Invisibility", Potion.field_76441_p, 10, false);
        spawnGhast = new AlleleEffectSpawnMob("Ghastly", false, "Ghast", "mob.ghast.moan").setThrottle(2060).setChanceToSpawn(10).setMaxMobsInSpawnZone(1);
        spawnSpider = new AlleleEffectSpawnMob("Spidery", false, "Spider", "mob.spider.step").setThrottle(400).setChanceToSpawn(70).setMaxMobsInSpawnZone(4);
        spawnBlaze = new AlleleEffectSpawnMob("Ablaze", false, "Blaze", "mob.blaze.breathe").setThrottle(800).setChanceToSpawn(60).setMaxMobsInSpawnZone(2);
        spawnWolf = new AlleleEffectSpawnMob("Canine", false, "Wolf", "mob.wolf.panting").setThrottle(650).setChanceToSpawn(40).setMaxMobsInSpawnZone(2);
    }

    public static void registerDeprecatedAlleleReplacements() {
        IAlleleRegistry registry = AlleleManager.alleleRegistry;
        registry.registerDeprecatedAlleleReplacement("thaumicbees.fertilityHighDominant", Allele.getBaseAllele("fertilityHigh"));
        registry.registerDeprecatedAlleleReplacement("thaumicbees.flowerflowerBookshelf", (IAllele)flowerBookshelf);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speedBlinding", (IAllele)speedBlinding);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectNodeAttract", Allele.getBaseAllele("effectBeatific"));
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectNodePurify", Allele.getBaseAllele("effectBeatific"));
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectNodeFlux", Allele.getBaseAllele("effectBeatific"));
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectNodeCharge", Allele.getBaseAllele("effectBeatific"));
        registry.registerDeprecatedAlleleReplacement("magicbees.effectNodeAttract", Allele.getBaseAllele("effectBeatific"));
        registry.registerDeprecatedAlleleReplacement("magicbees.effectNodePurify", Allele.getBaseAllele("effectBeatific"));
        registry.registerDeprecatedAlleleReplacement("magicbees.effectNodeFlux", Allele.getBaseAllele("effectBeatific"));
        registry.registerDeprecatedAlleleReplacement("magicbees.effectNodeCharge", Allele.getBaseAllele("effectBeatific"));
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectCurative", (IAllele)effectCleansing);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effecteffectDigSpeed", (IAllele)effectDigSpeed);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effecteffectMoveSpeed", (IAllele)effectMoveSpeed);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effecteffectSlowSpeed", (IAllele)effectSlowSpeed);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.Ghast", (IAllele)spawnGhast);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.Spider", (IAllele)spawnSpider);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEsoteric", (IAllele)BeeSpecies.ESOTERIC);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesMysterious", (IAllele)BeeSpecies.MYSTERIOUS);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesArcane", (IAllele)BeeSpecies.ARCANE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesCharmed", (IAllele)BeeSpecies.CHARMED);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEnchanted", (IAllele)BeeSpecies.ENCHANTED);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSupernatural", (IAllele)BeeSpecies.SUPERNATURAL);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesPupil", (IAllele)BeeSpecies.PUPIL);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesScholarly", (IAllele)BeeSpecies.SCHOLARLY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSavant", (IAllele)BeeSpecies.SAVANT);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesAware", (IAllele)BeeSpecies.AWARE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSpirit", (IAllele)BeeSpecies.SPIRIT);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSoul", (IAllele)BeeSpecies.SOUL);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSkulking", (IAllele)BeeSpecies.SKULKING);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesGhastly", (IAllele)BeeSpecies.GHASTLY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSpidery", (IAllele)BeeSpecies.SPIDERY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesTimely", (IAllele)BeeSpecies.TIMELY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesLordly", (IAllele)BeeSpecies.LORDLY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesDoctoral", (IAllele)BeeSpecies.DOCTORAL);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesIron", (IAllele)BeeSpecies.IRON);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesGold", (IAllele)BeeSpecies.GOLD);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesCopper", (IAllele)BeeSpecies.COPPER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesTin", (IAllele)BeeSpecies.TIN);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSilver", (IAllele)BeeSpecies.SILVER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesLead", (IAllele)BeeSpecies.LEAD);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesDiamond", (IAllele)BeeSpecies.DIAMOND);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEmerald", (IAllele)BeeSpecies.EMERALD);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesApatite", (IAllele)BeeSpecies.APATITE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesStark", (IAllele)BeeSpecies.TC_CHAOS);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesAura", (IAllele)BeeSpecies.TC_AIR);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesIgnis", (IAllele)BeeSpecies.TC_FIRE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesAqua", (IAllele)BeeSpecies.TC_WATER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSolum", (IAllele)BeeSpecies.TC_EARTH);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesPraecantatio", (IAllele)BeeSpecies.TC_ORDER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesVis", (IAllele)BeeSpecies.TC_VIS);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesPure", (IAllele)BeeSpecies.TC_PURE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesFlux", (IAllele)BeeSpecies.TC_TAINT);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesNode", (IAllele)BeeSpecies.TC_EMPOWERING);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesRejuvenating", (IAllele)BeeSpecies.TC_REJUVENATING);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBrainy", (IAllele)BeeSpecies.TC_BRAINY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesGossamer", (IAllele)BeeSpecies.TC_WISPY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesWispy", (IAllele)BeeSpecies.TC_WISPY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBatty", (IAllele)BeeSpecies.TC_BATTY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesChicken", (IAllele)BeeSpecies.TC_CHICKEN);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBeef", (IAllele)BeeSpecies.TC_BEEF);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesPork", (IAllele)BeeSpecies.TC_PORK);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesMinium", (IAllele)BeeSpecies.EE_MINIUM);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEssence", (IAllele)BeeSpecies.AM_ESSENCE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesQuintessence", (IAllele)BeeSpecies.AM_QUINTESSENCE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesErde", (IAllele)BeeSpecies.AM_EARTH);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesLuft", (IAllele)BeeSpecies.AM_AIR);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesFeuer", (IAllele)BeeSpecies.AM_FIRE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesWasser", (IAllele)BeeSpecies.AM_WATER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBlitz", (IAllele)BeeSpecies.AM_LIGHTNING);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesStaude", (IAllele)BeeSpecies.AM_PLANT);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEis", (IAllele)BeeSpecies.AM_ICE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesMagma", (IAllele)BeeSpecies.AM_FIRE);
        registry.registerDeprecatedAlleleReplacement("magicbees.speciesMagma", (IAllele)BeeSpecies.AM_FIRE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesArkanen", (IAllele)BeeSpecies.AM_ARCANE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesVortex", (IAllele)BeeSpecies.AM_VORTEX);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesWight", (IAllele)BeeSpecies.AM_WIGHT);
        registry.registerDeprecatedAlleleReplacement("magicbees.speciesTCAttractive", (IAllele)BeeSpecies.TC_EMPOWERING);
    }

    public static IAlleleBeeSpecies getBaseSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    public static IAlleleBeeSpecies getExtraSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("extrabees.species." + name.toLowerCase());
    }

    public static IAllele getBaseAllele(String name) {
        return AlleleManager.alleleRegistry.getAllele("forestry." + name);
    }

    public static IAllele getAllele(String name) {
        return AlleleManager.alleleRegistry.getAllele(name);
    }

    public Allele(String id, boolean isDominant) {
        this.uid = "magicbees." + id;
        this.dominant = isDominant;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
    }

    public String getUID() {
        return this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public String getName() {
        return LocalizationManager.getLocalizedString(this.getUID());
    }

    public String getUnlocalizedName() {
        return this.uid;
    }
}

