/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.effect;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import magicbees.bees.AlleleEffect;
import magicbees.bees.EffectData;
import magicbees.main.utils.BlockUtil;
import magicbees.main.utils.compat.thaumcraft.NodeHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class AlleleEffectNodeRepair
extends AlleleEffect {
    public AlleleEffectNodeRepair(String id, boolean isDominant) {
        super(id, isDominant, 2);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int range;
        World world = housing.getWorld();
        int xCoord = housing.getXCoord();
        int yCoord = housing.getYCoord();
        int zCoord = housing.getZCoord();
        List<Chunk> chunks = BlockUtil.getChunksInSearchRange(world, xCoord, zCoord, range = (int)Math.ceil((float)genome.getTerritory()[0] * housing.getTerritoryModifier(genome, 1.0f)));
        if (NodeHelper.repairNodeInRange(chunks, world, xCoord, yCoord, zCoord, range)) {
            storedData.setInteger(0, storedData.getInteger(0) - this.throttle);
        }
        return storedData;
    }
}

