/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.effect;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import magicbees.bees.AlleleEffect;
import magicbees.bees.EffectData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public class AlleleEffectSpawnMobWeighted
extends AlleleEffect {
    private String[] entityNames;
    private int[] spawnChance;

    public AlleleEffectSpawnMobWeighted(String id, boolean isDominant, int throttle, String[] mobs, int[] chance) {
        super(id, isDominant, throttle);
        if (mobs.length != chance.length) {
            throw new IllegalArgumentException("Array lengths must be equal!");
        }
        this.entityNames = mobs;
        this.spawnChance = chance;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (this.spawnMob(genome, housing)) {
            storedData.setInteger(0, 0);
        }
        return storedData;
    }

    protected boolean spawnMob(IBeeGenome genome, IBeeHousing housing) {
        boolean flag = false;
        World w = housing.getWorld();
        int roll = 0;
        for (int i = 0; i < this.spawnChance.length && !flag; ++i) {
            roll = 100 - w.field_73012_v.nextInt(100) + 1;
            if (roll >= this.spawnChance[i]) continue;
            flag = true;
            Entity mob = EntityList.func_75620_a((String)this.entityNames[i], (World)w);
            double[] coords = this.randomMobSpawnCoords(w, genome, housing);
            mob.func_70080_a(coords[0], coords[1], coords[2], w.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (mob instanceof EntityLiving) {
                if (!((EntityLiving)mob).func_70601_bi()) continue;
                w.func_72838_d(mob);
                continue;
            }
            w.func_72838_d(mob);
        }
        return flag;
    }

    protected double[] randomMobSpawnCoords(World world, IBeeGenome bee, IBeeHousing housing) {
        double[] pos = new double[]{(double)housing.getXCoord() + world.field_73012_v.nextDouble() * (double)((float)bee.getTerritory()[0] * housing.getTerritoryModifier(bee, 1.0f)) - (double)(bee.getTerritory()[0] / 2), (double)housing.getYCoord() + world.field_73012_v.nextDouble() * (double)((float)bee.getTerritory()[1] * housing.getTerritoryModifier(bee, 1.0f)) - (double)(bee.getTerritory()[1] / 2), (double)housing.getZCoord() + world.field_73012_v.nextDouble() * (double)((float)bee.getTerritory()[2] * housing.getTerritoryModifier(bee, 1.0f)) - (double)(bee.getTerritory()[2] / 2)};
        return pos;
    }
}

