/*
 * Decompiled with CFR 0.152.
 */
package magicbees.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import magicbees.item.types.CapsuleType;
import magicbees.item.types.FluidType;
import magicbees.main.utils.TabMagicBees;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemCapsule
extends Item {
    private CapsuleType capsuleType;

    public ItemCapsule(CapsuleType type, int maxStackSize) {
        this.capsuleType = type;
        this.func_77637_a(TabMagicBees.tabMagicBees);
        this.func_77627_a(true);
        this.func_77625_d(maxStackSize);
        this.func_77655_b("capsule." + type.toString().toLowerCase());
        GameRegistry.registerItem((Item)this, (String)("capsule." + type.toString().toLowerCase()));
    }

    public CapsuleType getType() {
        return this.capsuleType;
    }

    public String func_77653_i(ItemStack itemStack) {
        return String.format(this.capsuleType.getLocalizedName(), FluidType.values()[itemStack.func_77960_j()].getDisplayName());
    }

    public ItemStack getCapsuleForLiquid(FluidType l) {
        return new ItemStack((Item)this, 1, l.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        for (FluidType l : FluidType.values()) {
            if (!l.available) continue;
            itemList.add(new ItemStack((Item)this, 1, l.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("magicbees:capsule" + this.capsuleType.getName().substring(0, 1).toUpperCase() + this.capsuleType.getName().substring(1));
        for (FluidType t : FluidType.values()) {
            if (t == FluidType.EMPTY) continue;
            t.liquidIcon = iconRegister.func_94245_a("magicbees:liquids/" + t.liquidID);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int metadata, int pass) {
        IIcon i = this.field_77791_bV;
        if (metadata != 0 && pass == 0) {
            i = FluidType.values()[metadata % FluidType.values().length].liquidIcon;
        }
        return i;
    }

    public int getRenderPasses(int metadata) {
        return metadata == 0 ? 1 : 2;
    }
}

