/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import magicbees.api.MagicBeesAPI;
import magicbees.item.types.PollenType;
import magicbees.item.types.PropolisType;
import magicbees.item.types.ResourceType;
import magicbees.item.types.WaxType;
import magicbees.main.Config;
import magicbees.main.utils.BlockInterface;
import magicbees.main.utils.ItemInterface;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.compat.ForestryHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class ThaumcraftHelper {
    public static Block plant;
    public static Block candle;
    public static Block crystal;
    public static Block marker;
    public static Block jar;
    public static Block log;
    public static Block leaf;
    public static Block warded;
    public static Block wooden;
    public static Block metal;
    public static Block airy;
    public static Block fluxGas;
    public static Block fluxGoo;
    public static Item filledJar;
    public static Item miscResource;
    public static Item shard;
    public static Item golem;
    public static Item nuggetMetal;
    public static Item nuggetChicken;
    public static Item nuggetBeef;
    public static Item nuggetPork;
    public static Class<? extends TileEntity> nodeClass;
    public static final String Name = "Thaumcraft";
    private static boolean isThaumcraftPresent;
    private static Object aspectTime;
    private static Object frameMagic;
    private static Object thaumScoop;
    private static Object thaumGrafter;
    private static Object singularityA;
    private static Object singularityB;
    private static Object essenceLife;
    private static Object essenceDeath;
    private static Object essenceArmor;
    private static Object essenceUnstableA;
    private static Object essenceUnstableB;
    private static Object essenceTime;
    private static Object essenceOblivion;
    private static Object visAuraProvider;

    public static boolean isActive() {
        return isThaumcraftPresent;
    }

    public static void preInit() {
        if (Loader.isModLoaded((String)Name) && Config.thaumcraftActive) {
            isThaumcraftPresent = true;
            MagicBeesAPI.thaumcraftAspectTempus = aspectTime = new Aspect("tempus", 11963647, new Aspect[]{Aspect.VOID, Aspect.ORDER}, new ResourceLocation("magicbees", "textures/aspects/tempus.png"), 1);
        } else {
            ResourceType.LORE_FRAGMENT.setHidden();
            ResourceType.TC_DUST_AIR.setHidden();
            ResourceType.TC_DUST_CHAOS.setHidden();
            ResourceType.TC_DUST_EARTH.setHidden();
            ResourceType.TC_DUST_FIRE.setHidden();
            ResourceType.TC_DUST_ORDER.setHidden();
            ResourceType.TC_DUST_WATER.setHidden();
        }
    }

    public static void init() {
        if (ThaumcraftHelper.isActive()) {
            ThaumcraftHelper.getBlocks();
            ThaumcraftHelper.getItems();
        }
    }

    public static void postInit() {
        if (ThaumcraftHelper.isActive()) {
            ThaumcraftHelper.setupItemAspects();
            ThaumcraftHelper.setupCrafting();
            ThaumcraftHelper.setupResearch();
        }
    }

    private static void getBlocks() {
        plant = BlockInterface.getBlock(Name, "blockCustomPlant");
        candle = BlockInterface.getBlock(Name, "blockCandle");
        crystal = BlockInterface.getBlock(Name, "blockCrystal");
        marker = BlockInterface.getBlock(Name, "blockMarker");
        jar = BlockInterface.getBlock(Name, "blockJar");
        log = BlockInterface.getBlock(Name, "blockMagicalLog");
        leaf = BlockInterface.getBlock(Name, "blockMagicalLeaves");
        warded = BlockInterface.getBlock(Name, "blockWarded");
        wooden = BlockInterface.getBlock(Name, "blockWoodenDevice");
        metal = BlockInterface.getBlock(Name, "blockMetalDevice");
        airy = BlockInterface.getBlock(Name, "blockAiry");
    }

    private static void getItems() {
        filledJar = ItemInterface.getItem(Name, "BlockJarFilledItem");
        miscResource = ItemInterface.getItem(Name, "ItemResource");
        shard = ItemInterface.getItem(Name, "ItemShard");
        golem = ItemInterface.getItem(Name, "ItemGolemPlacer");
        nuggetMetal = ItemInterface.getItem(Name, "ItemNugget");
        shard = ItemInterface.getItem(Name, "ItemShard");
        nuggetChicken = ItemInterface.getItem(Name, "ItemNuggetChicken");
        nuggetBeef = ItemInterface.getItem(Name, "ItemNuggetBeef");
        nuggetPork = ItemInterface.getItem(Name, "ItemNuggetPork");
    }

    private static void setupCrafting() {
        ItemStack input = Config.miscResources.getStackForType(ResourceType.TC_DUST_AIR);
        ItemStack output = new ItemStack(shard, 1, ShardType.AIR.ordinal());
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input, input, input, input});
        input = Config.miscResources.getStackForType(ResourceType.TC_DUST_WATER);
        output = new ItemStack(shard, 1, ShardType.WATER.ordinal());
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input, input, input, input});
        input = Config.miscResources.getStackForType(ResourceType.TC_DUST_FIRE);
        output = new ItemStack(shard, 1, ShardType.FIRE.ordinal());
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input, input, input, input});
        input = Config.miscResources.getStackForType(ResourceType.TC_DUST_EARTH);
        output = new ItemStack(shard, 1, ShardType.EARTH.ordinal());
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input, input, input, input});
        input = Config.miscResources.getStackForType(ResourceType.TC_DUST_ORDER);
        output = new ItemStack(shard, 1, ShardType.ORDER.ordinal());
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input, input, input, input});
        input = Config.miscResources.getStackForType(ResourceType.TC_DUST_CHAOS);
        output = new ItemStack(shard, 1, ShardType.CHAOS.ordinal());
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input, input, input, input});
        thaumScoop = ThaumcraftApi.addArcaneCraftingRecipe((String)"MB_Scoop", (ItemStack)new ItemStack(Config.thaumiumScoop), (AspectList)new AspectList().add(Aspect.ORDER, 2), (Object[])new Object[]{"sWs", "sTs", " T ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('T'), new ItemStack(miscResource, 1, MiscResource.THAUMIUM.ordinal())});
        thaumGrafter = ThaumcraftApi.addArcaneCraftingRecipe((String)"MB_Grafter", (ItemStack)new ItemStack(Config.thaumiumGrafter), (AspectList)new AspectList().add(Aspect.ORDER, 5), (Object[])new Object[]{"  T", " s ", "s  ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('T'), new ItemStack(miscResource, 1, MiscResource.THAUMIUM.ordinal())});
        frameMagic = ThaumcraftApi.addArcaneCraftingRecipe((String)"MB_FrameMagic", (ItemStack)new ItemStack((Item)Config.hiveFrameMagic), (AspectList)new AspectList().add(Aspect.ORDER, 5).add(Aspect.AIR, 2).add(Aspect.EARTH, 2), (Object[])new Object[]{"sss", "sCs", "sss", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('C'), new ItemStack(miscResource, 1, MiscResource.ENCHANTED_FABRIC.ordinal())});
        visAuraProvider = ThaumcraftApi.addArcaneCraftingRecipe((String)"MB_VisAuraProvider", (ItemStack)new ItemStack((Block)Config.visAuraProvider), (AspectList)new AspectList().add(Aspect.ORDER, 60).add(Aspect.AIR, 60).add(Aspect.ENTROPY, 60).add(Aspect.WATER, 60), (Object[])new Object[]{"ngn", "gvg", "npn", Character.valueOf('n'), Items.field_151074_bl, Character.valueOf('g'), new ItemStack(wooden, 1, WoodenDeviceType.PLANKS_GREATWOOD.ordinal()), Character.valueOf('v'), new ItemStack(metal, 1, MetalDeviceType.VIS_RELAY.ordinal()), Character.valueOf('p'), Config.pollen.getStackForType(PollenType.UNUSUAL)});
        essenceLife = ThaumcraftApi.addCrucibleRecipe((String)"MB_EssenceLife", (ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE), (Object)new ItemStack((Block)Blocks.field_150328_O), (AspectList)new AspectList().add(Aspect.EXCHANGE, 4).add(Aspect.PLANT, 4));
        essenceDeath = ThaumcraftApi.addCrucibleRecipe((String)"MB_EssenceDeath", (ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), (Object)new ItemStack(Items.field_151078_bh), (AspectList)new AspectList().add(Aspect.DEATH, 4).add(Aspect.ENTROPY, 4));
        essenceArmor = ThaumcraftApi.addCrucibleRecipe((String)"MB_EssenceArmor", (ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY), (Object)new ItemStack(Items.field_151116_aA), (AspectList)new AspectList().add(Aspect.ARMOR, 4).add(Aspect.MAGIC, 2));
        output = Config.miscResources.getStackForType(ResourceType.ESSENCE_FICKLE_PERMANENCE);
        essenceUnstableA = ThaumcraftApi.addCrucibleRecipe((String)"MB_EssenceUnstable", (ItemStack)output, (Object)Config.propolis.getStackForType(PropolisType.UNSTABLE), (AspectList)new AspectList().add(Aspect.ENTROPY, 2).add(Aspect.EXCHANGE, 1));
        essenceUnstableB = ThaumcraftApi.addCrucibleRecipe((String)"MB_EssenceUnstable", (ItemStack)output, (Object)new ItemStack(Blocks.field_150424_aL), (AspectList)new AspectList().add(Aspect.ENTROPY, 8).add(Aspect.EXCHANGE, 5));
        essenceTime = ThaumcraftApi.addCrucibleRecipe((String)"MB_EssenceTime", (ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), (Object)new ItemStack(Items.field_151113_aN), (AspectList)new AspectList().add(Aspect.ORDER, 10).add(Aspect.VOID, 10).add(Aspect.TRAP, 4));
        input = new ItemStack(Items.field_151079_bi);
        singularityA = ThaumcraftApi.addInfusionCraftingRecipe((String)"MB_DimensionalSingularity", (Object)Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY, 3), (int)5, (AspectList)new AspectList().add(Aspect.ELDRITCH, 10).add(Aspect.EXCHANGE, 20), (ItemStack)new ItemStack(Blocks.field_150340_R), (ItemStack[])new ItemStack[]{input, input});
        ItemStack in2 = new ItemStack(Items.field_151045_i);
        singularityB = ThaumcraftApi.addInfusionCraftingRecipe((String)"MB_DimensionalSingularity", (Object)Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY, 3), (int)6, (AspectList)new AspectList().add(Aspect.ELDRITCH, 10).add(Aspect.EXCHANGE, 20).add(Aspect.VOID, 15), (ItemStack)Config.propolis.getStackForType(PropolisType.UNSTABLE), (ItemStack[])new ItemStack[]{input, input, in2});
        essenceOblivion = ThaumcraftApi.addShapelessArcaneCraftingRecipe((String)"MB_EssenceOblivion", (ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_SCORNFUL_OBLIVION), (AspectList)new AspectList().add(Aspect.ENTROPY, 25).add(Aspect.AIR, 40).add(Aspect.ORDER, 15), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY), Blocks.field_150380_bt});
    }

    private static void setupResearch() {
        String category = "MAGICBEES";
        ResearchCategories.registerCategory((String)category, (ResourceLocation)new ResourceLocation("magicbees", "textures/items/beeInfusion.png"), (ResourceLocation)new ResourceLocation("thaumcraft", "textures/gui/gui_researchback.png"));
        new ResearchItem("MB_Root", category, new AspectList(), 0, 0, 0, Config.miscResources.getStackForType(ResourceType.RESEARCH_BEEINFUSION)).setRound().setStub().setAutoUnlock().setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_Root.1"), ThaumcraftHelper.getResearchPage("MB_Root.2")}).registerResearchItem();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(4);
        list.add(Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT));
        list.add(Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT));
        list.add(Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT));
        list.add(Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT));
        ShapelessRecipes recipe = new ShapelessRecipes(new ItemStack(miscResource, 1, MiscResource.KNOWLEDGE_FRAGMENT.ordinal()), list);
        new ResearchItem("MB_LoreFragment", category, new AspectList(), 0, -3, 1, Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_LoreFragment.1"), new ResearchPage((IRecipe)recipe)}).setParents(new String[]{"MB_Root"}).setStub().setAutoUnlock().setRound().registerResearchItem();
        new ResearchItem("MB_Scoop", category, new AspectList().add(Aspect.TOOL, 1).add(Aspect.MAGIC, 1).add(Aspect.AIR, 1), -2, -3, 1, new ItemStack(Config.thaumiumScoop)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_Scoop.1"), new ResearchPage((IArcaneRecipe)thaumScoop)}).setParentsHidden(new String[]{"THAUMIUM"}).registerResearchItem();
        new ResearchItem("MB_Grafter", category, new AspectList().add(Aspect.TOOL, 1).add(Aspect.TREE, 1).add(Aspect.GREED, 1), -2, -1, 2, new ItemStack(Config.thaumiumGrafter)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_Grafter.1"), new ResearchPage((IArcaneRecipe)thaumGrafter)}).setParents(new String[]{"MB_Scoop"}).registerResearchItem();
        new ResearchItem("MB_FrameMagic", category, new AspectList().add(Aspect.TOOL, 1).add(Aspect.ARMOR, 1), -2, 1, 1, new ItemStack((Item)Config.hiveFrameMagic)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_FrameMagic"), new ResearchPage((IArcaneRecipe)frameMagic)}).registerResearchItem();
        ItemStack input = new ItemStack((Item)Config.hiveFrameMagic);
        list = new ArrayList(2);
        list.add(Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE));
        list.add(input);
        recipe = new ShapelessRecipes(new ItemStack((Item)Config.hiveFrameGentle), list);
        new ResearchItem("MB_EssenceLife", category, new AspectList().add(Aspect.LIFE, 1).add(Aspect.MAGIC, 1), 2, -1, 1, Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_EssenceLife.1"), new ResearchPage((CrucibleRecipe)essenceLife), new ResearchPage((IRecipe)recipe)}).setParentsHidden(new String[]{"CRUCIBLE"}).registerResearchItem();
        list = new ArrayList(2);
        list.add(Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY));
        list.add(input);
        recipe = new ShapelessRecipes(new ItemStack((Item)Config.hiveFrameResilient), list);
        new ResearchItem("MB_EssenceArmor", category, new AspectList().add(Aspect.ARMOR, 1).add(Aspect.MAGIC, 1), 5, 0, 2, Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_EssenceArmor.1"), new ResearchPage((CrucibleRecipe)essenceArmor), new ResearchPage((IRecipe)recipe)}).setParents(new String[]{"MB_EssenceLife"}).registerResearchItem();
        list = new ArrayList(2);
        list.add(Config.miscResources.getStackForType(ResourceType.ESSENCE_FICKLE_PERMANENCE));
        list.add(input);
        recipe = new ShapelessRecipes(new ItemStack((Item)Config.hiveFrameMetabolic), list);
        new ResearchItem("MB_EssenceUnstable", category, new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.ORDER, 1), 3, 1, 2, Config.miscResources.getStackForType(ResourceType.ESSENCE_FICKLE_PERMANENCE)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_EssenceUnstable.1"), new ResearchPage((CrucibleRecipe)essenceUnstableA), new ResearchPage((CrucibleRecipe)essenceUnstableB), new ResearchPage((IRecipe)recipe)}).setParents(new String[]{"MB_EssenceLife"}).setConcealed().registerResearchItem();
        list = new ArrayList(2);
        list.add(Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE));
        list.add(input);
        recipe = new ShapelessRecipes(new ItemStack((Item)Config.hiveFrameNecrotic), list);
        new ResearchItem("MB_EssenceDeath", category, new AspectList().add(Aspect.DEATH, 1).add(Aspect.MAGIC, 1), 2, 3, 1, Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_EssenceDeath.1"), new ResearchPage((CrucibleRecipe)essenceDeath), new ResearchPage((IRecipe)recipe)}).setParents(new String[]{"MB_EssenceUnstable"}).setConcealed().registerResearchItem();
        list = new ArrayList(2);
        list.add(Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME));
        list.add(input);
        recipe = new ShapelessRecipes(new ItemStack((Item)Config.hiveFrameTemporal), list);
        new ResearchItem("MB_EssenceTime", category, new AspectList().add((Aspect)aspectTime, 1).add(Aspect.MAGIC, 1), 0, 2, 2, Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_EssenceTime.1"), new ResearchPage((CrucibleRecipe)essenceTime), new ResearchPage((IRecipe)recipe)}).setParents(new String[]{"MB_EssenceUnstable"}).setConcealed().registerResearchItem();
        new ResearchItem("MB_DimensionalSingularity", category, new AspectList().add(Aspect.ELDRITCH, 1).add((Aspect)aspectTime, 1).add(Aspect.VOID, 1), -1, 4, 3, Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_DimensionalSingularity.1"), new ResearchPage((InfusionRecipe)singularityA), new ResearchPage((InfusionRecipe)singularityB)}).setParents(new String[]{"MB_FrameMagic", "MB_EssenceTime", "MB_EssenceDeath"}).setConcealed().setSpecial().registerResearchItem();
        list = new ArrayList(2);
        list.add(Config.miscResources.getStackForType(ResourceType.ESSENCE_SCORNFUL_OBLIVION));
        list.add(ItemInterface.getItemStack("frameProven"));
        recipe = new ShapelessRecipes(new ItemStack((Item)Config.hiveFrameOblivion), list);
        new ResearchItem("MB_EssenceOblivion", category, new AspectList().add(Aspect.VOID, 1).add(Aspect.HUNGER, 1).add((Aspect)aspectTime, 1), -3, 3, 3, Config.miscResources.getStackForType(ResourceType.ESSENCE_SCORNFUL_OBLIVION)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_EssenceOblivion.1"), new ResearchPage((IArcaneRecipe)essenceOblivion), new ResearchPage((IRecipe)recipe)}).setParents(new String[]{"MB_DimensionalSingularity"}).setConcealed().registerResearchItem();
        new ResearchItem("MB_VisAuraProvider", category, new AspectList().add(Aspect.MAGIC, 1).add(Aspect.ENERGY, 1).add(Aspect.AURA, 1), -5, 5, 3, new ItemStack((Block)Config.visAuraProvider)).setPages(new ResearchPage[]{ThaumcraftHelper.getResearchPage("MB_VisAuraProvider.1"), new ResearchPage((IArcaneRecipe)visAuraProvider)}).setParentsHidden(new String[]{"VISPOWER"}).registerResearchItem();
    }

    private static ResearchPage getResearchPage(String ident) {
        return new ResearchPage(LocalizationManager.getLocalizedString("tc.research_page." + ident));
    }

    private static void setupItemAspects() {
        ItemStack item;
        int i;
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Items.field_151113_aN), (AspectList)new AspectList(new ItemStack(Items.field_151113_aN)).add((Aspect)aspectTime, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Items.field_151107_aW), (AspectList)new AspectList(new ItemStack(Items.field_151107_aW)).add((Aspect)aspectTime, 2));
        AspectList list = new AspectList(new ItemStack(Blocks.field_150364_r));
        for (i = 1; i <= 8; ++i) {
            item = ItemInterface.getItemStack("log" + i);
            if (item == null) continue;
            ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        }
        list = new AspectList(new ItemStack(Blocks.field_150344_f));
        for (i = 1; i <= 2; ++i) {
            item = ItemInterface.getItemStack("planks" + i);
            if (item == null) continue;
            ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        }
        list = new AspectList().add(Aspect.ORDER, 5).add(Aspect.ARMOR, 2).add(Aspect.BEAST, 1);
        item = new ItemStack(ForestryHelper.hiveBlock);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Block)Config.hive), (AspectList)list);
        list = new AspectList().add(Aspect.LIGHT, 1);
        item = new ItemStack(BlockInterface.getBlock("Forestry", "candle"));
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)list);
        list = new AspectList().add(Aspect.DARKNESS, 1);
        item = new ItemStack(BlockInterface.getBlock("Forestry", "stump"));
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)list);
        list = new AspectList(new ItemStack(Blocks.field_150359_w)).add(Aspect.SENSES, 1);
        item = new ItemStack(BlockInterface.getBlock("Forestry", "glass"));
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList().add(Aspect.EARTH, 2).add(Aspect.WATER, 2);
        item = new ItemStack(BlockInterface.getBlock("Forestry", "soil"));
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{1}, (AspectList)list);
        list = new AspectList(new ItemStack((Block)Blocks.field_150362_t));
        item = ItemInterface.getItemStack("Forestry", "candle");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)list);
        list = new AspectList(new ItemStack(Blocks.field_150345_g));
        item = ItemInterface.getItemStack("Forestry", "candle");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList().add(Aspect.PLANT, 1);
        item = ItemInterface.getItemStack("Forestry", "candle");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList().add(Aspect.CRYSTAL, 1).add(Aspect.EARTH, 2);
        item = ItemInterface.getItemStack("Forestry", "candle");
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item.func_77973_b(), 1, ForestryHelper.BlockResource.APATITE.ordinal()), (AspectList)list.copy());
        item = ItemInterface.getItemStack("Forestry", "apatite");
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item.func_77973_b(), 1, item.func_77960_j()), (AspectList)list.copy().add(Aspect.CRYSTAL, 2));
        list = new AspectList().add(Aspect.MOTION, 2).add(Aspect.FLIGHT, 1);
        item = ItemInterface.getItemStack("beeDroneGE");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = list.copy().add(Aspect.GREED, 2).add(Aspect.EXCHANGE, 1);
        item = ItemInterface.getItemStack("beePrincessGE");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        item = ItemInterface.getItemStack("beeQueenGE");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList().add(Aspect.LIFE, 2).add(Aspect.EXCHANGE, 5);
        item = ItemInterface.getItemStack("beeLarvaeGE");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        item = ItemInterface.getItemStack("scoop");
        list = new AspectList(new ItemStack(item.func_77973_b(), 1, 0)).add(Aspect.TOOL, 2);
        ThaumcraftApi.registerComplexObjectTag((ItemStack)item, (AspectList)list);
        item = ItemInterface.getItemStack("grafter");
        list = new AspectList(new ItemStack(item.func_77973_b(), 1, item.func_77960_j())).add(Aspect.TOOL, 2);
        ThaumcraftApi.registerComplexObjectTag((ItemStack)item, (AspectList)list);
        item = ItemInterface.getItemStack("grafterProven");
        list = list.copy().add(Aspect.TOOL, 2).add(Aspect.EXCHANGE, 3);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item.func_77973_b(), 1, item.func_77960_j()), (AspectList)list);
        list = new AspectList().add(Aspect.TRAP, 2);
        ThaumcraftApi.registerObjectTag((String)"beeComb", (AspectList)list);
        list = new AspectList().add(Aspect.SLIME, 1);
        item = ItemInterface.getItemStack("propolis");
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item.func_77973_b(), 1, ForestryHelper.Propolis.NORMAL.ordinal()), (AspectList)list);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item.func_77973_b(), 1, ForestryHelper.Propolis.SILKY.ordinal()), (AspectList)list.copy().add(Aspect.SLIME, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item.func_77973_b(), 1, ForestryHelper.Propolis.PULSATING.ordinal()), (AspectList)list.copy().add(Aspect.ELDRITCH, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.propolis, 1, PropolisType.UNSTABLE.ordinal()), (AspectList)list.copy().add(Aspect.ENTROPY, 1).add(Aspect.EXCHANGE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.propolis, 1, PropolisType.AIR.ordinal()), (AspectList)list.copy().add(Aspect.AIR, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.propolis, 1, PropolisType.WATER.ordinal()), (AspectList)list.copy().add(Aspect.WATER, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.propolis, 1, PropolisType.FIRE.ordinal()), (AspectList)list.copy().add(Aspect.FIRE, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.propolis, 1, PropolisType.EARTH.ordinal()), (AspectList)list.copy().add(Aspect.EARTH, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.propolis, 1, PropolisType.ORDER.ordinal()), (AspectList)list.copy().add(Aspect.ORDER, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.propolis, 1, PropolisType.CHAOS.ordinal()), (AspectList)list.copy().add(Aspect.ENTROPY, 2));
        list = new AspectList().add(Aspect.PLANT, 2);
        item = ItemInterface.getItemStack("pollen");
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item.func_77973_b(), 1, ForestryHelper.Pollen.NORMAL.ordinal()), (AspectList)list);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item.func_77973_b(), 1, ForestryHelper.Pollen.CRYSTALLINE.ordinal()), (AspectList)list.copy());
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.pollen, 1, PollenType.UNUSUAL.ordinal()), (AspectList)list.copy().add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.pollen, 1, PollenType.PHASED.ordinal()), (AspectList)list.copy().add((Aspect)aspectTime, 2));
        list = new AspectList().add(Aspect.ORDER, 1);
        item = ItemInterface.getItemStack("beeswax");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)list.copy().add(Aspect.ORDER, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.wax, 1, WaxType.MAGIC.ordinal()), (AspectList)list.copy().add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.wax, 1, WaxType.SOUL.ordinal()), (AspectList)list.copy().add(Aspect.SOUL, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)Config.wax, 1, WaxType.AMNESIC.ordinal()), (AspectList)list.copy().add(Aspect.MIND, 2));
        list = new AspectList().add(Aspect.EXCHANGE, 2).add(Aspect.LIFE, 2);
        item = ItemInterface.getItemStack("honeyDrop");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)list);
        list = new AspectList().add(Aspect.LIFE, 2).add(Aspect.ENERGY, 2);
        item = ItemInterface.getItemStack("honeydew");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)list);
        list = new AspectList().add(Aspect.GREED, 1).add(Aspect.LIFE, 4);
        item = ItemInterface.getItemStack("royalJelly");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)list);
        list = new AspectList().add(Aspect.FIRE, 1).add(Aspect.TRAP, 2);
        item = ItemInterface.getItemStack("phosphor");
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)list);
        item = Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)new AspectList().add(Aspect.LIFE, 6));
        item = Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)new AspectList().add(Aspect.DEATH, 6));
        item = Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)new AspectList().add(Aspect.ARMOR, 6));
        item = Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (int[])new int[]{item.func_77960_j()}, (AspectList)new AspectList().add(Aspect.VOID, 6).add((Aspect)aspectTime, 8));
    }

    static {
        isThaumcraftPresent = false;
    }

    public static enum TreeType {
        GREATWOOD,
        SILVERWOOD;

    }

    public static enum BlockPlant {
        GREATWOOD_SAPLING,
        SILVERWOOD_SAPLING,
        SHIMMERLEAF,
        CINDERPEARL,
        PURIFYING_PLANT,
        VISHROOM;

    }

    public static enum Entity {
        BRAINY_ZOMBIE("entBrainyZombie", "EntityBrainyZombie"),
        GIANT_BRAINY_ZOMBIE("entGiantBrainyZombie", "EntityGiantBrainyZombie"),
        WISP("entWisp", "EntityWisp"),
        FIREBAT("entFirebat", "EntityFireBat");

        private static String packageName;
        public String entityID;
        private String className;

        private Entity(String id, String clazz) {
            this.entityID = id;
            this.className = clazz;
        }

        public String getClassName() {
            return packageName + this.className;
        }

        static {
            packageName = "thaumcraft.common.entities.monster.";
        }
    }

    public static enum AiryBlockType {
        NODE,
        NITOR,
        _2,
        _3,
        WARDING_STONE_FENCE,
        ENERGIZED_NODE;

    }

    public static enum WoodenDeviceType {
        BELLOWS,
        EAR,
        PRESSURE_PLATE,
        BORE_BASE,
        BORE,
        PLANKS_GREATWOOD,
        PLANKS_SILVERWOOD,
        BANNER;

    }

    public static enum MetalDeviceType {
        CRUCIBLE,
        ALEMBIC,
        VIS_CHARGE_RELAY,
        ADVANCED_ALCHEMICAL_CONSTRUCT,
        _4,
        ITEM_GRATE,
        _6,
        ARCANE_LAMP,
        LAMP_OF_GROWTH,
        ALCHEMICAL_CONSTRUCT,
        THAUMATORIUM,
        _11,
        MNEMONIC_MATRIX,
        LAMP_OF_FERTILITY,
        VIS_RELAY;

    }

    public static enum ShardType {
        AIR,
        FIRE,
        WATER,
        EARTH,
        ORDER,
        CHAOS,
        BALANCED;

    }

    public static enum NuggetType {
        IRON,
        COPPER,
        TIN,
        SILVER,
        LEAD,
        QUICKSILVER,
        THAUMIUM,
        _7,
        _8,
        _9,
        _10,
        _11,
        _12,
        _13,
        _14,
        _15,
        NATIVE_IRON,
        NATIVE_COPPER,
        NATIVE_TIN,
        NATIVE_SILVER,
        NATIVE_LEAD,
        _21,
        _22,
        _23,
        _24,
        _25,
        _26,
        _27,
        _28,
        _29,
        _30,
        NATIVE_GOLD;

    }

    public static enum MiscResource {
        ALUMENTUM,
        NITOR,
        THAUMIUM,
        QUICKSILVER,
        MAGIC_TALLOW,
        ZOMBIE_BRAIN,
        AMBER,
        ENCHANTED_FABRIC,
        FLUX_FILTER,
        KNOWLEDGE_FRAGMENT,
        MIRRORED_GLASS;

    }
}

