/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ErrorStateRegistry;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import magicbees.api.bees.IMagicApiaryAuraProvider;
import magicbees.bees.AuraCharge;
import magicbees.bees.BeeManager;
import magicbees.main.MagicBees;
import magicbees.main.utils.ChunkCoords;
import magicbees.main.utils.ItemStackUtils;
import magicbees.main.utils.net.EventAuraChargeUpdate;
import magicbees.main.utils.net.NetworkEventHandler;
import magicbees.tileentity.AuraCharges;
import magicbees.tileentity.ITileEntityAuraCharged;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class TileEntityMagicApiary
extends TileEntity
implements ISidedInventory,
IBeeHousing,
ITileEntityAuraCharged {
    public static final String tileEntityName = "magicbees.magicApiary";
    private GameProfile ownerProfile;
    private static final int SLOT_QUEEN = 0;
    private static final int SLOT_DRONE = 1;
    private static final int SLOT_FRAME_START = 2;
    private static final int SLOT_FRAME_COUNT = 3;
    private static final int SLOT_PRODUCTS_START = 5;
    private static final int SLOT_PRODUCTS_COUNT = 7;
    private static final int AURAPROVIDER_SEARCH_RADIUS = 6;
    private IBeekeepingLogic logic;
    private IMagicApiaryAuraProvider auraProvider;
    private ChunkCoords auraProviderPosition;
    private BiomeGenBase biome;
    private int displayHealthMax = 0;
    private int displayHealth = 0;
    private boolean init = false;
    private final AuraCharges auraCharges = new AuraCharges();
    private IErrorState errorState = ErrorStateRegistry.getErrorState((String)"ok");
    private Set<IErrorState> errors = new HashSet<IErrorState>();
    private ItemStack[] items = new ItemStack[12];

    public TileEntityMagicApiary() {
        this.logic = BeeManager.beeRoot.createBeekeepingLogic((IBeeHousing)this);
    }

    public void setOwner(EntityPlayer player) {
        this.ownerProfile = player.func_146103_bH();
    }

    public ItemStack getQueen() {
        return this.func_70301_a(0);
    }

    public ItemStack getDrone() {
        return this.func_70301_a(1);
    }

    public void setQueen(ItemStack itemstack) {
        this.func_70299_a(0, itemstack);
    }

    public void setDrone(ItemStack itemstack) {
        this.func_70299_a(1, itemstack);
    }

    public boolean canBreed() {
        return true;
    }

    public void onQueenChange(ItemStack queenStack) {
        if (!this.field_145850_b.field_72995_K) {
            MagicBees.object.netHandler.sendInventoryUpdate(this, 0, queenStack);
        }
    }

    public void wearOutEquipment(int amount) {
        int wear = Math.round((float)amount * BeeManager.beeRoot.getBeekeepingMode(this.field_145850_b).getWearModifier());
        for (int i = 2; i < 5; ++i) {
            if (this.func_70301_a(i) == null || !(this.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            this.func_70299_a(i, ((IHiveFrame)this.func_70301_a(i).func_77973_b()).frameUsed((IBeeHousing)this, this.func_70301_a(i), BeeManager.beeRoot.getMember(this.func_70301_a(0)), wear));
        }
    }

    public void onQueenDeath(IBee queen) {
    }

    public void onPostQueenDeath(IBee queen) {
    }

    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        return false;
    }

    public boolean onEggLaid(IBee queen) {
        return false;
    }

    private boolean isItemStackFrame(int i) {
        return this.func_70301_a(i) != null && this.func_70301_a(i).func_77973_b() instanceof IHiveFrame;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (int slotIndex = 2; slotIndex < 5; ++slotIndex) {
            if (!this.isItemStackFrame(slotIndex)) continue;
            mod *= ((IHiveFrame)this.func_70301_a(slotIndex).func_77973_b()).getTerritoryModifier(genome, mod);
        }
        return mod;
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        for (int slotIndex = 2; slotIndex < 5; ++slotIndex) {
            if (!this.isItemStackFrame(slotIndex)) continue;
            mod *= ((IHiveFrame)this.func_70301_a(slotIndex).func_77973_b()).getMutationModifier(genome, mate, mod);
        }
        if (this.isMutationBoosted()) {
            mod *= 2.0f;
        }
        return mod;
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        for (int slotIndex = 2; slotIndex < 5; ++slotIndex) {
            if (!this.isItemStackFrame(slotIndex)) continue;
            mod *= ((IHiveFrame)this.func_70301_a(slotIndex).func_77973_b()).getLifespanModifier(genome, mate, mod);
        }
        if (this.isDeathRateBoosted()) {
            mod /= 2.0f;
        }
        return mod;
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        float mod = 0.9f;
        for (int slotIndex = 2; slotIndex < 5; ++slotIndex) {
            if (!this.isItemStackFrame(slotIndex)) continue;
            mod *= ((IHiveFrame)this.func_70301_a(slotIndex).func_77973_b()).getProductionModifier(genome, mod);
        }
        if (this.isProductionBoosted()) {
            mod *= 2.0f;
        }
        return mod;
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (int slotIndex = 2; slotIndex < 5; ++slotIndex) {
            if (!this.isItemStackFrame(slotIndex)) continue;
            mod *= ((IHiveFrame)this.func_70301_a(slotIndex).func_77973_b()).getFloweringModifier(genome, mod);
        }
        return mod;
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        float mod = 0.8f;
        for (int slotIndex = 2; slotIndex < 5; ++slotIndex) {
            if (!this.isItemStackFrame(slotIndex)) continue;
            mod *= ((IHiveFrame)this.func_70301_a(slotIndex).func_77973_b()).getGeneticDecay(genome, mod);
        }
        return mod;
    }

    public boolean isSealed() {
        return false;
    }

    public boolean isSelfLighted() {
        return false;
    }

    public boolean isSunlightSimulated() {
        return false;
    }

    public boolean isHellish() {
        return false;
    }

    public GameProfile getOwnerName() {
        return this.ownerProfile;
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public int getXCoord() {
        return this.field_145851_c;
    }

    public int getYCoord() {
        return this.field_145848_d;
    }

    public int getZCoord() {
        return this.field_145849_e;
    }

    public BiomeGenBase getBiome() {
        return this.biome;
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue((float)this.getExactTemperature());
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)this.getExactHumidity());
    }

    public void setErrorState(IErrorState state) {
        this.errorState = state;
    }

    public IErrorState getErrorState() {
        return this.errorState;
    }

    public boolean setErrorCondition(boolean condition, IErrorState errorState) {
        if (!condition) {
            this.errors.add(errorState);
        } else {
            this.errors.remove(errorState);
        }
        return true;
    }

    public Set<IErrorState> getErrorStates() {
        return this.errors;
    }

    public boolean addProduct(ItemStack product, boolean all) {
        int countAdded = ItemStackUtils.addItemToInventory((IInventory)this, product, 5, 7);
        if (all) {
            return countAdded == product.field_77994_a;
        }
        return countAdded > 0;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                itemStack = itemStack.func_77979_a(j);
                this.func_70296_d();
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        this.func_70299_a(i, null);
        return item;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.items[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return tileEntityName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        if (side == 0 || side == 1) {
            return new int[]{0, 1};
        }
        int[] slots = new int[7];
        int slot = 5;
        for (int i = 0; i < 7; ++i) {
            slots[i] = slot++;
        }
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        if (slot == 0 && BeeManager.beeRoot.isMember(itemStack) && !BeeManager.beeRoot.isDrone(itemStack)) {
            return true;
        }
        if (slot == 1 && BeeManager.beeRoot.isDrone(itemStack)) {
            return true;
        }
        return slot == 1 && BeeManager.beeRoot.isDrone(itemStack);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        switch (slot) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    private int getHealthDisplay() {
        if (this.func_70301_a(0) == null) {
            return 0;
        }
        if (BeeManager.beeRoot.isMated(this.func_70301_a(0))) {
            return BeeManager.beeRoot.getMember(this.func_70301_a(0)).getHealth();
        }
        if (!BeeManager.beeRoot.isDrone(this.func_70301_a(0))) {
            return this.displayHealth;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        if (this.func_70301_a(0) == null) {
            return 0;
        }
        if (BeeManager.beeRoot.isMated(this.func_70301_a(0))) {
            return BeeManager.beeRoot.getMember(this.func_70301_a(0)).getMaxHealth();
        }
        if (!BeeManager.beeRoot.isDrone(this.func_70301_a(0))) {
            return this.displayHealthMax;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    public int getTemperatureScaled(int i) {
        return Math.round((float)i * (this.getExactTemperature() / 2.0f));
    }

    public int getHumidityScaled(int i) {
        return Math.round((float)i * this.getExactHumidity());
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            itemStack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Items", (NBTBase)items);
        compound.func_74768_a("BiomeId", this.biome.field_76756_M);
        if (this.logic != null) {
            this.logic.writeToNBT(compound);
        }
        ChunkCoords.writeToNBT(this.auraProviderPosition, compound);
        this.auraCharges.writeToNBT(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList items = compound.func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
        int biomeId = compound.func_74762_e("BiomeId");
        this.biome = BiomeGenBase.func_150568_d((int)biomeId);
        this.logic.readFromNBT(compound);
        this.auraProviderPosition = ChunkCoords.readFromNBT(compound);
        this.auraCharges.readFromNBT(compound);
    }

    public Packet func_145844_m() {
        EventAuraChargeUpdate event = new EventAuraChargeUpdate(new ChunkCoords(this), this.auraCharges);
        return event.getPacket();
    }

    public float getExactTemperature() {
        return this.biome.field_76750_F;
    }

    public float getExactHumidity() {
        return this.biome.field_76751_G;
    }

    public void func_145845_h() {
        if (!this.init) {
            this.init = true;
            this.updateBiome();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateClientSide();
        } else {
            this.updateServerSide();
        }
    }

    public void updateBiome() {
        BiomeGenBase biome;
        if (this.field_145850_b != null && this.biome == null && (biome = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e)) != null) {
            this.biome = biome;
            this.setErrorState(ErrorStateRegistry.getErrorState((String)"OK"));
        }
    }

    public void updateClientSide() {
        if (BeeManager.beeRoot.isMated(this.func_70301_a(0)) && this.getErrorState() == ErrorStateRegistry.getErrorState((String)"OK") && this.field_145850_b.func_82737_E() % 10L == 0L) {
            IBee displayQueen = BeeManager.beeRoot.getMember(this.func_70301_a(0));
            displayQueen.doFX(this.logic.getEffectData(), (IBeeHousing)this);
        }
    }

    public void updateServerSide() {
        IBee queen;
        if (this.auraProvider == null) {
            this.findAuraProvider();
        } else {
            this.updateAuraProvider();
        }
        this.tickCharges();
        if (this.logic.canWork()) {
            this.logic.doWork();
        }
        if ((queen = this.logic.getQueen()) == null) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 5L == 0L) {
            this.onQueenChange(this.func_70301_a(0));
        }
    }

    public void getGUINetworkData(int i, int j) {
        if (this.logic == null) {
            return;
        }
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        if (this.logic == null) {
            return;
        }
        iCrafting.func_71112_a(container, 0, this.logic.getBreedingTime());
        iCrafting.func_71112_a(container, 1, this.logic.getTotalBreedingTime());
    }

    public boolean isProductionBoosted() {
        return this.auraCharges.isActive(AuraCharge.PRODUCTION);
    }

    public boolean isDeathRateBoosted() {
        return this.auraCharges.isActive(AuraCharge.DEATH);
    }

    public boolean isMutationBoosted() {
        return this.auraCharges.isActive(AuraCharge.MUTATION);
    }

    private void updateAuraProvider() {
        if (this.field_145850_b.func_82737_E() % 10L != 0L) {
            return;
        }
        if (this.getAuraProvider(this.auraProviderPosition) == null) {
            this.auraProvider = null;
            this.auraProviderPosition = null;
            return;
        }
        boolean auraChargesChanged = false;
        for (AuraCharge charge : AuraCharge.values()) {
            if (this.auraCharges.isActive(charge) || !this.auraProvider.getCharge(charge.type)) continue;
            this.auraCharges.start(charge, this.field_145850_b);
            auraChargesChanged = true;
        }
        if (auraChargesChanged) {
            NetworkEventHandler.getInstance().sendAuraChargeUpdate(this, this.auraCharges);
        }
    }

    private void tickCharges() {
        boolean auraChargesChanged = false;
        for (AuraCharge charge : AuraCharge.values()) {
            if (!this.auraCharges.isActive(charge) || !this.auraCharges.isExpired(charge, this.field_145850_b) || this.auraProvider != null && this.auraProvider.getCharge(charge.type)) continue;
            this.auraCharges.stop(charge);
            auraChargesChanged = true;
        }
        if (auraChargesChanged) {
            NetworkEventHandler.getInstance().sendAuraChargeUpdate(this, this.auraCharges);
        }
    }

    private void findAuraProvider() {
        if (this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        if (this.auraProviderPosition == null) {
            List<Chunk> chunks = this.getChunksInSearchRange();
            for (Chunk chunk : chunks) {
                if (this.searchChunkForBooster(chunk)) break;
            }
        } else {
            this.auraProvider = this.getAuraProvider(this.auraProviderPosition);
            if (this.auraProvider == null) {
                this.auraProviderPosition = null;
            }
        }
    }

    private List<Chunk> getChunksInSearchRange() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(4);
        chunks.add(this.field_145850_b.func_72938_d(this.field_145851_c - 6, this.field_145849_e - 6));
        Chunk chunk = this.field_145850_b.func_72938_d(this.field_145851_c + 6, this.field_145849_e - 6);
        if (!chunks.contains(chunk)) {
            chunks.add(chunk);
        }
        if (!chunks.contains(chunk = this.field_145850_b.func_72938_d(this.field_145851_c - 6, this.field_145849_e + 6))) {
            chunks.add(chunk);
        }
        if (!chunks.contains(chunk = this.field_145850_b.func_72938_d(this.field_145851_c + 6, this.field_145849_e + 6))) {
            chunks.add(chunk);
        }
        return chunks;
    }

    private boolean searchChunkForBooster(Chunk chunk) {
        Vec3 apiaryPos = Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        for (Map.Entry entry : chunk.field_150816_i.entrySet()) {
            Vec3 tePos;
            Vec3 result;
            TileEntity entity = (TileEntity)entry.getValue();
            if (!(entity instanceof IMagicApiaryAuraProvider) || !((result = apiaryPos.func_72444_a(tePos = Vec3.func_72443_a((double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e))).func_72433_c() <= 6.0)) continue;
            this.saveAuraProviderPosition(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
            this.auraProvider = (IMagicApiaryAuraProvider)entity;
            return true;
        }
        return false;
    }

    private void saveAuraProviderPosition(int x, int y, int z) {
        this.auraProviderPosition = new ChunkCoords(this.field_145850_b.field_73011_w.field_76574_g, x, y, z);
    }

    private IMagicApiaryAuraProvider getAuraProvider(ChunkCoords coords) {
        return this.getAuraProvider(coords.x, coords.y, coords.z);
    }

    private IMagicApiaryAuraProvider getAuraProvider(int x, int y, int z) {
        ChunkPosition cPos;
        TileEntity entity;
        Chunk chunk = this.field_145850_b.func_72938_d(x, z);
        z %= 16;
        if ((x %= 16) < 0) {
            x += 16;
        }
        if (z < 0) {
            z += 16;
        }
        if (!((entity = (TileEntity)chunk.field_150816_i.get(cPos = new ChunkPosition(x, y, z))) instanceof IMagicApiaryAuraProvider)) {
            return null;
        }
        return (IMagicApiaryAuraProvider)entity;
    }

    @Override
    public AuraCharges getAuraCharges() {
        return this.auraCharges;
    }
}

