/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.client.gui.GuiReactorRedNetPort;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorPart;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.container.ContainerBasic;
import erogenousbeef.bigreactors.net.helpers.RedNetChange;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetInputNode;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetNetworkContainer;

public class TileEntityReactorRedNetPort
extends TileEntityReactorPart
implements ITickableMultiblockPart,
INeighborUpdatableEntity {
    protected static final int minInputEnumValue = CircuitType.inputActive.ordinal();
    protected static final int maxInputEnumValue = CircuitType.inputEjectWaste.ordinal();
    protected static final int minOutputEnumValue = CircuitType.outputFuelTemperature.ordinal();
    protected static final int maxOutputEnumValue = CircuitType.outputEnergyAmount.ordinal();
    protected CircuitType[] channelCircuitTypes = new CircuitType[16];
    protected CoordTriplet[] coordMappings = new CoordTriplet[16];
    protected boolean[] inputActivatesOnPulse = new boolean[16];
    protected int[] oldValue = new int[16];
    public static final int numChannels = 16;
    IRedNetNetworkContainer redNetwork;
    IRedNetInputNode redNetInput;
    int ticksSinceLastUpdate;

    public TileEntityReactorRedNetPort() {
        for (int i = 0; i < 16; ++i) {
            this.channelCircuitTypes[i] = CircuitType.DISABLED;
            this.coordMappings[i] = null;
            this.inputActivatesOnPulse[i] = false;
            this.oldValue[i] = 0;
        }
        this.redNetwork = null;
        this.redNetInput = null;
        this.ticksSinceLastUpdate = 0;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.checkForConnections((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockController) {
        super.onMachineAssembled(multiblockController);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.checkForConnections((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiElement(InventoryPlayer inventoryPlayer) {
        return new GuiReactorRedNetPort(new ContainerBasic(), this);
    }

    @Override
    public Object getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerBasic();
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.encodeSettings(par1NBTTagCompound);
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        this.encodeSettings(packetData);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.decodeSettings(par1NBTTagCompound);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.decodeSettings(packetData);
    }

    public int[] getOutputValues() {
        int[] outputs = new int[16];
        for (int i = 0; i < 16; ++i) {
            outputs[i] = this.getValueForChannel(i);
        }
        return outputs;
    }

    public int getValueForChannel(int channel) {
        if (channel < 0 || channel >= 16) {
            return 0;
        }
        if (!this.isConnected()) {
            return 0;
        }
        Object te = null;
        switch (this.channelCircuitTypes[channel]) {
            case outputFuelTemperature: {
                return (int)Math.floor(this.getReactorController().getFuelHeat());
            }
            case outputCasingTemperature: {
                return (int)Math.floor(this.getReactorController().getReactorHeat());
            }
            case outputFuelMix: {
                MultiblockReactor controller = this.getReactorController();
                return (int)Math.floor((float)controller.getFuelAmount() / (float)controller.getCapacity() * 100.0f);
            }
            case outputFuelAmount: {
                return this.getReactorController().getFuelAmount();
            }
            case outputWasteAmount: {
                return this.getReactorController().getWasteAmount();
            }
            case outputEnergyAmount: {
                MultiblockReactor reactor = this.getReactorController();
                if (reactor != null) {
                    return reactor.getEnergyStoredPercentage();
                }
                return 0;
            }
        }
        return 0;
    }

    public void onInputValuesChanged(int[] newValues) {
        for (int i = 0; i < newValues.length; ++i) {
            this.onInputValueChanged(i, newValues[i]);
        }
    }

    public void onInputValueChanged(int channel, int newValue) {
        if (channel < 0 || channel >= 16) {
            return;
        }
        CircuitType type = this.channelCircuitTypes[channel];
        if (!TileEntityReactorRedNetPort.isInput(type)) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (newValue == this.oldValue[channel]) {
            return;
        }
        boolean isPulse = this.oldValue[channel] == 0 && newValue != 0;
        MultiblockReactor reactor = null;
        switch (type) {
            case inputActive: {
                boolean newActive;
                reactor = this.getReactorController();
                if (this.inputActivatesOnPulse[channel]) {
                    if (!isPulse) break;
                    reactor.setActive(!reactor.getActive());
                    break;
                }
                boolean bl = newActive = newValue != 0;
                if (newActive == reactor.getActive()) break;
                reactor.setActive(newActive);
                break;
            }
            case inputSetControlRod: {
                newValue = Math.min(100, Math.max(0, newValue));
                if (newValue == this.oldValue[channel]) {
                    return;
                }
                if (this.coordMappings[channel] != null) {
                    this.setControlRodInsertion(channel, this.coordMappings[channel], newValue);
                    break;
                }
                reactor = this.getReactorController();
                reactor.setAllControlRodInsertionValues(newValue);
                break;
            }
            case inputEjectWaste: {
                if (!isPulse) break;
                reactor = this.getReactorController();
                reactor.ejectWaste(false, null);
            }
        }
        this.oldValue[channel] = newValue;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlock) {
        this.checkForConnections((IBlockAccess)world, x, y, z);
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, int x, int y, int z, int neighborX, int neighborY, int neighborZ) {
        this.checkForConnections(world, x, y, z);
    }

    @Override
    public void onMultiblockServerTick() {
        if (!this.isConnected()) {
            return;
        }
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate < BigReactors.ticksPerRedstoneUpdate) {
            return;
        }
        ForgeDirection out = this.getOutwardsDir();
        if (this.redNetwork != null) {
            this.redNetwork.updateNetwork(this.field_145850_b, this.field_145851_c + out.offsetX, this.field_145848_d + out.offsetY, this.field_145849_e + out.offsetZ, out.getOpposite());
        }
        if (this.redNetInput != null) {
            this.redNetInput.onInputsChanged(this.field_145850_b, this.field_145851_c + out.offsetX, this.field_145848_d + out.offsetY, this.field_145849_e + out.offsetZ, out.getOpposite(), this.getOutputValues());
        }
        this.ticksSinceLastUpdate = 0;
    }

    public CircuitType getChannelCircuitType(int channel) {
        if (channel < 0 || channel >= 16) {
            return CircuitType.DISABLED;
        }
        return this.channelCircuitTypes[channel];
    }

    public CoordTriplet getMappedCoord(int channel) {
        return this.coordMappings[channel];
    }

    public boolean isInputActivatedOnPulse(int channel) {
        return this.inputActivatesOnPulse[channel];
    }

    protected void clearChannel(int channel) {
        this.channelCircuitTypes[channel] = CircuitType.DISABLED;
        this.coordMappings[channel] = null;
        this.inputActivatesOnPulse[channel] = false;
        this.oldValue[channel] = 0;
    }

    protected TileEntity getMappedTileEntity(int channel) {
        if (channel < 0 || channel >= 16) {
            return null;
        }
        if (this.coordMappings[channel] == null) {
            return null;
        }
        CoordTriplet coord = this.coordMappings[channel];
        if (coord == null) {
            return null;
        }
        if (!this.field_145850_b.func_72904_c(coord.x, coord.y, coord.z, coord.x, coord.y, coord.z)) {
            return null;
        }
        return this.field_145850_b.func_147438_o(coord.x, coord.y, coord.z);
    }

    protected void setControlRodInsertion(int channel, CoordTriplet coordTriplet, int newValue) {
        if (!this.isConnected()) {
            return;
        }
        if (!this.field_145850_b.func_72904_c(coordTriplet.x, coordTriplet.y, coordTriplet.z, coordTriplet.x, coordTriplet.y, coordTriplet.z)) {
            return;
        }
        TileEntity te = this.field_145850_b.func_147438_o(coordTriplet.x, coordTriplet.y, coordTriplet.z);
        if (te instanceof TileEntityReactorControlRod) {
            ((TileEntityReactorControlRod)te).setControlRodInsertion((short)newValue);
        } else {
            this.clearChannel(channel);
        }
    }

    protected NBTTagCompound encodeSetting(int channel) {
        CoordTriplet coord;
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74768_a("channel", channel);
        entry.func_74768_a("setting", this.channelCircuitTypes[channel].ordinal());
        if (TileEntityReactorRedNetPort.isInput(this.channelCircuitTypes[channel]) && CircuitType.canBeToggledBetweenPulseAndNormal(this.channelCircuitTypes[channel])) {
            entry.func_74757_a("pulse", this.inputActivatesOnPulse[channel]);
        }
        if (CircuitType.hasCoordinate(this.channelCircuitTypes[channel]) && (coord = this.coordMappings[channel]) != null) {
            entry.func_74768_a("x", coord.x);
            entry.func_74768_a("y", coord.y);
            entry.func_74768_a("z", coord.z);
        }
        return entry;
    }

    protected void decodeSetting(NBTTagCompound settingTag) {
        int channel = settingTag.func_74762_e("channel");
        int settingIdx = settingTag.func_74762_e("setting");
        this.clearChannel(channel);
        this.channelCircuitTypes[channel] = CircuitType.values()[settingIdx];
        if (TileEntityReactorRedNetPort.isInput(this.channelCircuitTypes[channel]) && CircuitType.canBeToggledBetweenPulseAndNormal(this.channelCircuitTypes[channel])) {
            this.inputActivatesOnPulse[channel] = settingTag.func_74767_n("pulse");
        }
        if (CircuitType.hasCoordinate(this.channelCircuitTypes[channel]) && settingTag.func_74764_b("x")) {
            int x = settingTag.func_74762_e("x");
            int y = settingTag.func_74762_e("y");
            int z = settingTag.func_74762_e("z");
            this.coordMappings[channel] = new CoordTriplet(x, y, z);
        }
    }

    public void onCircuitUpdate(RedNetChange[] changes) {
        if (changes == null || changes.length < 1) {
            return;
        }
        for (int i = 0; i < changes.length; ++i) {
            CircuitType newType;
            int channelID = changes[i].getChannel();
            this.channelCircuitTypes[channelID] = newType = changes[i].getType();
            if (CircuitType.canBeToggledBetweenPulseAndNormal(newType)) {
                this.inputActivatesOnPulse[channelID] = changes[i].getPulseOrToggle();
            }
            if (CircuitType.hasCoordinate(newType)) {
                TileEntity te;
                CoordTriplet coord = changes[i].getCoord();
                if (coord != null && !((te = this.field_145850_b.func_147438_o(coord.x, coord.y, coord.z)) instanceof TileEntityReactorControlRod)) {
                    BRLog.warning("Invalid tile entity reference at coordinate %s - rednet circuit expected a control rod", coord);
                    coord = null;
                }
                this.coordMappings[channelID] = coord;
                continue;
            }
            this.coordMappings[channelID] = null;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    protected void encodeSettings(NBTTagCompound destination) {
        NBTTagList tagArray = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            tagArray.func_74742_a((NBTBase)this.encodeSetting(i));
        }
        destination.func_74782_a("redNetConfig", (NBTBase)tagArray);
    }

    protected void decodeSettings(NBTTagCompound source) {
        NBTTagList tagArray = source.func_150295_c("redNetConfig", 10);
        for (int i = 0; i < tagArray.func_74745_c(); ++i) {
            this.decodeSetting(tagArray.func_150305_b(i));
        }
    }

    protected void checkForConnections(IBlockAccess world, int x, int y, int z) {
        ForgeDirection out = this.getOutwardsDir();
        if (out == ForgeDirection.UNKNOWN) {
            this.redNetwork = null;
            this.redNetInput = null;
        } else {
            this.redNetwork = null;
            this.redNetInput = null;
            Block b = this.field_145850_b.func_147439_a(x + out.offsetX, y + out.offsetY, z + out.offsetZ);
            if (!(b instanceof BlockReactorPart)) {
                if (b instanceof IRedNetNetworkContainer) {
                    this.redNetwork = (IRedNetNetworkContainer)b;
                } else if (b instanceof IRedNetInputNode) {
                    this.redNetInput = (IRedNetInputNode)b;
                }
            }
        }
    }

    public static boolean isInput(CircuitType type) {
        return type.ordinal() >= minInputEnumValue && type.ordinal() <= maxInputEnumValue;
    }

    public static boolean isOutput(CircuitType type) {
        return type.ordinal() >= minOutputEnumValue && type.ordinal() <= maxOutputEnumValue;
    }

    public static enum CircuitType {
        DISABLED,
        inputActive,
        inputSetControlRod,
        inputEjectWaste,
        outputFuelTemperature,
        outputCasingTemperature,
        outputFuelMix,
        outputFuelAmount,
        outputWasteAmount,
        outputEnergyAmount;

        public static final CircuitType[] s_Types;

        public static boolean hasCoordinate(CircuitType circuitType) {
            return circuitType == inputSetControlRod;
        }

        public static boolean canBeToggledBetweenPulseAndNormal(CircuitType circuitType) {
            return circuitType == inputActive;
        }

        static {
            s_Types = CircuitType.values();
        }
    }
}

