/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.net.helpers.RedNetChange;
import erogenousbeef.bigreactors.net.message.base.TileMessageServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;

public class ReactorRedNetPortChangeMessage
extends TileMessageServer<TileEntityReactorRedNetPort> {
    private RedNetChange[] changes;

    public ReactorRedNetPortChangeMessage() {
        this.changes = null;
    }

    public ReactorRedNetPortChangeMessage(TileEntityReactorRedNetPort port, RedNetChange[] changes) {
        super(port);
        this.changes = changes;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int numChanges = buf.readInt();
        if (numChanges < 1) {
            return;
        }
        this.changes = new RedNetChange[numChanges];
        for (int i = 0; i < numChanges; ++i) {
            this.changes[i] = RedNetChange.fromBytes(buf);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.changes == null || this.changes.length < 1) {
            buf.writeInt(0);
            return;
        }
        buf.writeInt(this.changes.length);
        for (int i = 0; i < this.changes.length; ++i) {
            this.changes[i].toBytes(buf);
        }
    }

    public static class Handler
    extends TileMessageServer.Handler<ReactorRedNetPortChangeMessage, TileEntityReactorRedNetPort> {
        @Override
        public IMessage handle(ReactorRedNetPortChangeMessage message, MessageContext ctx, TileEntityReactorRedNetPort port) {
            port.onCircuitUpdate(message.changes);
            return null;
        }

        @Override
        public TileEntityReactorRedNetPort getImpl(TileEntity te) {
            return te instanceof TileEntityReactorRedNetPort ? (TileEntityReactorRedNetPort)te : null;
        }
    }
}

