/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import toast.deadlyWorld.AttributeHelper;
import toast.deadlyWorld.EffectHelper;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld.feature.WorldFeature;

public class Skeleturret
implements WorldFeature {
    public static final double FIRE_CHANCE = Properties.getDouble("skeleton_turrets", "fire_bow_chance");
    public static final double HEALTH_MULT = Properties.getDouble("skeleton_turrets", "health_multiplier");
    public static final ItemStack[] EQUIPMENT = new ItemStack[5];
    public final double frequency;

    public Skeleturret(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int state = 0;
        for (int y = random.nextInt(30) + 12; y > 5; --y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state != 0) continue;
                if (this.canBePlaced(world, random, x, y, z)) {
                    this.place(world, random, x, y, z);
                    return;
                }
                state = -1;
                continue;
            }
            state = 0;
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return world.func_147445_c(x, y - 1, z, false) && world.func_147445_c(x - 1, y, z, false) && world.func_147445_c(x + 1, y, z, false) && world.func_147445_c(x, y, z - 1, false) && world.func_147445_c(x, y, z + 1, false) && world.func_147437_c(x, y + 1, z);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        EntitySkeleton turret = new EntitySkeleton(world);
        AttributeHelper.baseMult((EntityLivingBase)turret, SharedMonsterAttributes.field_111267_a, "DW|TurretHealthMult", HEALTH_MULT);
        AttributeHelper.shift((EntityLivingBase)turret, SharedMonsterAttributes.field_111266_c, "DW|TurretKnockbackResist", 1.0);
        AttributeHelper.mult((EntityLivingBase)turret, SharedMonsterAttributes.field_111263_d, "DW|TurretSpeedMult", -1.0);
        AttributeHelper.set((EntityLivingBase)turret, SharedMonsterAttributes.field_111265_b, "DW|TurretFollowRange", 14.0);
        turret.func_70606_j(turret.func_110138_aP());
        turret.func_70080_a((double)x + 0.5, (double)y, (double)z + 0.5, random.nextFloat() * 360.0f, 0.0f);
        turret.func_110163_bv();
        ItemStack bow = EQUIPMENT[0].func_77946_l();
        if (random.nextDouble() < FIRE_CHANCE) {
            bow.func_77966_a(Enchantment.field_77343_v, 1);
        }
        turret.func_70062_b(0, bow);
        int i = EQUIPMENT.length;
        while (i-- > 1) {
            turret.func_70062_b(i, EQUIPMENT[i].func_77946_l());
        }
        turret.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, true));
        turret.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, Integer.MAX_VALUE, 0, true));
        turret.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, Integer.MAX_VALUE, 0, true));
        world.func_72838_d((Entity)turret);
    }

    static {
        Skeleturret.EQUIPMENT[0] = new ItemStack((Item)Items.field_151031_f);
        EQUIPMENT[0].func_151001_c("\u00a7bTurret Cannon");
        EQUIPMENT[0].func_77966_a(Enchantment.field_77345_t, Math.max(0, Math.min(10, Properties.getInt("skeleton_turrets", "bow_power"))));
        EffectHelper.addModifier(EQUIPMENT[0], SharedMonsterAttributes.field_111263_d.func_111108_a(), -1.0, 2);
        Skeleturret.EQUIPMENT[4] = new ItemStack(Blocks.field_150367_z);
        Skeleturret.EQUIPMENT[3] = new ItemStack((Item)Items.field_151027_R);
        Skeleturret.EQUIPMENT[2] = new ItemStack((Item)Items.field_151026_S);
        Skeleturret.EQUIPMENT[1] = new ItemStack((Item)Items.field_151021_T);
        int i = 4;
        while (i-- > 1) {
            EQUIPMENT[i].func_151001_c("\u00a7bTurret Plating");
            EffectHelper.dye(EQUIPMENT[i], 0x707070);
            EffectHelper.addModifier(EQUIPMENT[i], SharedMonsterAttributes.field_111263_d.func_111108_a(), -0.33, 1);
        }
    }
}

