/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import toast.deadlyWorld.feature.WorldFeature;

public class VeinFeature
implements WorldFeature {
    public final double veinCount;
    public final Block block;
    public int blockMeta = 0;
    public final int veinSize;
    public Block blockReplace = Blocks.field_150348_b;
    public final int heightMin;
    public final int heightMax;

    public VeinFeature(double count, Block block, int size, int min, int max) {
        if (size < 1) {
            size = 1;
        }
        if (min < 0) {
            min = 0;
        } else if (min > 255) {
            min = 255;
        }
        if (max < min) {
            max = min;
        } else if (max > 255) {
            max = 255;
        }
        this.veinCount = count;
        this.block = block;
        this.veinSize = size;
        this.heightMin = min;
        this.heightMax = max;
    }

    public VeinFeature setMetadata(int meta) {
        this.blockMeta = meta;
        return this;
    }

    public VeinFeature setBlockReplace(Block block) {
        this.blockReplace = block;
        return this;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        for (double count = this.veinCount; count >= 1.0 || count > 0.0 && count > random.nextDouble(); count -= 1.0) {
            this.place(world, random, x + random.nextInt(16), random.nextInt(this.heightMax - this.heightMin) + this.heightMin, z + random.nextInt(16));
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return true;
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        float rotation = random.nextFloat() * (float)Math.PI;
        double xiMin = (double)x + 8.0 + Math.sin(rotation) * (double)this.veinSize / 8.0;
        double xiMax = (double)x + 8.0 - Math.sin(rotation) * (double)this.veinSize / 8.0;
        double ziMin = (double)z + 8.0 + Math.cos(rotation) * (double)this.veinSize / 8.0;
        double ziMax = (double)z + 8.0 - Math.cos(rotation) * (double)this.veinSize / 8.0;
        double yiMin = y + random.nextInt(3) - 2;
        double yiMax = y + random.nextInt(3) - 2;
        for (int i = 0; i <= this.veinSize; ++i) {
            double dxi = xiMin + (xiMax - xiMin) * (double)i / (double)this.veinSize;
            double dyi = yiMin + (yiMax - yiMin) * (double)i / (double)this.veinSize;
            double dzi = ziMin + (ziMax - ziMin) * (double)i / (double)this.veinSize;
            double rad = (Math.sin((double)i * Math.PI / (double)this.veinSize) + 1.0) * random.nextDouble() * (double)this.veinSize / 16.0 + 1.0;
            int xMin = (int)Math.floor(dxi - rad / 2.0);
            int yMin = (int)Math.floor(dyi - rad / 2.0);
            int zMin = (int)Math.floor(dzi - rad / 2.0);
            int xMax = (int)Math.floor(dxi + rad / 2.0);
            int yMax = (int)Math.floor(dyi + rad / 2.0);
            int zMax = (int)Math.floor(dzi + rad / 2.0);
            for (x = xMin; x <= xMax; ++x) {
                double dx = ((double)x + 0.5 - dxi) / (rad / 2.0);
                if (!(dx * dx < 1.0)) continue;
                for (y = yMin; y <= yMax; ++y) {
                    double dy = ((double)y + 0.5 - dyi) / (rad / 2.0);
                    if (!(dx * dx + dy * dy < 1.0)) continue;
                    for (z = zMin; z <= zMax; ++z) {
                        double dz = ((double)z + 0.5 - dzi) / (rad / 2.0);
                        Block block = world.func_147439_a(x, y, z);
                        if (!(dx * dx + dy * dy + dz * dz < 1.0) || !this.canBePlaced(world, random, x, y, z) || block == null || !block.isReplaceableOreGen(world, x, y, z, this.blockReplace)) continue;
                        world.func_147465_d(x, y, z, this.block, this.blockMeta, 2);
                    }
                }
            }
        }
    }
}

