/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.generic;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.addons.tinkersconstruct.AddonTinkersTiles;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonGenericTiles
implements IWailaDataProvider {
    private static Field currentBlockDamage;
    private static String showTool;
    private static String showHarvestable;
    private static String showTier;
    private static String showProgress;
    private static String showDay;
    private static String showMonsterSpawn;
    private static String showLightLevel;

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        double progress;
        int itemLevel;
        MovingObjectPosition pos = data.getPosition();
        Block block = data.getBlock();
        ItemStack item = data.getPlayer().func_70694_bm();
        String tool = block != null ? block.getHarvestTool(data.getMetadata()) : "";
        int blockLevel = block.getHarvestLevel(data.getMetadata());
        int n = itemLevel = item != null ? item.func_77973_b().getHarvestLevel(item, tool) : 0;
        if (tool != null && tool.equalsIgnoreCase("chisel")) {
            if (block == Blocks.field_150348_b) {
                tool = "pickaxe";
            }
            if (block == Blocks.field_150344_f) {
                tool = "axe";
            }
        }
        if (item != null && (item.func_77973_b().getToolClasses(item).contains(tool) || AddonTinkersTiles.canHarvest(item, tool))) {
            if (cfg.getConfig(showHarvestable) && (blockLevel <= itemLevel || blockLevel == 0)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.canHarvest") + ": " + EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"tooltip.wawla.yes"));
            } else {
                if (cfg.getConfig(showHarvestable)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.canHarvest") + ": " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tooltip.wawla.no"));
                }
                if (cfg.getConfig(showTier)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.blockLevel") + ": " + blockLevel);
                }
                if (tool != null && cfg.getConfig(showTool)) {
                    String translation = StatCollector.func_74838_a((String)("tooltip.wawla.tooltype." + tool));
                    if (translation.startsWith("tooltip.wawla.tooltype.")) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.toolType") + ": " + tool);
                    } else {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.toolType") + ": " + translation);
                    }
                }
            }
        }
        if (cfg.getConfig(showLightLevel) && (!data.getWorld().func_147445_c(data.getPosition().field_72311_b, data.getPosition().field_72312_c + 1, data.getPosition().field_72309_d, false) || data.getWorld().func_147437_c(data.getPosition().field_72311_b, data.getPosition().field_72312_c + 1, data.getPosition().field_72309_d))) {
            int dayLevel = Utilities.getBlockLightLevel(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d, true);
            int nightLevel = Utilities.getBlockLightLevel(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d, false);
            String display = StatCollector.func_74838_a((String)"tooltip.wawla.lightLevel") + ": ";
            if (cfg.getConfig(showMonsterSpawn)) {
                if (nightLevel <= 7) {
                    display = display + EnumChatFormatting.DARK_RED + "" + nightLevel + " ";
                } else if (nightLevel > 7) {
                    display = display + EnumChatFormatting.GREEN + "" + nightLevel + " ";
                }
            }
            if (cfg.getConfig(showDay)) {
                display = display + EnumChatFormatting.YELLOW + "(" + dayLevel + ")";
            }
            tip.add(display);
        }
        if (cfg.getConfig(showProgress) && data.getPlayer().field_70170_p.field_72995_K && currentBlockDamage != null && (progress = Utilities.round(this.getBlockDamage(), 2)) > 0.0) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.progress") + ": " + (int)(progress * 100.0) + "%");
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonGenericTiles dataProvider = new AddonGenericTiles();
        register.addConfig("Wawla-General", showTool);
        register.addConfig("Wawla-General", showHarvestable);
        register.addConfig("Wawla-General", showTier);
        register.addConfig("Wawla-General", showProgress);
        register.addConfig("Wawla-General", showLightLevel);
        register.addConfig("Wawla-General", showMonsterSpawn);
        register.addConfig("Wawla-General", showDay);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, Block.class);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, Block.class);
        if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            currentBlockDamage = ReflectionHelper.findField(PlayerControllerMP.class, (String[])new String[]{"g", "field_78770_f", "curBlockDamageMP"});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getBlockDamage() {
        try {
            return currentBlockDamage.getFloat(Minecraft.func_71410_x().field_71442_b);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return 0.0f;
    }

    static {
        showTool = "wawla.harvest.showTool";
        showHarvestable = "wawla.harvest.showHarvest";
        showTier = "wawla.harvest.showTier";
        showProgress = "wawla.harvest.showProgress";
        showDay = "wawla.light.showDay";
        showMonsterSpawn = "wawla.light.monsterSpawn";
        showLightLevel = "wawla.light.lightLevel";
    }
}

