/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.village;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import toast.specialAI.Properties;
import toast.specialAI.util.BlockHelper;
import toast.specialAI.util.TargetBlock;

public class ReputationHandler {
    private static final boolean HOUSE_REP = Properties.getBoolean("villages", "house_rep");
    private static final boolean REFRESH_HOUSES = Properties.getBoolean("villages", "refresh_houses");
    private static final double BLOCK_REP_CHANCE = Properties.getDouble("villages", "block_rep_loss_chance");
    private static final int BLOCK_REP_LIMIT = Properties.getInt("villages", "block_rep_loss_limit");
    private static final double BLOCK_DEFEND_CHANCE = Properties.getDouble("villages", "block_aggression_chance");
    private static final int BLOCK_DEFEND_LIMIT = Properties.getInt("villages", "block_aggression_limit");
    private static final HashSet<TargetBlock> BLOCK_BLACKLIST = BlockHelper.newBlockSet(Properties.getString("villages", "block_blacklist"));
    private static final HashSet<TargetBlock> BLOCK_WHITELIST = BlockHelper.newBlockSet(Properties.getString("villages", "block_whitelist"));
    private static final double SPECIAL_REP_CHANCE = Properties.getDouble("villages", "block_special_rep_loss_chance");
    private static final double SPECIAL_DEFEND_CHANCE = Properties.getDouble("villages", "block_special_aggression_chance");
    private static final HashSet<TargetBlock> SPECIAL_LIST = BlockHelper.newBlockSet(Properties.getString("villages", "block_special_list"));
    private static final double HELP_REP_CHANCE = Properties.getDouble("villages", "help_rep_chance");
    private int updateTicks = 0;
    private final HashMap<Village, Integer> doorCountCache = new HashMap();

    public static int getDefendLimit() {
        return BLOCK_DEFEND_LIMIT;
    }

    public ReputationHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            --this.updateTicks;
            if (this.updateTicks % 40 == 0) {
                boolean refreshDoors;
                boolean bl = refreshDoors = this.updateTicks <= 0;
                if (refreshDoors) {
                    this.updateTicks = 400;
                }
                for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                    int villageTicks = -1;
                    for (Village village : world.field_72982_D.func_75540_b()) {
                        if (HOUSE_REP) {
                            if (!this.doorCountCache.containsKey(village)) {
                                this.doorCountCache.put(village, village.func_75567_c());
                            } else {
                                int difference = village.func_75567_c() - this.doorCountCache.get(village);
                                if (difference != 0) {
                                    this.doorCountCache.put(village, village.func_75567_c());
                                    double maxDistSq = (double)village.func_75568_b() + 32.0;
                                    maxDistSq *= maxDistSq;
                                    ChunkCoordinates coords = village.func_75577_a();
                                    ArrayList<EntityPlayer> nearbyPlayers = new ArrayList<EntityPlayer>();
                                    for (Object e : world.field_73010_i) {
                                        if (!(e instanceof EntityPlayer) || !(((EntityPlayer)e).func_70092_e((double)coords.field_71574_a, (double)coords.field_71572_b, (double)coords.field_71573_c) <= maxDistSq)) continue;
                                        nearbyPlayers.add((EntityPlayer)e);
                                    }
                                    for (EntityPlayer entityPlayer : nearbyPlayers) {
                                        village.func_82688_a(entityPlayer.func_70005_c_(), difference);
                                    }
                                }
                            }
                        }
                        if (!refreshDoors || !REFRESH_HOUSES) continue;
                        if (villageTicks < 0) {
                            NBTTagCompound tag = new NBTTagCompound();
                            village.func_82689_b(tag);
                            villageTicks = tag.func_74762_e("Tick");
                        }
                        if (village.func_75562_e() == 0) {
                            ChunkCoordinates coords = village.func_75577_a();
                            EntityPlayer nearestPlayer = world.func_72977_a((double)coords.field_71574_a, (double)coords.field_71572_b, (double)coords.field_71573_c, (double)village.func_75568_b() + 32.0);
                            if (nearestPlayer != null) continue;
                        }
                        for (VillageDoorInfo doorInfo : village.func_75558_f()) {
                            doorInfo.field_75475_f = villageTicks;
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDeath(LivingDeathEvent event) {
        Village village;
        if (HELP_REP_CHANCE > 0.0 && event.entityLiving instanceof IMob && event.source.func_76346_g() instanceof EntityPlayer && event.entityLiving.func_70681_au().nextDouble() < HELP_REP_CHANCE && (village = event.entityLiving.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)event.entityLiving.field_70165_t), MathHelper.func_76128_c((double)event.entityLiving.field_70163_u), MathHelper.func_76128_c((double)event.entityLiving.field_70161_v), 32)) != null) {
            village.func_82688_a(((EntityPlayer)event.source.func_76346_g()).func_70005_c_(), 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onBlockBreak(BlockEvent.HarvestDropsEvent event) {
        boolean trigger;
        if (event.harvester == null) {
            return;
        }
        if (BLOCK_WHITELIST.size() > 0 && !BLOCK_WHITELIST.contains(new TargetBlock(event.block, event.blockMetadata))) {
            return;
        }
        if (BLOCK_BLACKLIST.contains(new TargetBlock(event.block, event.blockMetadata))) {
            return;
        }
        Village village = event.world.field_72982_D.func_75550_a(event.x, event.y, event.z, 8);
        if (village == null) {
            return;
        }
        boolean special = SPECIAL_LIST.contains(new TargetBlock(event.block, event.blockMetadata));
        int playerRep = village.func_82684_a(event.harvester.func_70005_c_());
        if (playerRep <= BLOCK_REP_LIMIT) {
            if (special) {
                trigger = SPECIAL_REP_CHANCE > 0.0 && event.world.field_73012_v.nextDouble() < SPECIAL_REP_CHANCE;
            } else {
                boolean bl = trigger = BLOCK_REP_CHANCE > 0.0 && event.world.field_73012_v.nextDouble() < BLOCK_REP_CHANCE;
            }
            if (trigger) {
                village.func_82688_a(event.harvester.func_70005_c_(), -1);
                event.world.func_72926_e(2004, event.x, event.y, event.z, 0);
            }
        }
        if (playerRep <= BLOCK_DEFEND_LIMIT) {
            if (special) {
                trigger = SPECIAL_DEFEND_CHANCE > 0.0 && event.world.field_73012_v.nextDouble() < SPECIAL_DEFEND_CHANCE;
            } else {
                boolean bl = trigger = BLOCK_DEFEND_CHANCE > 0.0 && event.world.field_73012_v.nextDouble() < BLOCK_DEFEND_CHANCE;
            }
            if (trigger) {
                village.func_75575_a((EntityLivingBase)event.harvester);
            }
        }
    }
}

