/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.network.simpleimpl;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Constructor;
import net.minecraft.network.INetHandler;
import org.apache.logging.log4j.Level;

public class BetterSimpleChannelHandlerWrapper<REQ extends IMessage, REPLY extends IMessage>
extends SimpleChannelInboundHandler<REQ> {
    private IMessageHandler<REQ, REPLY> messageHandler;
    private Side side;
    protected static Constructor<MessageContext> messageContextConstructor = null;

    public BetterSimpleChannelHandlerWrapper(Class<? extends IMessageHandler<REQ, REPLY>> handler, Side side, Class<? extends REQ> messageType) {
        super(messageType);
        try {
            this.messageHandler = handler.newInstance();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        this.side = side;
    }

    protected MessageContext getMessageContext(INetHandler netHandler, Side side) {
        try {
            return messageContextConstructor.newInstance(netHandler, side);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, REQ msg) throws Exception {
        INetHandler iNetHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        MessageContext context = this.getMessageContext(iNetHandler, this.side);
        IMessage result = this.messageHandler.onMessage(msg, context);
        if (result != null) {
            ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.REPLY);
            ctx.writeAndFlush((Object)result).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log((Level)Level.ERROR, (Throwable)cause, (String)"SimpleChannelHandlerWrapper exception", (Object[])new Object[0]);
        super.exceptionCaught(ctx, cause);
    }

    static {
        try {
            messageContextConstructor = MessageContext.class.getDeclaredConstructor(INetHandler.class, Side.class);
            messageContextConstructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

