/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.builders.patterns.PatternFill;
import buildcraft.core.internal.ILEDProvider;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileFiller
extends TileAbstractBuilder
implements IHasWork,
IControllable,
ICommandReceiver,
IStatementContainer,
ILEDProvider {
    private static int POWER_ACTIVATION = 500;
    public FillerPattern currentPattern = PatternFill.INSTANCE;
    public IStatementParameter[] patternParameters;
    private BptBuilderTemplate currentTemplate;
    private final Box box = new Box();
    private boolean done = false;
    private boolean excavate = true;
    private SimpleInventory inv = new SimpleInventory(27, "Filler", 64);
    private NBTTagCompound initNBT = null;

    public TileFiller() {
        this.inv.addListener(this);
        this.box.kind = Box.Kind.STRIPES;
    }

    public boolean isExcavate() {
        return this.excavate;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IAreaProvider a = Utils.getNearbyAreaProvider(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (a != null) {
            this.box.initialize(a);
            a.removeFromWorld();
            this.sendNetworkUpdate();
        }
        if (this.currentTemplate == null) {
            this.initTemplate();
        }
        if (this.initNBT != null && this.currentTemplate != null) {
            this.currentTemplate.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), this);
        }
        this.initNBT = null;
    }

    private void initTemplate() {
        if (this.currentPattern != null && this.box.isInitialized() && this.box.sizeX() > 0 && this.box.sizeY() > 0 && this.box.sizeZ() > 0) {
            this.currentTemplate = this.currentPattern.getTemplateBuilder(this.box, this.func_145831_w(), this.patternParameters);
            this.currentTemplate.blueprint.excavate = this.excavate;
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.mode == IControllable.Mode.Off) {
            return;
        }
        if (!this.box.isInitialized()) {
            return;
        }
        if (this.getBattery().getEnergyStored() < POWER_ACTIVATION) {
            return;
        }
        boolean oldDone = this.done;
        if (this.done) {
            if (this.mode == IControllable.Mode.Loop) {
                this.done = false;
            } else {
                return;
            }
        }
        if (this.currentTemplate == null) {
            this.initTemplate();
        }
        if (this.currentTemplate != null) {
            this.currentTemplate.buildNextSlot(this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.currentTemplate.isDone(this)) {
                this.done = true;
                this.currentTemplate = null;
            }
        }
        if (oldDone != this.done) {
            this.sendNetworkUpdate();
        }
    }

    public final int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "Filler";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt);
        if (nbt.func_74764_b("pattern")) {
            this.currentPattern = (FillerPattern)FillerManager.registry.getPattern(nbt.func_74779_i("pattern"));
        }
        if (this.currentPattern == null) {
            this.currentPattern = PatternFill.INSTANCE;
        }
        if (nbt.func_74764_b("pp")) {
            this.readParametersFromNBT(nbt.func_74775_l("pp"));
        } else {
            this.initPatternParameters();
        }
        if (nbt.func_74764_b("box")) {
            this.box.initialize(nbt.func_74775_l("box"));
        }
        this.done = nbt.func_74767_n("done");
        this.excavate = nbt.func_74764_b("excavate") ? nbt.func_74767_n("excavate") : true;
        this.initNBT = (NBTTagCompound)nbt.func_74775_l("bpt").func_74737_b();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt);
        if (this.currentPattern != null) {
            nbt.func_74778_a("pattern", this.currentPattern.getUniqueTag());
        }
        NBTTagCompound boxStore = new NBTTagCompound();
        this.box.writeToNBT(boxStore);
        nbt.func_74782_a("box", (NBTBase)boxStore);
        nbt.func_74757_a("done", this.done);
        nbt.func_74757_a("excavate", this.excavate);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.currentTemplate != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.currentTemplate.saveBuildStateToNBT(builderCpt, this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        nbt.func_74782_a("bpt", (NBTBase)bptNBT);
        NBTTagCompound ppNBT = new NBTTagCompound();
        this.writeParametersToNBT(ppNBT);
        nbt.func_74782_a("pp", (NBTBase)ppNBT);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    private void initPatternParameters() {
        this.patternParameters = new IStatementParameter[this.currentPattern.maxParameters()];
        for (int i = 0; i < this.currentPattern.minParameters(); ++i) {
            this.patternParameters[i] = this.currentPattern.createParameter(i);
        }
    }

    public void setPattern(FillerPattern pattern) {
        if (pattern != null && this.currentPattern != pattern) {
            this.currentPattern = pattern;
            this.currentTemplate = null;
            this.done = false;
            this.initPatternParameters();
            this.sendNetworkUpdate();
        }
    }

    private void writeParametersToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("length", (byte)(this.patternParameters != null ? this.patternParameters.length : 0));
        if (this.patternParameters != null) {
            for (int i = 0; i < this.patternParameters.length; ++i) {
                if (this.patternParameters[i] == null) continue;
                NBTTagCompound patternData = new NBTTagCompound();
                patternData.func_74778_a("kind", this.patternParameters[i].getUniqueTag());
                this.patternParameters[i].writeToNBT(patternData);
                nbt.func_74782_a("p" + i, (NBTBase)patternData);
            }
        }
    }

    private void readParametersFromNBT(NBTTagCompound nbt) {
        this.patternParameters = new IStatementParameter[nbt.func_74771_c("length")];
        for (int i = 0; i < this.patternParameters.length; ++i) {
            if (!nbt.func_74764_b("p" + i)) continue;
            NBTTagCompound patternData = nbt.func_74775_l("p" + i);
            this.patternParameters[i] = StatementManager.createParameter(patternData.func_74779_i("kind"));
            this.patternParameters[i].readFromNBT(patternData);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        this.box.writeData(data);
        data.writeByte((this.done ? 1 : 0) | (this.excavate ? 2 : 0));
        NetworkUtils.writeUTF(data, this.currentPattern.getUniqueTag());
        NBTTagCompound parameterData = new NBTTagCompound();
        this.writeParametersToNBT(parameterData);
        NetworkUtils.writeNBT(data, parameterData);
    }

    @Override
    public void readData(ByteBuf data) {
        this.box.readData(data);
        short flags = data.readUnsignedByte();
        this.done = (flags & 1) > 0;
        this.excavate = (flags & 2) > 0;
        FillerPattern pattern = (FillerPattern)FillerManager.registry.getPattern(NetworkUtils.readUTF(data));
        NBTTagCompound parameterData = NetworkUtils.readNBT(data);
        this.readParametersFromNBT(parameterData);
        this.setPattern(pattern);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean hasWork() {
        return !this.done && this.mode != IControllable.Mode.Off;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void rpcSetPatternFromString(final String name) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setPattern", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeUTF(data, name);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        super.receiveCommand(command, side, sender, stream);
        if (side.isServer()) {
            if ("setPattern".equals(command)) {
                String name = NetworkUtils.readUTF(stream);
                this.setPattern((FillerPattern)FillerManager.registry.getPattern(name));
                this.done = false;
            } else if ("setParameters".equals(command)) {
                NBTTagCompound patternData = NetworkUtils.readNBT(stream);
                this.readParametersFromNBT(patternData);
                this.done = false;
            } else if ("setFlags".equals(command)) {
                this.excavate = stream.readBoolean();
                this.currentTemplate = null;
                this.sendNetworkUpdate();
                this.done = false;
            }
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.box).expand(50).getBoundingBox();
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return true;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.On || mode == IControllable.Mode.Off || mode == IControllable.Mode.Loop;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public void rpcSetParameter(int i, IStatementParameter patternParameter) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setParameters", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NBTTagCompound parameterData = new NBTTagCompound();
                TileFiller.this.writeParametersToNBT(parameterData);
                NetworkUtils.writeNBT(data, parameterData);
            }
        }));
    }

    public int getIconGlowLevel(int renderPass) {
        if (renderPass == 1) {
            return this.done ? 15 : 0;
        }
        if (renderPass == 2) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getLEDLevel(int led) {
        return (led == 0 ? this.done : this.buildersInAction.size() > 0) ? 15 : 0;
    }

    public void setExcavate(boolean excavate) {
        this.excavate = excavate;
    }
}

