/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.schematics;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SchematicDoor
extends SchematicBlock {
    final ItemStack stack;
    int upperMeta = 0;

    public SchematicDoor(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
        if ((this.meta & 8) == 0) {
            requirements.add(this.stack.func_77946_l());
        }
    }

    @Override
    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        this.meta = this.rotateMeta(this.meta);
    }

    private int rotateMeta(int meta) {
        int orientation = meta & 3;
        int others = meta - orientation;
        switch (orientation) {
            case 0: {
                return 1 + others;
            }
            case 1: {
                return 2 + others;
            }
            case 2: {
                return 3 + others;
            }
            case 3: {
                return 0 + others;
            }
        }
        return 0;
    }

    @Override
    public boolean doNotBuild() {
        return (this.meta & 8) != 0;
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        return this.block == context.world().func_147439_a(x, y, z);
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        context.world().func_147465_d(x, y, z, this.block, this.meta, 3);
        context.world().func_147465_d(x, y + 1, z, this.block, this.upperMeta, 3);
        context.world().func_72921_c(x, y + 1, z, this.upperMeta, 3);
        context.world().func_72921_c(x, y, z, this.meta, 3);
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        super.initializeFromObjectAt(context, x, y, z);
        if ((this.meta & 8) == 0) {
            this.upperMeta = context.world().func_72805_g(x, y + 1, z);
        }
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        nbt.func_74774_a("upperMeta", (byte)this.upperMeta);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        this.upperMeta = nbt.func_74771_c("upperMeta");
    }
}

