/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.core.lib.network.ChannelHandler;
import buildcraft.core.lib.utils.Utils;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.Packet;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public final class ThreadSafeUtils {
    private static final ThreadLocal<Chunk> lastChunk = new ThreadLocal();

    private ThreadSafeUtils() {
    }

    public static Chunk getChunk(World world, int x, int z) {
        Chunk chunk = lastChunk.get();
        if (chunk != null) {
            if (chunk.field_76636_d) {
                if (chunk.field_76637_e == world && chunk.field_76635_g == x && chunk.field_76647_h == z) {
                    return chunk;
                }
            } else {
                lastChunk.set(null);
            }
        }
        IChunkProvider provider = world.func_72863_F();
        if (!Utils.CAULDRON_DETECTED && provider instanceof ChunkProviderServer) {
            chunk = (Chunk)((ChunkProviderServer)provider).field_73244_f.func_76164_a(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
        } else {
            Chunk chunk2 = chunk = provider.func_73149_a(x, z) ? provider.func_73154_d(x, z) : null;
        }
        if (chunk != null) {
            lastChunk.set(chunk);
        }
        return chunk;
    }

    public static Packet generatePacketFrom(buildcraft.core.lib.network.Packet packet, FMLEmbeddedChannel channel) {
        ByteBuf data = Unpooled.buffer();
        for (io.netty.channel.ChannelHandler h : channel.pipeline().toMap().values()) {
            if (!(h instanceof ChannelHandler)) continue;
            data.writeByte((int)((ChannelHandler)h).getDiscriminator(packet.getClass()));
            break;
        }
        packet.writeData(data);
        return new FMLProxyPacket(data, (String)channel.attr(NetworkRegistry.FML_CHANNEL).get());
    }
}

