/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.StackRequest;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.statements.StatementSlot;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.robotics.IStationFilter;
import buildcraft.robotics.ai.AIRobotSearchStation;
import buildcraft.robotics.statements.ActionRobotFilter;
import buildcraft.robotics.statements.ActionStationRequestItems;
import buildcraft.robotics.statements.ActionStationRequestItemsMachine;
import java.util.Collection;
import net.minecraft.item.ItemStack;

public class AIRobotSearchStackRequest
extends AIRobot {
    public StackRequest request = null;
    private Collection<ItemStack> blackList;
    private IStackFilter filter;

    public AIRobotSearchStackRequest(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchStackRequest(EntityRobotBase iRobot, IStackFilter iFilter, Collection<ItemStack> iBlackList) {
        this(iRobot);
        this.blackList = iBlackList;
        this.filter = iFilter;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotSearchStation(this.robot, new StationProviderFilter(), this.robot.getZoneToWork()));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchStation) {
            if (!ai.success()) {
                this.terminate();
            } else {
                this.request = this.getOrderFromRequestingAction(((AIRobotSearchStation)ai).targetStation);
                if (this.request == null) {
                    this.request = this.getOrderFromRequestingStation(((AIRobotSearchStation)ai).targetStation, true);
                }
                this.terminate();
            }
        }
    }

    @Override
    public boolean success() {
        return this.request != null;
    }

    private boolean isBlacklisted(ItemStack stack) {
        for (ItemStack black : this.blackList) {
            if (!StackHelper.isMatchingItem(stack, black)) continue;
            return true;
        }
        return false;
    }

    private StackRequest getOrderFromRequestingStation(DockingStation station, boolean take) {
        if (!ActionRobotFilter.canInteractWithItem(station, this.filter, ActionStationRequestItemsMachine.class)) {
            return null;
        }
        IRequestProvider provider = station.getRequestProvider();
        if (provider == null) {
            return null;
        }
        for (int i = 0; i < provider.getNumberOfRequests(); ++i) {
            StackRequest requestFound = provider.getAvailableRequest(i);
            if (requestFound == null || this.isBlacklisted(requestFound.stack) || !this.filter.matches(requestFound.stack)) continue;
            requestFound.station = station;
            if (take) {
                if (!provider.takeRequest(i, this.robot)) continue;
                return requestFound;
            }
            return requestFound;
        }
        return null;
    }

    private StackRequest getOrderFromRequestingAction(DockingStation station) {
        for (StatementSlot s : station.getActiveActions()) {
            if (!(s.statement instanceof ActionStationRequestItems)) continue;
            for (IStatementParameter p : s.parameters) {
                StatementParameterItemStack param = (StatementParameterItemStack)p;
                if (param == null || this.isBlacklisted(param.getItemStack())) continue;
                StackRequest req = new StackRequest();
                req.station = station;
                req.stack = param.getItemStack();
                return req;
            }
        }
        return null;
    }

    private class StationProviderFilter
    implements IStationFilter {
        private StationProviderFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            return AIRobotSearchStackRequest.this.getOrderFromRequestingAction(station) != null || AIRobotSearchStackRequest.this.getOrderFromRequestingStation(station, false) != null;
        }
    }
}

