/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.FakeBlock;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class LensPluggable
extends PipePluggable {
    public int color;
    public boolean isFilter;
    protected IPipeTile container;
    private ForgeDirection side;

    public LensPluggable() {
    }

    public LensPluggable(ItemStack stack) {
        this.color = stack.func_77960_j() & 0xF;
        this.isFilter = stack.func_77960_j() >= 16;
    }

    @Override
    public void validate(IPipeTile pipe, ForgeDirection direction) {
        this.container = pipe;
        this.side = direction;
    }

    @Override
    public void invalidate() {
        this.container = null;
        this.side = ForgeDirection.UNKNOWN;
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack(BuildCraftTransport.lensItem, 1, this.color | (this.isFilter ? 16 : 0))};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.1875f;
        bounds[0][1] = 0.8125f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.125f;
        bounds[2][0] = 0.1875f;
        bounds[2][1] = 0.8125f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    public IPipePluggableRenderer getRenderer() {
        return LensPluggableRenderer.INSTANCE;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.color = tag.func_74771_c("c");
        this.isFilter = tag.func_74767_n("f");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("c", (byte)this.color);
        tag.func_74757_a("f", this.isFilter);
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.color | (this.isFilter ? 32 : 0));
    }

    @Override
    public void readData(ByteBuf data) {
        short flags = data.readUnsignedByte();
        this.color = flags & 0xF;
        this.isFilter = (flags & 0x20) > 0;
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        LensPluggable other = (LensPluggable)o;
        return other.color != this.color || other.isFilter != this.isFilter;
    }

    private void color(TravelingItem item) {
        if (item.toCenter && item.input.getOpposite() == this.side || !item.toCenter && item.output == this.side) {
            item.color = EnumColor.fromId(this.color);
        }
    }

    public void eventHandler(PipeEventItem.ReachedEnd event) {
        if (!this.isFilter) {
            this.color(event.item);
        }
    }

    public void eventHandler(PipeEventItem.Entered event) {
        if (!this.isFilter) {
            this.color(event.item);
        }
    }

    private static final class LensPluggableRenderer
    implements IPipePluggableRenderer {
        public static final IPipePluggableRenderer INSTANCE = new LensPluggableRenderer();
        private static final float zFightOffset = 2.4414062E-4f;

        private LensPluggableRenderer() {
        }

        @Override
        public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
            float[][] zeroState = new float[3][2];
            zeroState[0][0] = 0.1875f;
            zeroState[0][1] = 0.8125f;
            zeroState[1][0] = 0.0f;
            zeroState[1][1] = 0.125f;
            zeroState[2][0] = 0.1875f;
            zeroState[2][1] = 0.8125f;
            if (renderPass == 1) {
                blockStateMachine.setRenderMask(1 << side.ordinal() | 1 << (side.ordinal() ^ 1));
                for (int i = 0; i < 3; ++i) {
                    float[] fArray = zeroState[i];
                    fArray[0] = fArray[0] + 2.4414062E-4f;
                    float[] fArray2 = zeroState[i];
                    fArray2[1] = fArray2[1] - 2.4414062E-4f;
                }
                blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeLensOverlay.ordinal()));
                ((FakeBlock)blockStateMachine).setColor(ColorUtils.getRGBColor(15 - ((LensPluggable)pipePluggable).color));
                blockStateMachine.setRenderAllSides();
            } else if (((LensPluggable)pipePluggable).isFilter) {
                blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeFilter.ordinal()));
            } else {
                blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeLens.ordinal()));
            }
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
            ((FakeBlock)blockStateMachine).setColor(0xFFFFFF);
        }
    }
}

