/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import ivorius.ivtoolkit.network.PacketExtendedEntityPropertiesData;
import ivorius.ivtoolkit.network.PacketExtendedEntityPropertiesDataHandler;
import ivorius.ivtoolkit.network.PacketGuiAction;
import ivorius.ivtoolkit.network.PacketGuiActionHandler;
import ivorius.reccomplex.RCCommunicationHandler;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RCProxy;
import ivorius.reccomplex.RCRegistryHandler;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.events.RCFMLEventHandler;
import ivorius.reccomplex.events.RCForgeEventHandler;
import ivorius.reccomplex.gui.RCGuiHandler;
import ivorius.reccomplex.network.PacketEditInventoryGenerator;
import ivorius.reccomplex.network.PacketEditInventoryGeneratorHandler;
import ivorius.reccomplex.network.PacketEditStructure;
import ivorius.reccomplex.network.PacketEditStructureHandler;
import ivorius.reccomplex.network.PacketEditTileEntity;
import ivorius.reccomplex.network.PacketEditTileEntityHandler;
import ivorius.reccomplex.network.PacketItemEvent;
import ivorius.reccomplex.network.PacketItemEventHandler;
import ivorius.reccomplex.network.PacketSyncItem;
import ivorius.reccomplex.network.PacketSyncItemHandler;
import ivorius.reccomplex.structures.generic.StructureSaveHandler;
import ivorius.reccomplex.worldgen.inventory.ItemCollectionSaveHandler;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

@Mod(modid="reccomplex", version="0.9.6.3", name="Recurrent Complex", guiFactory="ivorius.reccomplex.gui.RCConfigGuiFactory", dependencies="required-after:ivtoolkit")
public class RecurrentComplex {
    public static final String NAME = "Recurrent Complex";
    public static final String MODID = "reccomplex";
    public static final String VERSION = "0.9.6.3";
    public static final boolean USE_JSON_FOR_NBT = true;
    public static final boolean USE_ZIP_FOR_STRUCTURE_FILES = true;
    @Mod.Instance(value="reccomplex")
    public static RecurrentComplex instance;
    @SidedProxy(clientSide="ivorius.reccomplex.client.ClientProxy", serverSide="ivorius.reccomplex.server.ServerProxy")
    public static RCProxy proxy;
    public static String filePathTexturesFull;
    public static String filePathTextures;
    public static String textureBase;
    public static Logger logger;
    public static Configuration config;
    public static RCForgeEventHandler forgeEventHandler;
    public static RCFMLEventHandler fmlEventHandler;
    public static SimpleNetworkWrapper network;
    public static RCGuiHandler guiHandler;
    public static RCCommunicationHandler communicationHandler;

    public static boolean isLite() {
        return RCConfig.isLightweightMode();
    }

    @NetworkCheckHandler
    public boolean checkNetwork(Map<String, String> mods, Side side) {
        return RecurrentComplex.isLite() || mods.containsKey(MODID);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        RCConfig.loadConfig(null);
        config.save();
        forgeEventHandler = new RCForgeEventHandler();
        forgeEventHandler.register();
        fmlEventHandler = new RCFMLEventHandler();
        fmlEventHandler.register();
        guiHandler = new RCGuiHandler();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
        communicationHandler = new RCCommunicationHandler(logger, MODID, instance);
        RCRegistryHandler.preInit(event, this);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        network.registerMessage(PacketExtendedEntityPropertiesDataHandler.class, PacketExtendedEntityPropertiesData.class, 0, Side.CLIENT);
        network.registerMessage(PacketGuiActionHandler.class, PacketGuiAction.class, 1, Side.SERVER);
        network.registerMessage(PacketEditInventoryGeneratorHandler.class, PacketEditInventoryGenerator.class, 2, Side.CLIENT);
        network.registerMessage(PacketEditInventoryGeneratorHandler.class, PacketEditInventoryGenerator.class, 3, Side.SERVER);
        network.registerMessage(PacketEditTileEntityHandler.class, PacketEditTileEntity.class, 4, Side.CLIENT);
        network.registerMessage(PacketEditTileEntityHandler.class, PacketEditTileEntity.class, 5, Side.SERVER);
        network.registerMessage(PacketEditStructureHandler.class, PacketEditStructure.class, 6, Side.CLIENT);
        network.registerMessage(PacketEditStructureHandler.class, PacketEditStructure.class, 7, Side.SERVER);
        network.registerMessage(PacketSyncItemHandler.class, PacketSyncItem.class, 8, Side.CLIENT);
        network.registerMessage(PacketSyncItemHandler.class, PacketSyncItem.class, 9, Side.SERVER);
        network.registerMessage(PacketItemEventHandler.class, PacketItemEvent.class, 10, Side.CLIENT);
        network.registerMessage(PacketItemEventHandler.class, PacketItemEvent.class, 11, Side.SERVER);
        RCRegistryHandler.load(event, this);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.loadAllModData();
        ItemCollectionSaveHandler.reloadAllCustomInventoryGenerators();
        StructureSaveHandler.reloadAllCustomStructures();
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        RCCommands.onServerStart(event);
    }

    public void loadAllModData() {
        for (String modid : Loader.instance().getIndexedModList().keySet()) {
            ItemCollectionSaveHandler.loadInventoryGeneratorsFromMod(modid);
            StructureSaveHandler.loadStructuresFromMod(modid);
        }
    }

    static {
        filePathTexturesFull = "reccomplex:textures/mod/";
        filePathTextures = "textures/mod/";
        textureBase = "reccomplex:";
    }
}

