/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.blocks;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazeComponentConnector;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MazeRoomConnection;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.SetMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.Visitor;
import ivorius.reccomplex.blocks.GeneratingTileEntity;
import ivorius.reccomplex.blocks.TileEntityWithGUI;
import ivorius.reccomplex.gui.editmazeblock.GuiEditMazeBlock;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.Selection;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.ConnectorFactory;
import ivorius.reccomplex.structures.generic.maze.ConnectorStrategy;
import ivorius.reccomplex.structures.generic.maze.LimitAABBStrategy;
import ivorius.reccomplex.structures.generic.maze.MazeComponentStructure;
import ivorius.reccomplex.structures.generic.maze.PlacedStructure;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import ivorius.reccomplex.structures.generic.maze.SavedMazePaths;
import ivorius.reccomplex.structures.generic.maze.WorldGenMaze;
import ivorius.reccomplex.utils.IntAreas;
import ivorius.reccomplex.utils.NBTStorable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;

public class TileEntityMazeGenerator
extends TileEntity
implements GeneratingTileEntity<InstanceData>,
TileEntityWithGUI {
    public String mazeID = "";
    public List<SavedMazePath> mazeExits = new ArrayList<SavedMazePath>();
    public Selection mazeRooms = Selection.zeroSelection(3);
    public BlockCoord structureShift = new BlockCoord(0, 0, 0);
    public int[] roomSize = new int[]{3, 5, 3};

    public String getMazeID() {
        return this.mazeID;
    }

    public void setMazeID(String mazeID) {
        this.mazeID = mazeID;
    }

    public BlockCoord getStructureShift() {
        return this.structureShift;
    }

    public void setStructureShift(BlockCoord structureShift) {
        this.structureShift = structureShift;
    }

    public int[] getRoomSize() {
        return (int[])this.roomSize.clone();
    }

    public void setRoomSize(int[] roomSize) {
        this.roomSize = roomSize;
    }

    public Selection getMazeRooms() {
        return this.mazeRooms;
    }

    public void setMazeRooms(Selection mazeRooms) {
        this.mazeRooms = mazeRooms;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readSyncedNBT(nbtTagCompound);
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeSyncedNBT(nbtTagCompound);
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context) {
        InstanceData instanceData = new InstanceData();
        instanceData.placedStructures.addAll(WorldGenMaze.convertToPlacedStructures(context.random, this.getCoordinate(), this.structureShift, this.getPlacedRooms(context.random, context.transform), this.roomSize, context.transform));
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    @Override
    public void generate(StructureSpawnContext context, InstanceData instanceData) {
        List<PlacedStructure> placedStructures = instanceData.placedStructures;
        if (placedStructures == null) {
            return;
        }
        WorldGenMaze.generatePlacedStructures(placedStructures, context);
    }

    protected BlockCoord getCoordinate() {
        return new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean shouldPlaceInWorld(StructureSpawnContext context, InstanceData instanceData) {
        return false;
    }

    public List<ShiftedMazeComponent<MazeComponentStructure<Connector>, Connector>> getPlacedRooms(Random random, AxisAlignedTransform2D transform) {
        if (this.mazeRooms.isEmpty()) {
            return null;
        }
        ConnectorFactory factory = new ConnectorFactory();
        Connector roomConnector = factory.get("Path");
        Connector wallConnector = factory.get("Wall");
        int[] boundsHigher = this.mazeRooms.boundsHigher();
        int[] boundsLower = this.mazeRooms.boundsLower();
        int[] oneArray = new int[boundsHigher.length];
        Arrays.fill(oneArray, 1);
        int[] outsideBoundsHigher = IvVecMathHelper.add((int[][])new int[][]{boundsHigher, oneArray});
        int[] outsideBoundsLower = IvVecMathHelper.sub((int[])boundsLower, (int[][])new int[][]{oneArray});
        List<MazeComponentStructure<Connector>> transformedComponents = WorldGenMaze.transformedComponents(StructureRegistry.getStructuresInMaze(this.mazeID), factory, transform);
        SetMazeComponent maze = new SetMazeComponent();
        TileEntityMazeGenerator.enclose(maze, new MazeRoom(outsideBoundsLower), new MazeRoom(outsideBoundsHigher), wallConnector);
        TileEntityMazeGenerator.blockRooms(maze, this.mazeRooms.mazeRooms(false), wallConnector);
        TileEntityMazeGenerator.addExits(factory, (MorphingMazeComponent<Connector>)maze, this.mazeExits);
        TileEntityMazeGenerator.addRandomPaths(random, outsideBoundsHigher, maze, transformedComponents, roomConnector, outsideBoundsHigher[0] * outsideBoundsHigher[1] * outsideBoundsHigher[2] / 125 + 1);
        LimitAABBStrategy placementStrategy = new LimitAABBStrategy(outsideBoundsHigher, Collections.singleton(wallConnector));
        ConnectorStrategy connectionStrategy = new ConnectorStrategy();
        return MazeComponentConnector.randomlyConnect((MorphingMazeComponent)maze, transformedComponents, (ConnectionStrategy)connectionStrategy, placementStrategy, (Random)random);
    }

    protected static <C> void addRandomPaths(Random random, int[] size, MorphingMazeComponent<C> maze, List<? extends MazeComponent<C>> components, C roomConnector, int number) {
        HashMap exits = new HashMap();
        for (MazeComponent<C> component : components) {
            for (Map.Entry entry : component.exits().entrySet()) {
                exits.put(entry.getKey(), entry.getValue());
            }
        }
        for (int i = 0; i < number; ++i) {
            int[] randomCoords = new int[size.length];
            for (int c = 0; c < randomCoords.length; ++c) {
                randomCoords[c] = MathHelper.func_76136_a((Random)random, (int)0, (int)size[c]);
            }
            MazeRoom randomRoom = new MazeRoom(randomCoords);
            MazeRoomConnection randomConnection = new MazeRoomConnection(randomRoom, randomRoom.addInDimension(random.nextInt(size.length), random.nextBoolean() ? 1 : -1));
            if (!Objects.equals(exits.get(randomConnection), roomConnector)) continue;
            maze.exits().put(randomConnection, roomConnector);
        }
    }

    protected static void addExits(ConnectorFactory factory, MorphingMazeComponent<Connector> maze, List<SavedMazePath> mazeExits) {
        HashMap exitMap = Maps.newHashMap();
        SavedMazePaths.putAll(exitMap, Iterables.transform(mazeExits, SavedMazePaths.toConnectionFunction(factory)));
        maze.exits().putAll(exitMap);
    }

    public static <C> void blockRooms(MorphingMazeComponent<C> component, Set<MazeRoom> rooms, C wallConnector) {
        component.add(WorldGenMaze.createCompleteComponent(rooms, Collections.emptyMap(), wallConnector));
    }

    public static <C> void enclose(MorphingMazeComponent<C> component, MazeRoom lower, MazeRoom higher, C wallConnector) {
        if (lower.getDimensions() != higher.getDimensions()) {
            throw new IllegalArgumentException();
        }
        final HashSet<MazeRoom> rooms = new HashSet<MazeRoom>();
        int[] coords = lower.getCoordinates();
        int i = 0;
        while (i < coords.length) {
            final int lowest = lower.getCoordinate(i);
            final int highest = higher.getCoordinate(i);
            final int finalI = i;
            IntAreas.visitCoordsExcept(lower.getCoordinates(), higher.getCoordinates(), (TIntList)TIntArrayList.wrap((int[])new int[]{i++}), new Visitor<int[]>(){

                public boolean visit(int[] ints) {
                    ints[finalI] = lowest;
                    rooms.add(new MazeRoom(ints));
                    ints[finalI] = highest;
                    rooms.add(new MazeRoom(ints));
                    return true;
                }
            });
        }
        TileEntityMazeGenerator.blockRooms(component, rooms, wallConnector);
    }

    @Override
    public void writeSyncedNBT(NBTTagCompound compound) {
        compound.func_74778_a("mazeID", this.mazeID);
        NBTTagCompound rooms = new NBTTagCompound();
        this.mazeRooms.writeToNBT(rooms);
        compound.func_74782_a("rooms", (NBTBase)rooms);
        NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"mazeExits", this.mazeExits);
        BlockCoord.writeCoordToNBT((String)"structureShift", (BlockCoord)this.structureShift, (NBTTagCompound)compound);
        compound.func_74783_a("roomSize", this.roomSize);
    }

    @Override
    public void readSyncedNBT(NBTTagCompound compound) {
        this.mazeID = compound.func_74779_i("mazeID");
        NBTTagCompound rooms = compound.func_74775_l("rooms");
        this.mazeRooms.readFromNBT(rooms, 3);
        if (compound.func_150297_b("roomNumbers", 11)) {
            this.mazeRooms.add(new Selection.Area(true, new int[]{0, 0, 0}, IvVecMathHelper.sub((int[])IvNBTHelper.readIntArrayFixedSize((String)"roomNumbers", (int)3, (NBTTagCompound)compound), (int[][])new int[][]{{1, 1, 1}})));
        }
        if (compound.func_150297_b("blockedRoomAreas", 9)) {
            NBTTagList blockedRoomsList = compound.func_150295_c("blockedRoomAreas", 10);
            for (int i = 0; i < blockedRoomsList.func_74745_c(); ++i) {
                NBTTagCompound blockedRoomTag = blockedRoomsList.func_150305_b(i);
                this.mazeRooms.add(new Selection.Area(false, IvNBTHelper.readIntArrayFixedSize((String)"min", (int)3, (NBTTagCompound)blockedRoomTag), IvNBTHelper.readIntArrayFixedSize((String)"max", (int)3, (NBTTagCompound)blockedRoomTag)));
            }
        }
        this.mazeExits.clear();
        this.mazeExits.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"mazeExits", SavedMazePath.class));
        this.structureShift = BlockCoord.readCoordFromNBT((String)"structureShift", (NBTTagCompound)compound);
        this.roomSize = IvNBTHelper.readIntArrayFixedSize((String)"roomSize", (int)3, (NBTTagCompound)compound);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openEditGUI() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiEditMazeBlock(this));
    }

    public static class InstanceData
    implements NBTStorable {
        public final List<PlacedStructure> placedStructures = new ArrayList<PlacedStructure>();

        public InstanceData() {
        }

        public InstanceData(NBTTagCompound compound) {
            this.placedStructures.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"placedStructures", PlacedStructure.class));
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"placedStructures", this.placedStructures);
            return compound;
        }
    }
}

