/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.dimensions;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.WorldProvider;

public class DimensionDictionary {
    public static final String UNCATEGORIZED = "UNCATEGORIZED";
    public static final String MC_DEFAULT = "MC_DEFAULT";
    public static final String REAL = "REAL";
    public static final String UNREAL = "UNREAL";
    public static final String IMAGINARY = "IMAGINARY";
    public static final String SIMULATED = "SIMULATED";
    public static final String ABSTRACT = "ABSTRACT";
    public static final String TOP_LIMIT = "TOP_LIMIT";
    public static final String NO_TOP_LIMIT = "NO_TOP_LIMIT";
    public static final String BOTTOM_LIMIT = "BOTTOM_LIMIT";
    public static final String NO_BOTTOM_LIMIT = "NO_BOTTOM_LIMIT";
    public static final String FINITE = "FINITE";
    public static final String INFINITE = "INFINITE";
    public static final String PLANET_SURFACE = "PLANET_SURFACE";
    public static final String EARTH = "EARTH";
    public static final String HELL = "HELL";
    public static final String ENDER = "ENDER";
    public static final String BOSS_ARENA = "BOSS_ARENA";
    private static final TIntObjectMap<Set<String>> dimensionTypes = new TIntObjectHashMap();
    private static final Map<String, Type> types = new HashMap<String, Type>();
    private static final Set<String> SET_UNCATEGORIZED = Collections.singleton("UNCATEGORIZED");

    public static void registerDimensionTypes(int dimensionID, Collection<String> types) {
        HashSet<String> dTypes = (HashSet<String>)dimensionTypes.get(dimensionID);
        if (dTypes == null) {
            dTypes = new HashSet<String>();
            dimensionTypes.put(dimensionID, dTypes);
        }
        dTypes.addAll(types);
        for (String type : types) {
            DimensionDictionary.registerType(type);
        }
    }

    public static void unregisterDimensionTypes(int dimensionID, Collection<String> types) {
        Set dTypes = (Set)dimensionTypes.get(dimensionID);
        if (dTypes != null) {
            if (types == null) {
                dTypes.clear();
            } else {
                dTypes.removeAll(types);
            }
        }
    }

    public static void registerType(String type) {
        if (!types.containsKey(type)) {
            types.put(type, new Type());
        }
    }

    public static void registerTypes(Collection<String> types) {
        for (String type : types) {
            DimensionDictionary.registerType(type);
        }
    }

    public static void registerSubtypes(String type, Collection<String> subtypes) {
        DimensionDictionary.registerGetType((String)type).subtypes.addAll(subtypes);
        for (String sub : subtypes) {
            DimensionDictionary.registerGetType((String)sub).supertypes.add(type);
        }
    }

    public static void registerSupertypes(String type, Collection<String> supertypes) {
        DimensionDictionary.registerGetType((String)type).supertypes.addAll(supertypes);
        for (String supertype : supertypes) {
            DimensionDictionary.registerGetType((String)supertype).subtypes.add(type);
        }
    }

    public static Set<String> getDimensionTypes(WorldProvider provider) {
        if (provider instanceof Handler) {
            return ((Handler)provider).getDimensionTypes();
        }
        Set types = (Set)dimensionTypes.get(provider.field_76574_g);
        return types != null ? Collections.unmodifiableSet(types) : SET_UNCATEGORIZED;
    }

    public static boolean dimensionMatchesAllTypes(WorldProvider provider, Collection<String> types) {
        for (String type : types) {
            if (DimensionDictionary.dimensionMatchesType(provider, type)) continue;
            return false;
        }
        return true;
    }

    public static boolean dimensionMatchesType(WorldProvider provider, String type) {
        Set<String> dimTypes = DimensionDictionary.getDimensionTypes(provider);
        ArrayDeque<String> curTypes = new ArrayDeque<String>();
        do {
            if (dimTypes.contains(type)) {
                return true;
            }
            Type curT = types.get(type);
            if (curT == null) continue;
            curTypes.addAll(curT.subtypes);
        } while ((type = (String)curTypes.poll()) != null);
        return false;
    }

    public static Set<String> getSupertypes(String type) {
        Type t = types.get(type);
        return t == null ? Collections.emptySet() : Collections.unmodifiableSet(t.supertypes);
    }

    public static Set<String> getSubtypes(String type) {
        Type t = types.get(type);
        return t == null ? Collections.emptySet() : Collections.unmodifiableSet(t.subtypes);
    }

    public static Set<String> allRegisteredTypes() {
        return Collections.unmodifiableSet(types.keySet());
    }

    private static Type registerGetType(String type) {
        DimensionDictionary.registerType(type);
        return types.get(type);
    }

    static {
        DimensionDictionary.registerType(UNCATEGORIZED);
        DimensionDictionary.registerSubtypes(UNREAL, Arrays.asList(IMAGINARY, SIMULATED, ABSTRACT));
        DimensionDictionary.registerDimensionTypes(0, Arrays.asList(MC_DEFAULT, REAL, INFINITE, NO_TOP_LIMIT, BOTTOM_LIMIT, PLANET_SURFACE, EARTH));
        DimensionDictionary.registerDimensionTypes(-1, Arrays.asList(MC_DEFAULT, REAL, INFINITE, TOP_LIMIT, BOTTOM_LIMIT, HELL));
        DimensionDictionary.registerDimensionTypes(1, Arrays.asList(MC_DEFAULT, REAL, FINITE, NO_TOP_LIMIT, NO_BOTTOM_LIMIT, BOSS_ARENA, ENDER));
    }

    private static class Type {
        public final Set<String> supertypes = new HashSet<String>();
        public final Set<String> subtypes = new HashSet<String>();

        private Type() {
        }
    }

    public static interface Handler {
        public Set<String> getDimensionTypes();
    }
}

