/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.entities;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.operation.OperationRegistry;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class StructureEntityInfo
implements IExtendedEntityProperties,
PartialUpdateHandler {
    public static final String EEP_KEY = "structureEntityInfo";
    public static final String EEP_CMP_KEY = "rc-structureEntityInfo";
    public BlockCoord selectedPoint1;
    public BlockCoord selectedPoint2;
    private Operation.PreviewType previewType = Operation.PreviewType.SHAPE;
    public Operation danglingOperation;
    public boolean showGrid = false;
    private boolean hasChanges;
    private NBTTagCompound cachedExportStructureBlockDataNBT;
    private NBTTagCompound worldDataClipboard;

    @Nullable
    public static StructureEntityInfo getStructureEntityInfo(Entity entity) {
        return (StructureEntityInfo)entity.getExtendedProperties(EEP_KEY);
    }

    public static void initInEntity(Entity entity) {
        entity.registerExtendedProperties(EEP_KEY, (IExtendedEntityProperties)new StructureEntityInfo());
    }

    public boolean hasValidSelection() {
        return this.selectedPoint1 != null && this.selectedPoint2 != null;
    }

    public void setSelection(BlockArea area) {
        if (area != null) {
            this.selectedPoint1 = area.getPoint1();
            this.selectedPoint2 = area.getPoint2();
        } else {
            this.selectedPoint1 = null;
            this.selectedPoint2 = null;
        }
    }

    public Operation.PreviewType getPreviewType() {
        return RecurrentComplex.isLite() ? Operation.PreviewType.NONE : this.previewType;
    }

    public void setPreviewType(Operation.PreviewType previewType) {
        this.previewType = previewType;
    }

    public void sendSelectionToClients(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !RecurrentComplex.isLite()) {
            IvNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, (String)EEP_KEY, (String)"selection", (SimpleNetworkWrapper)RecurrentComplex.network, (Object[])new Object[0]);
        }
    }

    public void sendPreviewTypeToClients(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !RecurrentComplex.isLite()) {
            IvNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, (String)EEP_KEY, (String)"previewType", (SimpleNetworkWrapper)RecurrentComplex.network, (Object[])new Object[0]);
        }
    }

    public void sendOperationToClients(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !RecurrentComplex.isLite()) {
            IvNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, (String)EEP_KEY, (String)"operation", (SimpleNetworkWrapper)RecurrentComplex.network, (Object[])new Object[0]);
        }
    }

    public void sendOptionsToClients(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !RecurrentComplex.isLite()) {
            IvNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, (String)EEP_KEY, (String)"options", (SimpleNetworkWrapper)RecurrentComplex.network, (Object[])new Object[0]);
        }
    }

    public NBTTagCompound getCachedExportStructureBlockDataNBT() {
        return this.cachedExportStructureBlockDataNBT;
    }

    public void setCachedExportStructureBlockDataNBT(NBTTagCompound cachedExportStructureBlockDataNBT) {
        this.cachedExportStructureBlockDataNBT = cachedExportStructureBlockDataNBT;
    }

    public NBTTagCompound getWorldDataClipboard() {
        return this.worldDataClipboard;
    }

    public void setWorldDataClipboard(NBTTagCompound worldDataClipboard) {
        this.worldDataClipboard = worldDataClipboard;
    }

    public void queueOperation(Operation operation, Entity owner) {
        this.danglingOperation = operation;
        this.sendOperationToClients(owner);
    }

    public boolean performOperation(World world, Entity owner) {
        if (this.danglingOperation != null) {
            this.danglingOperation.perform(world);
            this.danglingOperation = null;
            this.sendOperationToClients(owner);
            return true;
        }
        return false;
    }

    public boolean cancelOperation(World world, Entity owner) {
        if (this.danglingOperation != null) {
            this.danglingOperation = null;
            this.sendOperationToClients(owner);
            return true;
        }
        return false;
    }

    public void saveNBTData(NBTTagCompound parent) {
        NBTTagCompound compound = new NBTTagCompound();
        BlockCoord.writeCoordToNBT((String)"selectedPoint1", (BlockCoord)this.selectedPoint1, (NBTTagCompound)compound);
        BlockCoord.writeCoordToNBT((String)"selectedPoint2", (BlockCoord)this.selectedPoint2, (NBTTagCompound)compound);
        compound.func_74778_a("previewType", this.previewType.key);
        if (RCConfig.savePlayerCache) {
            if (this.danglingOperation != null) {
                compound.func_74782_a("danglingOperation", (NBTBase)OperationRegistry.writeOperation(this.danglingOperation));
            }
            if (this.worldDataClipboard != null) {
                compound.func_74782_a("worldDataClipboard", (NBTBase)this.worldDataClipboard);
            }
        }
        compound.func_74757_a("showGrid", this.showGrid);
        parent.func_74782_a(EEP_CMP_KEY, (NBTBase)compound);
    }

    public void loadNBTData(NBTTagCompound parent) {
        NBTTagCompound compound = parent.func_74764_b(EEP_CMP_KEY) ? parent.func_74775_l(EEP_CMP_KEY) : parent;
        this.selectedPoint1 = BlockCoord.readCoordFromNBT((String)"selectedPoint1", (NBTTagCompound)compound);
        this.selectedPoint2 = BlockCoord.readCoordFromNBT((String)"selectedPoint2", (NBTTagCompound)compound);
        this.previewType = Operation.PreviewType.findOrDefault(compound.func_74779_i("previewType"), Operation.PreviewType.SHAPE);
        if (RCConfig.savePlayerCache) {
            if (compound.func_150297_b("danglingOperation", 10)) {
                this.danglingOperation = OperationRegistry.readOperation(compound.func_74775_l("danglingOperation"));
            }
            if (compound.func_150297_b("worldDataClipboard", 10)) {
                this.worldDataClipboard = compound.func_74775_l("worldDataClipboard");
            }
        }
        this.showGrid = compound.func_74767_n("showGrid");
        this.hasChanges = true;
    }

    public void init(Entity entity, World world) {
    }

    public void update(Entity entity) {
        if (this.hasChanges) {
            this.hasChanges = false;
            this.sendSelectionToClients(entity);
            this.sendPreviewTypeToClients(entity);
            this.sendOperationToClients(entity);
            this.sendOptionsToClients(entity);
        }
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("selection".equals(context)) {
            BlockCoord.writeCoordToBuffer((BlockCoord)this.selectedPoint1, (ByteBuf)buffer);
            BlockCoord.writeCoordToBuffer((BlockCoord)this.selectedPoint2, (ByteBuf)buffer);
        } else if ("previewType".equals(context)) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.previewType.key);
        } else if ("operation".equals(context)) {
            ByteBufUtils.writeTag((ByteBuf)buffer, this.danglingOperation != null ? OperationRegistry.writeOperation(this.danglingOperation) : null);
        } else if ("options".equals(context)) {
            buffer.writeBoolean(this.showGrid);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("selection".equals(context)) {
            this.selectedPoint1 = BlockCoord.readCoordFromBuffer((ByteBuf)buffer);
            this.selectedPoint2 = BlockCoord.readCoordFromBuffer((ByteBuf)buffer);
        } else if ("previewType".equals(context)) {
            this.previewType = Operation.PreviewType.findOrDefault(ByteBufUtils.readUTF8String((ByteBuf)buffer), Operation.PreviewType.SHAPE);
        } else if ("operation".equals(context)) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buffer);
            this.danglingOperation = tag != null ? OperationRegistry.readOperation(tag) : null;
        } else if ("options".equals(context)) {
            this.showGrid = buffer.readBoolean();
        }
    }
}

