/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellPresetAction;
import ivorius.reccomplex.gui.table.TableDataSourceList;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.utils.IvTranslations;
import ivorius.reccomplex.utils.PresettedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.StatCollector;

public abstract class TableDataSourcePresettedList<T>
extends TableDataSourceList<T, List<T>>
implements TableCellActionListener {
    public PresettedList<T> presettedList;

    public TableDataSourcePresettedList(PresettedList<T> list, TableDelegate tableDelegate, TableNavigator navigator) {
        super(list.list, tableDelegate, navigator);
        this.presettedList = list;
    }

    @Override
    public boolean canEditList() {
        return this.presettedList.isCustom();
    }

    @Override
    public int numberOfSegments() {
        return super.numberOfSegments() + 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 0 ? 2 : super.sizeOfSegment(segment);
    }

    @Override
    public boolean isListSegment(int segment) {
        return segment == 2;
    }

    @Override
    public int getAddIndex(int segment) {
        return super.getAddIndex(segment - 1);
    }

    public TableCellButton.Action[] getPresetActions() {
        Collection<String> allTypes = this.presettedList.getListPresets().allTypes();
        ArrayList<TableCellButton.Action> actions = new ArrayList<TableCellButton.Action>(allTypes.size());
        String baseKey = this.getBasePresetKey();
        for (String type : allTypes) {
            actions.add(new TableCellButton.Action(type, StatCollector.func_74838_a((String)(baseKey + type)), IvTranslations.formatLines(baseKey + type + ".tooltip", new Object[0])));
        }
        return actions.toArray(new TableCellButton.Action[actions.size()]);
    }

    protected abstract String getBasePresetKey();

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            if (index == 0) {
                TableCellPresetAction cell = new TableCellPresetAction("preset", "Apply", this.getPresetActions());
                cell.addListener(this);
                return new TableElementCell("Presets", cell);
            }
            if (index == 1) {
                String title = !this.presettedList.isCustom() ? StatCollector.func_74838_a((String)(this.getBasePresetKey() + this.presettedList.getPreset())) : "Custom";
                TableCellButton cell = new TableCellButton("customize", new TableCellButton.Action("customize", "Customize", !this.presettedList.isCustom()));
                cell.addListener(this);
                return new TableElementCell(title, cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void actionPerformed(TableCell cell, String actionID) {
        if ("preset".equals(cell.getID())) {
            this.presettedList.setPreset(actionID);
            this.tableDelegate.reloadData();
        } else if (actionID.equals("customize")) {
            this.presettedList.setToCustom();
            this.tableDelegate.reloadData();
        }
        super.actionPerformed(cell, actionID);
    }
}

