/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazeComponent;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationInfo;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.gentypes.MazeGenerationInfo;

public class TableDataSourceMazeGenerationInfo
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private MazeGenerationInfo generationInfo;

    public TableDataSourceMazeGenerationInfo(TableNavigator navigator, TableDelegate tableDelegate, MazeGenerationInfo generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = tableDelegate;
        this.generationInfo = generationInfo;
        this.addManagedSection(0, new TableDataSourceGenerationInfo(generationInfo));
        this.addManagedSection(2, new TableDataSourceMazeComponent(generationInfo.mazeComponent, navigator, tableDelegate));
    }

    @Override
    public int numberOfSegments() {
        return 3;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 1 ? 1 : super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 1) {
            TableCellString cell = new TableCellString("mazeID", this.generationInfo.mazeID);
            cell.addPropertyListener(this);
            return new TableElementCell("Maze ID", cell);
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("mazeID".equals(cell.getID())) {
            this.generationInfo.mazeID = (String)cell.getPropertyValue();
        }
    }
}

