/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.transformers;

import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTNatural;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellInteger;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.structures.generic.transformers.TransformerPillar;
import net.minecraft.block.Block;

public class TableDataSourceBTPillar
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private TransformerPillar transformer;

    public TableDataSourceBTPillar(TransformerPillar transformer) {
        this.transformer = transformer;
        this.addManagedSection(0, TableDataSourceExpression.constructDefault("Sources", transformer.sourceMatcher));
    }

    public TransformerPillar getTransformer() {
        return this.transformer;
    }

    public void setTransformer(TransformerPillar transformer) {
        this.transformer = transformer;
    }

    @Override
    public int numberOfSegments() {
        return 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 1 ? 2 : super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 1) {
            if (index == 0) {
                TableCellString cell = TableDataSourceBTNatural.elementForBlock("destID", this.transformer.destBlock);
                cell.addPropertyListener(this);
                return new TableElementCell("Dest Block", cell);
            }
            if (index == 1) {
                TableCellInteger cell = new TableCellInteger("destMeta", this.transformer.destMetadata, 0, 16);
                cell.addPropertyListener(this);
                return new TableElementCell("Dest Metadata", cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("destID".equals(cell.getID())) {
            this.transformer.destBlock = (Block)Block.field_149771_c.func_82594_a(cell.getPropertyValue());
            TableDataSourceBTNatural.setStateForBlockTextfield((TableCellString)cell);
        } else if ("destMeta".equals(cell.getID())) {
            this.transformer.destMetadata = (Integer)cell.getPropertyValue();
        }
    }
}

