/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructureblock;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.reccomplex.blocks.TileEntityStructureGenerator;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellBoolean;
import ivorius.reccomplex.gui.table.TableCellEnum;
import ivorius.reccomplex.gui.table.TableCellInteger;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.StructureRegistry;
import java.util.Arrays;
import joptsimple.internal.Strings;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class TableDataSourceStructureBlock
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    protected TileEntityStructureGenerator structureGenerator;
    protected TableNavigator tableNavigator;
    protected TableDelegate tableDelegate;

    public TableDataSourceStructureBlock(TileEntityStructureGenerator structureGenerator, TableNavigator tableNavigator, TableDelegate tableDelegate) {
        this.structureGenerator = structureGenerator;
        this.tableNavigator = tableNavigator;
        this.tableDelegate = tableDelegate;
    }

    private static boolean doAllStructuresExist(Iterable<String> structures) {
        for (String s : structures) {
            if (s.length() == 0 || StructureRegistry.getStructure(s) != null) continue;
            return false;
        }
        return true;
    }

    public TileEntityStructureGenerator getStructureGenerator() {
        return this.structureGenerator;
    }

    public void setStructureGenerator(TileEntityStructureGenerator structureGenerator) {
        this.structureGenerator = structureGenerator;
    }

    @Override
    public int numberOfSegments() {
        return this.structureGenerator.isSimpleMode() ? 4 : 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        if (segment == 0) {
            return 1;
        }
        if (segment == 1) {
            return 1;
        }
        if (segment == 2) {
            return 3;
        }
        if (segment == 3) {
            return this.structureGenerator.isSimpleMode() ? 2 : 1;
        }
        return 0;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellBoolean cell = new TableCellBoolean("simpleMode", this.structureGenerator.isSimpleMode());
            cell.addPropertyListener(this);
            return new TableElementCell("Simple Mode", cell);
        }
        if (segment == 1) {
            if (this.structureGenerator.isSimpleMode()) {
                TableCellString cell = new TableCellString("generators", Strings.join(this.structureGenerator.getStructureNames(), (String)","));
                cell.setShowsValidityState(true);
                cell.setValidityState(TableDataSourceStructureBlock.doAllStructuresExist(this.structureGenerator.getStructureNames()) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID);
                cell.addPropertyListener(this);
                return new TableElementCell("Generators (A,B,...)", cell);
            }
            TableCellString cell = new TableCellString("listID", this.structureGenerator.getStructureListID());
            cell.addPropertyListener(this);
            return new TableElementCell("List ID", cell);
        }
        if (segment == 2) {
            if (index == 0) {
                TableCellInteger cell = new TableCellInteger("xShift", this.structureGenerator.getStructureShift().x, -50, 50);
                cell.addPropertyListener(this);
                return new TableElementCell("Shift: X", cell);
            }
            if (index == 1) {
                TableCellInteger cell = new TableCellInteger("yShift", this.structureGenerator.getStructureShift().y, -50, 50);
                cell.addPropertyListener(this);
                return new TableElementCell("Shift: Y", cell);
            }
            if (index == 2) {
                TableCellInteger cell = new TableCellInteger("zShift", this.structureGenerator.getStructureShift().z, -50, 50);
                cell.addPropertyListener(this);
                return new TableElementCell("Shift: Z", cell);
            }
        } else if (segment == 3) {
            if (this.structureGenerator.isSimpleMode()) {
                if (index == 0) {
                    TableCellEnum<Integer> cell = new TableCellEnum<Integer>("rotation", this.structureGenerator.getStructureRotation(), new TableCellEnum.Option<Integer>(0, "0 Clockwise"), new TableCellEnum.Option<Integer>(1, "1 Clockwise"), new TableCellEnum.Option<Integer>(2, "2 Clockwise"), new TableCellEnum.Option<Integer>(3, "3 Clockwise"), new TableCellEnum.Option<Object>(null, "Random (if rotatable)"));
                    cell.addPropertyListener(this);
                    return new TableElementCell("Rotation", cell);
                }
                if (index == 1) {
                    TableCellEnum<Boolean> cell = new TableCellEnum<Boolean>("mirror", this.structureGenerator.getStructureMirror(), new TableCellEnum.Option<Boolean>(false, "false"), new TableCellEnum.Option<Boolean>(true, "true"), new TableCellEnum.Option<Object>(null, "Random (if mirrorable)"));
                    cell.addPropertyListener(this);
                    return new TableElementCell("Mirror", cell);
                }
            } else {
                TableCellEnum<ForgeDirection> cell = new TableCellEnum<ForgeDirection>("front", this.structureGenerator.getFront(), TableDirections.getDirectionOptions((ForgeDirection[])ArrayUtils.add((Object[])Directions.HORIZONTAL, null), "random"));
                cell.addPropertyListener(this);
                return new TableElementCell("Front", cell);
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "simpleMode": {
                    this.structureGenerator.setSimpleMode((Boolean)cell.getPropertyValue());
                    this.tableDelegate.reloadData();
                    break;
                }
                case "generators": {
                    String value = (String)cell.getPropertyValue();
                    this.structureGenerator.setStructureNames(Arrays.asList(value.split(",")));
                    ((TableCellString)cell).setValidityState(TableDataSourceStructureBlock.doAllStructuresExist(this.structureGenerator.getStructureNames()) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID);
                    break;
                }
                case "listID": {
                    this.structureGenerator.setStructureListID((String)cell.getPropertyValue());
                    break;
                }
                case "xShift": {
                    BlockCoord shift = this.structureGenerator.getStructureShift();
                    this.structureGenerator.setStructureShift(new BlockCoord(((Integer)cell.getPropertyValue()).intValue(), shift.y, shift.z));
                    break;
                }
                case "yShift": {
                    BlockCoord shift = this.structureGenerator.getStructureShift();
                    this.structureGenerator.setStructureShift(new BlockCoord(shift.x, ((Integer)cell.getPropertyValue()).intValue(), shift.z));
                    break;
                }
                case "zShift": {
                    BlockCoord shift = this.structureGenerator.getStructureShift();
                    this.structureGenerator.setStructureShift(new BlockCoord(shift.x, shift.y, ((Integer)cell.getPropertyValue()).intValue()));
                    break;
                }
                case "rotation": {
                    this.structureGenerator.setStructureRotation((Integer)cell.getPropertyValue());
                    break;
                }
                case "mirror": {
                    this.structureGenerator.setStructureMirror((Boolean)cell.getPropertyValue());
                    break;
                }
                case "front": {
                    this.structureGenerator.setFront((ForgeDirection)cell.getPropertyValue());
                }
            }
        }
    }
}

