/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.MathHelper;

public class TableCellPresetAction
extends TableCellDefault {
    protected GuiButton changePresetButton;
    protected GuiButton runActionButton;
    protected String currentActionID;
    protected String actionTitle;
    protected TableCellButton.Action[] actions;
    protected List<TableCellActionListener> listeners = new ArrayList<TableCellActionListener>();
    protected float actionButtonWidth = 0.4f;

    public TableCellPresetAction(String id, String actionTitle, TableCellButton.Action ... actions) {
        super(id);
        this.actionTitle = actionTitle;
        this.actions = actions;
        this.currentActionID = actions[0].id;
    }

    public static Bounds getBounds(GuiButton button) {
        return Bounds.fromSize(button.field_146128_h, button.field_146120_f, button.field_146129_i, button.field_146121_g);
    }

    public void addListener(TableCellActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TableCellActionListener listener) {
        this.listeners.remove(listener);
    }

    public List<TableCellActionListener> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public TableCellButton.Action[] getActions() {
        return this.actions;
    }

    public float getActionButtonWidth() {
        return this.actionButtonWidth;
    }

    public void setActionButtonWidth(float actionButtonWidth) {
        this.actionButtonWidth = actionButtonWidth;
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        int curIndex = this.currentActionIndex();
        String title = curIndex >= 0 ? this.actions[curIndex].title : this.currentActionID;
        int presetButtonWidth = MathHelper.func_76141_d((float)((float)bounds.getWidth() * (1.0f - this.actionButtonWidth))) - 1;
        this.changePresetButton = new GuiButton(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, presetButtonWidth, 20, title);
        this.changePresetButton.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, this.changePresetButton);
        this.runActionButton = new GuiButton(-1, bounds.getMinX() + presetButtonWidth + 2, bounds.getMinY() + (bounds.getHeight() - 20) / 2, MathHelper.func_76141_d((float)((float)bounds.getWidth() * this.actionButtonWidth)) - 1, 20, this.actionTitle);
        this.runActionButton.field_146125_m = !this.isHidden();
        screen.addButton(this, 1, this.runActionButton);
        this.setActionButtonActive();
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.changePresetButton != null) {
            boolean bl = this.changePresetButton.field_146125_m = !hidden;
        }
        if (this.runActionButton != null) {
            this.runActionButton.field_146125_m = !hidden;
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        if (buttonID == 0) {
            TableCellButton.Action newAction = this.actions[(this.currentActionIndex() + 1) % this.actions.length];
            this.currentActionID = newAction.id;
            this.changePresetButton.field_146126_j = newAction.title;
            this.setActionButtonActive();
        } else if (buttonID == 1) {
            for (TableCellActionListener listener : this.listeners) {
                listener.actionPerformed(this, this.currentActionID);
            }
        }
    }

    @Override
    public void drawFloating(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        super.drawFloating(screen, mouseX, mouseY, partialTicks);
        TableCellButton.Action action = this.currentAction();
        if (action != null && action.tooltip != null) {
            screen.drawTooltipRect(action.tooltip, TableCellPresetAction.getBounds(this.changePresetButton), mouseX, mouseY, this.getFontRenderer());
        }
    }

    private TableCellButton.Action currentAction() {
        int index = this.currentActionIndex();
        return index >= 0 ? this.actions[index] : null;
    }

    private int currentActionIndex() {
        int currentIndex = -1;
        for (int i = 0; i < this.actions.length; ++i) {
            TableCellButton.Action action = this.actions[i];
            if (!action.id.equals(this.currentActionID)) continue;
            currentIndex = i;
        }
        return currentIndex;
    }

    private void setActionButtonActive() {
        if (this.runActionButton != null) {
            int currentActionIndex = this.currentActionIndex();
            this.runActionButton.field_146124_l = currentActionIndex >= 0 && this.actions[currentActionIndex].enabled;
        }
    }
}

