/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import com.google.common.primitives.Ints;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableElement;

public abstract class TableDataSourceSegmented
implements TableDataSource {
    protected final TIntObjectMap<TableDataSource> managedSections = new TIntObjectHashMap();

    public void addManagedSection(int section, TableDataSource source) {
        this.managedSections.put(section, (Object)source);
    }

    public void removeManagedSection(int section) {
        this.managedSections.remove(section);
    }

    public TIntSet managedSections() {
        return this.managedSections.keySet();
    }

    @Override
    public int numberOfElements() {
        int elements = 0;
        int segments = this.numberOfSegments();
        for (int i = 0; i < segments; ++i) {
            elements += this.sizeOfSegment(i);
        }
        return elements;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        for (int seg = 0; seg < this.numberOfSegments(); ++seg) {
            if (index - this.sizeOfSegment(seg) < 0) {
                return this.elementForIndexInSegment(table, index, seg);
            }
            index -= this.sizeOfSegment(seg);
        }
        return null;
    }

    public int numberOfSegments() {
        return this.managedSections.isEmpty() ? 0 : Ints.max((int[])this.managedSections.keys()) + 1;
    }

    public int sizeOfSegment(int segment) {
        TableDataSource managed = (TableDataSource)this.managedSections.get(segment);
        return managed != null ? managed.numberOfElements() : 0;
    }

    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        TableDataSource managed = (TableDataSource)this.managedSections.get(segment);
        return managed != null ? managed.elementForIndex(table, index) : null;
    }
}

