/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.matchers.DimensionMatcher;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import net.minecraft.world.WorldProvider;

public class DimensionGenerationInfo {
    private DimensionMatcher dimensionMatcher;
    private Double generationWeight;

    public DimensionGenerationInfo(String expression, Double generationWeight) {
        this.dimensionMatcher = new DimensionMatcher(expression);
        this.generationWeight = generationWeight;
    }

    public Double getGenerationWeight() {
        return this.generationWeight;
    }

    public void setGenerationWeight(Double generationWeight) {
        this.generationWeight = generationWeight;
    }

    public double getActiveGenerationWeight() {
        return this.generationWeight != null ? this.generationWeight : 1.0;
    }

    public boolean hasDefaultWeight() {
        return this.generationWeight == null;
    }

    public boolean matches(WorldProvider provider) {
        return this.dimensionMatcher.apply(provider);
    }

    public DimensionMatcher getDimensionMatcher() {
        return this.dimensionMatcher;
    }

    public String getDisplayString() {
        return this.dimensionMatcher.getDisplayString();
    }

    public static class Serializer
    implements JsonDeserializer<DimensionGenerationInfo>,
    JsonSerializer<DimensionGenerationInfo> {
        public DimensionGenerationInfo deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            String expression;
            JsonObject jsonobject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "generationInfo");
            if (jsonobject.has("dimensionID")) {
                expression = JsonUtils.getJsonObjectStringFieldValue(jsonobject, "dimensionID");
                if (expression.startsWith("Type:")) {
                    expression = "$" + expression.substring(5).replaceAll(",", Matcher.quoteReplacement(" & $"));
                }
            } else {
                expression = JsonUtils.getJsonObjectStringFieldValue(jsonobject, "dimensions");
            }
            Double weight = jsonobject.has("weight") ? Double.valueOf(JsonUtils.getJsonObjectDoubleFieldValue(jsonobject, "weight")) : null;
            return new DimensionGenerationInfo(expression, weight);
        }

        public JsonElement serialize(DimensionGenerationInfo generationInfo, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("dimensions", generationInfo.getDimensionMatcher().getExpression());
            if (generationInfo.generationWeight != null) {
                jsonobject.addProperty("weight", (Number)generationInfo.generationWeight);
            }
            return jsonobject;
        }
    }
}

