/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic;

import com.google.gson.annotations.SerializedName;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Selection
extends ArrayList<Area> {
    private static void mergeRooms(boolean additive, int dimIndex, int[] min, int[] max, int[] position, Set<MazeRoom> rooms) {
        for (int i = min[dimIndex]; i <= max[dimIndex]; ++i) {
            position[dimIndex] = i;
            if (dimIndex == position.length - 1) {
                if (additive) {
                    rooms.add(new MazeRoom((int[])position.clone()));
                    continue;
                }
                rooms.remove(new MazeRoom(position));
                continue;
            }
            Selection.mergeRooms(additive, dimIndex + 1, min, max, position, rooms);
        }
    }

    public static Selection zeroSelection(int dimensions) {
        Selection selection = new Selection();
        selection.add(new Area(true, new int[dimensions], new int[dimensions]));
        return selection;
    }

    public Set<MazeRoom> mazeRooms(boolean additive) {
        if (additive) {
            HashSet<MazeRoom> rooms = new HashSet<MazeRoom>();
            for (Area area : this) {
                Selection.mergeRooms(area.additive, 0, area.minCoord, area.maxCoord, (int[])area.minCoord.clone(), rooms);
            }
            return rooms;
        }
        HashSet<MazeRoom> spaces = new HashSet<MazeRoom>();
        int[] min = this.boundsLower();
        int[] max = this.boundsHigher();
        Selection.mergeRooms(true, 0, min, max, (int[])min.clone(), spaces);
        for (Area area : this) {
            Selection.mergeRooms(!area.additive, 0, area.minCoord, area.maxCoord, (int[])area.minCoord.clone(), spaces);
        }
        return spaces;
    }

    public void readFromNBT(NBTTagCompound compound, int dimensions) {
        this.clear();
        NBTTagList list = compound.func_150295_c("areas", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.add(new Area(list.func_150305_b(i), dimensions));
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Area area : this) {
            list.func_74742_a((NBTBase)area.writeToNBT());
        }
        compound.func_74782_a("areas", (NBTBase)list);
    }

    public int[] boundsLower() {
        int[] min = null;
        for (Area area : this) {
            if (min == null) {
                min = area.minCoord;
                continue;
            }
            for (int d = 0; d < area.minCoord.length; ++d) {
                min[d] = Math.min(min[d], area.minCoord[d]);
            }
        }
        return min;
    }

    public int[] boundsHigher() {
        int[] max = null;
        for (Area area : this) {
            if (max == null) {
                max = area.maxCoord;
                continue;
            }
            for (int d = 0; d < area.maxCoord.length; ++d) {
                max[d] = Math.max(max[d], area.maxCoord[d]);
            }
        }
        return max;
    }

    public int[] boundsSize() {
        int[] min = this.boundsLower();
        int[] max = this.boundsHigher();
        int[] minusOne = new int[min.length];
        Arrays.fill(minusOne, -1);
        return IvVecMathHelper.sub((int[])max, (int[][])new int[][]{min, minusOne});
    }

    public static class Area {
        @SerializedName(value="additive")
        private boolean additive;
        @SerializedName(value="minCoord")
        private int[] minCoord;
        @SerializedName(value="maxCoord")
        private int[] maxCoord;

        public Area(boolean additive, IntegerRange ... ranges) {
            this.additive = additive;
            this.minCoord = new int[ranges.length];
            this.maxCoord = new int[ranges.length];
            for (int i = 0; i < ranges.length; ++i) {
                this.minCoord[i] = ranges[i].getMin();
                this.maxCoord[i] = ranges[i].getMax();
            }
        }

        public Area(boolean additive, int[] minCoord, int[] maxCoord) {
            this.additive = additive;
            this.minCoord = minCoord;
            this.maxCoord = maxCoord;
        }

        public Area(NBTTagCompound tagCompound, int dimensions) {
            this.additive = tagCompound.func_74767_n("additive");
            this.minCoord = IvNBTHelper.readIntArrayFixedSize((String)"min", (int)dimensions, (NBTTagCompound)tagCompound);
            this.maxCoord = IvNBTHelper.readIntArrayFixedSize((String)"max", (int)dimensions, (NBTTagCompound)tagCompound);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("additive", this.additive);
            compound.func_74783_a("min", this.minCoord);
            compound.func_74783_a("max", this.maxCoord);
            return compound;
        }

        public int[] getMinCoord() {
            return (int[])this.minCoord.clone();
        }

        public void setMinCoord(int[] minCoord) {
            this.minCoord = (int[])minCoord.clone();
        }

        public int[] getMaxCoord() {
            return (int[])this.maxCoord.clone();
        }

        public void setMaxCoord(int[] maxCoord) {
            this.maxCoord = (int[])maxCoord.clone();
        }

        public void setCoord(int dim, int min, int max) {
            this.minCoord[dim] = min;
            this.maxCoord[dim] = max;
        }

        public boolean isAdditive() {
            return this.additive;
        }

        public void setAdditive(boolean additive) {
            this.additive = additive;
        }
    }
}

