/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazeComponentPlacementStrategy;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import java.util.Collection;
import javax.annotation.Nonnull;

public class LimitAABBStrategy<M extends MazeComponent<C>, C>
implements MazeComponentPlacementStrategy<M, C> {
    @Nonnull
    private int[] roomNumbers;
    @Nonnull
    private Collection<C> ignoredConnections;

    public LimitAABBStrategy(@Nonnull int[] roomNumbers, @Nonnull Collection<C> ignoredConnections) {
        this.roomNumbers = roomNumbers;
        this.ignoredConnections = ignoredConnections;
    }

    public boolean isRoomContained(MazeRoom input) {
        for (int i = 0; i < input.getDimensions(); ++i) {
            if (input.getCoordinate(i) >= 0 && input.getCoordinate(i) < this.roomNumbers[i]) continue;
            return false;
        }
        return true;
    }

    public boolean canPlace(ShiftedMazeComponent<M, C> component) {
        return Iterables.all((Iterable)component.rooms(), (Predicate)new Predicate<MazeRoom>(){

            public boolean apply(MazeRoom input) {
                return LimitAABBStrategy.this.isRoomContained(input);
            }
        });
    }

    public boolean shouldContinue(MazeRoom dest, MazeRoom source, C c) {
        return this.isRoomContained(dest) && !this.ignoredConnections.contains(c);
    }
}

