/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MazeRoomConnection;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.ConnectorFactory;
import ivorius.reccomplex.structures.generic.maze.SavedConnector;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public class SavedMazePath
implements NBTCompoundObject {
    public int pathDimension;
    public MazeRoom sourceRoom;
    public boolean pathGoesUp;
    public final SavedConnector connector = new SavedConnector();

    public SavedMazePath() {
        this.connector.id = "Path";
    }

    public SavedMazePath(int pathDimension, MazeRoom sourceRoom, boolean pathGoesUp, String connector) {
        this.pathDimension = pathDimension;
        this.sourceRoom = sourceRoom;
        this.pathGoesUp = pathGoesUp;
        this.connector.id = connector;
    }

    public Map.Entry<MazeRoomConnection, Connector> toRoomConnection(ConnectorFactory factory) {
        return Pair.of((Object)new MazeRoomConnection(this.sourceRoom, this.sourceRoom.addInDimension(this.pathDimension, this.pathGoesUp ? 1 : -1)), (Object)this.connector.toConnector(factory));
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.sourceRoom = compound.func_150297_b("source", 10) ? new MazeRoom(compound.func_74775_l("source").func_74759_k("coordinates")) : new MazeRoom(compound.func_74759_k("source"));
        this.pathDimension = compound.func_74762_e("pathDimension");
        this.pathGoesUp = compound.func_74767_n("pathGoesUp");
        this.connector.id = compound.func_150297_b("connector", 8) ? compound.func_74779_i("connector") : "Path";
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("source", (NBTBase)this.sourceRoom.storeInNBT());
        compound.func_74768_a("pathDimension", this.pathDimension);
        compound.func_74757_a("pathGoesUp", this.pathGoesUp);
        compound.func_74778_a("connector", this.connector.id);
    }

    public static class Serializer
    implements JsonSerializer<SavedMazePath>,
    JsonDeserializer<SavedMazePath> {
        public SavedMazePath deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "MazeRoom");
            MazeRoom src = (MazeRoom)context.deserialize(jsonObject.get("source"), MazeRoom.class);
            int pathDimension = JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "pathDimension");
            boolean pathGoesUp = JsonUtils.getJsonObjectBooleanFieldValue(jsonObject, "pathGoesUp");
            String connector = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "connector", "Path");
            return new SavedMazePath(pathDimension, src, pathGoesUp, connector);
        }

        public JsonElement serialize(SavedMazePath src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("source", context.serialize((Object)src.sourceRoom));
            jsonObject.addProperty("pathDimension", (Number)src.pathDimension);
            jsonObject.addProperty("pathGoesUp", Boolean.valueOf(src.pathGoesUp));
            jsonObject.addProperty("connector", src.connector.id);
            return jsonObject;
        }
    }
}

