/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.transformers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTNatural;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.MCRegistrySpecial;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.matchers.BlockMatcher;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.structures.generic.transformers.TransformerReplace;
import ivorius.reccomplex.structures.generic.transformers.TransformerSingleBlock;
import ivorius.reccomplex.utils.NBTNone;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TransformerNatural
extends TransformerSingleBlock<NBTNone> {
    public static final double DEFAULT_NATURAL_EXPANSION_DISTANCE = 4.0;
    public static final double DEFAULT_NATURAL_EXPANSION_RANDOMIZATION = 6.0;
    public BlockMatcher sourceMatcher;
    public double naturalExpansionDistance;
    public double naturalExpansionRandomization;

    public TransformerNatural() {
        this(BlockMatcher.of((MCRegistry)MCRegistrySpecial.INSTANCE, RCBlocks.naturalFloor, 0), 4.0, 6.0);
    }

    public TransformerNatural(String sourceMatcherExpression, double naturalExpansionDistance, double naturalExpansionRandomization) {
        this.sourceMatcher = new BlockMatcher(MCRegistrySpecial.INSTANCE, sourceMatcherExpression);
        this.naturalExpansionDistance = naturalExpansionDistance;
        this.naturalExpansionRandomization = naturalExpansionRandomization;
    }

    @Override
    public boolean matches(NBTNone instanceData, Block block, int metadata) {
        return this.sourceMatcher.apply(new BlockMatcher.BlockFragment(block, metadata));
    }

    @Override
    public void transformBlock(NBTNone instanceData, Transformer.Phase phase, StructureSpawnContext context, BlockCoord coord, Block sourceBlock, int sourceMetadata) {
        Block fillerBlock;
        World world = context.world;
        Random random = context.random;
        BiomeGenBase biome = world.func_72807_a(coord.x, coord.z);
        Block topBlock = biome.field_76752_A != null ? biome.field_76752_A : Blocks.field_150350_a;
        Block block = fillerBlock = biome.field_76753_B != null ? biome.field_76753_B : Blocks.field_150350_a;
        Block mainBlock = world.field_73011_w.field_76574_g == -1 ? Blocks.field_150424_aL : (world.field_73011_w.field_76574_g == 1 ? Blocks.field_150377_bs : Blocks.field_150348_b);
        boolean useStoneBlock = this.hasBlockAbove(world, coord.x, coord.y, coord.z, mainBlock);
        if (phase == Transformer.Phase.BEFORE) {
            ArrayList currentList = new ArrayList();
            ArrayList<int[]> nextList = new ArrayList<int[]>();
            nextList.add(new int[]{coord.x, coord.z});
            for (int currentY = coord.y; nextList.size() > 0 && currentY > 1; --currentY) {
                ArrayList cachedList = currentList;
                currentList = nextList;
                nextList = cachedList;
                while (currentList.size() > 0) {
                    boolean replaceable;
                    int[] currentPos = (int[])currentList.remove(0);
                    int currentX = currentPos[0];
                    int currentZ = currentPos[1];
                    Block curBlock = world.func_147439_a(currentX, currentY, currentZ);
                    boolean bl = replaceable = currentY == coord.y || curBlock.isReplaceable((IBlockAccess)world, currentX, currentY, currentZ);
                    if (replaceable) {
                        Block setBlock = useStoneBlock ? mainBlock : (this.isTopBlock(world, currentX, currentY, currentZ) ? topBlock : fillerBlock);
                        context.setBlock(currentX, currentY, currentZ, setBlock, 0);
                    }
                    if (!replaceable) continue;
                    double yForDistance = (double)coord.y * 0.3 + (double)currentY * 0.7;
                    double distToOrigSQ = IvVecMathHelper.distanceSQ((double[])new double[]{coord.x, coord.y, coord.z}, (double[])new double[]{currentX, yForDistance, currentZ});
                    double add = (random.nextDouble() - random.nextDouble()) * this.naturalExpansionRandomization;
                    double d = add < 0.0 ? -(add * add) : add * add;
                    if (!((distToOrigSQ += d) < this.naturalExpansionDistance * this.naturalExpansionDistance)) continue;
                    this.addIfNew(nextList, currentX, currentZ);
                    this.addIfNew(nextList, currentX - 1, currentZ);
                    this.addIfNew(nextList, currentX + 1, currentZ);
                    this.addIfNew(nextList, currentX, currentZ - 1);
                    this.addIfNew(nextList, currentX, currentZ + 1);
                }
            }
        } else {
            Block setBlock = useStoneBlock ? mainBlock : (this.isTopBlock(world, coord.x, coord.y, coord.z) ? topBlock : fillerBlock);
            context.setBlock(coord.x, coord.y, coord.z, setBlock, 0);
        }
    }

    private void addIfNew(List<int[]> list, int ... object) {
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    private boolean hasBlockAbove(World world, int x, int y, int z, Block blockType) {
        int origY = y;
        while (y < world.func_72800_K() && y < origY + 60) {
            if (world.func_147439_a(x, y, z) == blockType) {
                return true;
            }
            ++y;
        }
        return false;
    }

    private boolean isTopBlock(World world, int x, int y, int z) {
        return !world.func_147445_c(x, y + 1, z, false);
    }

    @Override
    public boolean generatesInPhase(NBTNone instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public String getDisplayString() {
        return "Natural: " + this.sourceMatcher.getDisplayString();
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTNatural(this);
    }

    public static class Serializer
    implements JsonDeserializer<TransformerNatural>,
    JsonSerializer<TransformerNatural> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerNatural deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "transformerNatural");
            String expression = TransformerReplace.Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "sourceExpression", "");
            }
            double naturalExpansionDistance = JsonUtils.getJsonObjectDoubleFieldValueOrDefault(jsonObject, "naturalExpansionDistance", 4.0);
            double naturalExpansionRandomization = JsonUtils.getJsonObjectDoubleFieldValueOrDefault(jsonObject, "naturalExpansionRandomization", 6.0);
            return new TransformerNatural(expression, naturalExpansionDistance, naturalExpansionRandomization);
        }

        public JsonElement serialize(TransformerNatural transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            jsonObject.addProperty("naturalExpansionDistance", (Number)transformer.naturalExpansionDistance);
            jsonObject.addProperty("naturalExpansionRandomization", (Number)transformer.naturalExpansionRandomization);
            return jsonObject;
        }
    }
}

