/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.utilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public abstract class InventoryStatic
implements IInventory {
    public final ItemStack[] items;

    public InventoryStatic(int size) {
        this.items = new ItemStack[size];
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void onInventoryChanged(int slot) {
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.items[i] != null) {
            if (this.items[i].field_77994_a <= j) {
                ItemStack itemstack = this.items[i];
                this.items[i] = null;
                this.onInventoryChanged();
                this.onInventoryChanged(i);
                return itemstack;
            }
            ItemStack itemstack1 = this.items[i].func_77979_a(j);
            if (this.items[i].field_77994_a == 0) {
                this.items[i] = null;
            }
            this.onInventoryChanged();
            this.onInventoryChanged(i);
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.items[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.onInventoryChanged();
        this.onInventoryChanged(i);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.items.length) continue;
            this.items[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.onInventoryChanged();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("items", (NBTBase)nbttaglist);
    }

    private int getFirstEmptyStack(int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (this.items[i] != null) continue;
            return i;
        }
        return -1;
    }

    private int storeItemStack(ItemStack itemstack, int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (this.items[i] == null || !this.items[i].func_77973_b().equals(itemstack.func_77973_b()) || !this.items[i].func_77985_e() || this.items[i].field_77994_a >= this.items[i].func_77976_d() || this.items[i].field_77994_a >= this.func_70297_j_() || this.items[i].func_77981_g() && this.items[i].func_77960_j() != itemstack.func_77960_j()) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack itemstack, int start, int end) {
        int l;
        Item i = itemstack.func_77973_b();
        int j = itemstack.field_77994_a;
        int k = this.storeItemStack(itemstack, start, end);
        if (k < 0) {
            k = this.getFirstEmptyStack(start, end);
        }
        if (k < 0) {
            return j;
        }
        if (this.items[k] == null) {
            this.items[k] = new ItemStack(i, 0, itemstack.func_77960_j());
        }
        if ((l = j) > this.items[k].func_77976_d() - this.items[k].field_77994_a) {
            l = this.items[k].func_77976_d() - this.items[k].field_77994_a;
        }
        if (l > this.func_70297_j_() - this.items[k].field_77994_a) {
            l = this.func_70297_j_() - this.items[k].field_77994_a;
        }
        if (l == 0) {
            return j;
        }
        this.items[k].field_77994_a += l;
        this.items[k].field_77992_b = 5;
        this.onInventoryChanged();
        this.onInventoryChanged(k);
        return j -= l;
    }

    public boolean addItemStackToInventory(ItemStack itemstack, int start, int end) {
        if (itemstack == null) {
            return true;
        }
        if (!itemstack.func_77951_h()) {
            int i;
            do {
                i = itemstack.field_77994_a;
                itemstack.field_77994_a = this.storePartialItemStack(itemstack, start, end);
            } while (itemstack.field_77994_a > 0 && itemstack.field_77994_a < i);
            return itemstack.field_77994_a < i;
        }
        int j = this.getFirstEmptyStack(start, end);
        if (j >= 0) {
            this.items[j] = ItemStack.func_77944_b((ItemStack)itemstack);
            this.items[j].field_77992_b = 5;
            itemstack.field_77994_a = 0;
            this.onInventoryChanged();
            this.onInventoryChanged(j);
            return true;
        }
        return false;
    }

    public boolean addItemStackToInventory(ItemStack itemstack) {
        return this.addItemStackToInventory(itemstack, 0, this.items.length - 1);
    }

    public ItemStack takeItems(Item item, int damage, int count) {
        ItemStack res = null;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || !this.items[i].func_77973_b().equals(item) || this.items[i].func_77960_j() != damage) continue;
            if (res == null) {
                res = new ItemStack(item, 0, damage);
            }
            while (this.items[i] != null && res.field_77994_a < count && this.items[i].field_77994_a > 0) {
                ++res.field_77994_a;
                --this.items[i].field_77994_a;
                if (this.items[i].field_77994_a == 0) {
                    this.items[i] = null;
                }
                this.onInventoryChanged(i);
            }
            if (res.field_77994_a >= count) break;
        }
        this.onInventoryChanged();
        return res;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void onInventoryChanged() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].func_77973_b() == null) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
    }

    public void throwItems(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack itemstack = this.items[i];
            if (itemstack == null) continue;
            this.items[i] = null;
            float xx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float yy = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float zz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int c = world.field_73012_v.nextInt(21) + 10;
                if (c > itemstack.field_77994_a) {
                    c = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= c;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + xx), (double)((float)y + yy), (double)((float)z + zz), new ItemStack(itemstack.func_77973_b(), c, itemstack.func_77960_j()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
        this.onInventoryChanged();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
    }
}

