/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import openmods.structured.ElementField;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;
import openmods.structured.StructureField;

public abstract class FieldContainer
implements IStructureContainer<IStructureElement> {
    private final Map<Field, ElementField> fields = Maps.newHashMap();

    @Override
    public List<IStructureElement> createElements() {
        ArrayList result = Lists.newArrayList();
        for (Field field : this.getClass().getFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(StructureField.class)) continue;
            ElementField fieldWrapper = new ElementField(this, field);
            result.add(fieldWrapper);
            this.fields.put(field, fieldWrapper);
        }
        return result;
    }

    public IStructureElement getElementForField(Field field) {
        return this.fields.get(field);
    }
}

