/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;

public abstract class StructuredData<C extends IStructureContainer<E>, E extends IStructureElement> {
    protected final SortedMap<Integer, E> elements = Maps.newTreeMap();
    protected final SortedMap<Integer, C> containers = Maps.newTreeMap();
    protected final TreeMultimap<Integer, Integer> containerToElement = TreeMultimap.create();
    protected final Map<Integer, Integer> elementToContainer = Maps.newHashMap();

    public boolean isEmpty() {
        return this.elements.isEmpty() && this.containers.isEmpty();
    }

    public void reset() {
        this.elements.clear();
        this.containers.clear();
        this.containerToElement.clear();
        this.elementToContainer.clear();
    }

    protected SortedSet<Integer> removeContainer(int containerId) {
        Preconditions.checkArgument((boolean)this.containerToElement.containsKey((Object)containerId), (String)"Container %s doesn't exists", (Object[])new Object[]{containerId});
        SortedSet removedElements = this.containerToElement.removeAll((Object)containerId);
        for (Integer id : removedElements) {
            IStructureElement element = (IStructureElement)this.elements.remove(id);
            this.elementToContainer.remove(element);
        }
        this.containers.remove(containerId);
        return removedElements;
    }

    protected int addContainer(int containerId, C container, int firstElementId) {
        List newElements = container.createElements();
        Preconditions.checkArgument((!newElements.isEmpty() ? 1 : 0) != 0, (String)"New container %s has no elements", (Object[])new Object[]{container});
        for (IStructureElement element : newElements) {
            int elementId = firstElementId++;
            this.elements.put(elementId, element);
            this.containerToElement.put((Object)containerId, (Object)elementId);
            this.elementToContainer.put(elementId, containerId);
            element.setId(elementId);
            container.onElementAdded((IStructureElement)element);
        }
        this.containers.put(containerId, container);
        return firstElementId;
    }
}

