/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.config.configfiles;

import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import ttftcuts.atg.ATG;
import ttftcuts.atg.api.IGenMod;
import ttftcuts.atg.biome.ATGBiomeGroup;
import ttftcuts.atg.config.configfiles.GroupDef;
import ttftcuts.atg.feature.ATGWorldGenRocks;
import ttftcuts.atg.gen.ATGBiomeManager;
import ttftcuts.atg.utils.ModFinder;
import ttftcuts.atg.utils.Tuple;

public class ATGGeneratorConfig {
    public static Configuration config;
    public static Property regenerate;
    private static String catGroupsName;
    private static String catBiomesName;
    private static String catSubBiomesName;
    private static String catGenModsName;
    private static String catRocksName;
    private static String catControlName;
    private static ConfigCategory catGroups;
    private static ConfigCategory catBiomes;
    private static ConfigCategory catSubBiomes;
    private static ConfigCategory catGenMods;
    private static String genModsDesc;
    private static ConfigCategory catRocks;
    private static ConfigCategory catControl;
    private static HashMap<String, IGenMod> genMods;
    public static Map<String, GroupDef> groupDefinitions;
    public static Map<String, Set<Tuple<String, Double>>> groupAssignments;
    public static Map<String, Set<Tuple<String, Double>>> subBiomeAssignments;
    public static Map<String, String> genModAssignments;
    public static Map<String, int[]> rocks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configfile) {
        genMods = new HashMap();
        config = new Configuration(configfile, null, true);
        try {
            ATG.logger.info("WAT");
            config.load();
            catControl = config.getCategory(catControlName);
            catControl.setComment(" ");
            regenerate = config.get(catControlName, "Regenerate", true);
            ATGGeneratorConfig.regenerate.comment = "Set this to true to regenerate missing default config options on next load without removing existing entries.";
            catGroups = config.getCategory(catGroupsName);
            catGroups.setComment("Definitions for biome groups. Biome groups cover condition ranges, and randomly select biomes within them to fill spaces in the world. You generally won't need to change these, so don't unless you have specific need.");
            catBiomes = config.getCategory(catBiomesName);
            catBiomes.setComment("Assignment of biomes to groups. Weighting values dictate how common a biome will be within its assigned group.");
            catSubBiomes = config.getCategory(catSubBiomesName);
            catSubBiomes.setComment("Assignment of sub-biomes. Sub-biomes appear within their parent biome, replacing parts of it. Weighting values dictate how commonly they appear.");
            catGenMods = config.getCategory(catGenModsName);
            genModsDesc = "Assignment of IGenMod objects to biomes. Gen mods alter the way the biome expresses its height. Volcanoes use this for their craters, Swamps to be near the water level, and Mushroom Islands to appear above the surface.\n\nIGenMods can be added by mods via the API, and will appear in this list when the file is regenerated.\n\nList of available IGenMods:\n\n";
            catRocks = config.getCategory(catRocksName);
            catRocks.setComment("Overrides the appearance of large rocks in biomes.\n\nFrequency: Rocks appear once per x chunks.\nLarge frequency: One in x rocks are large.\nRocks per chunk: check for rock frequency made x times per chunk.");
        }
        catch (Exception e) {
            System.out.println("ATG: Failed to load generator config!");
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static void parse() {
        if (regenerate.getBoolean()) {
            ATGGeneratorConfig.buildDefaults();
        }
        ATGGeneratorConfig.read();
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void read() {
        BiomeGenBase b;
        String name;
        String[] strings;
        for (ConfigCategory g : catGroups.getChildren()) {
            strings = g.getName().split("-");
            if (strings.length != 2) continue;
            name = strings[1];
            double temperature = 0.5;
            double rainfall = 0.5;
            double height = 0.5;
            double minheight = 0.0;
            double maxheight = 1.0;
            long seed = 0L;
            boolean generate = true;
            double suitability = 1.0;
            Property p = g.get("Temperature");
            if (p != null) {
                temperature = p.getDouble();
            }
            if ((p = g.get("Rainfall")) != null) {
                rainfall = p.getDouble();
            }
            if ((p = g.get("Height")) != null) {
                height = p.getDouble();
            }
            if ((p = g.get("Min Height")) != null) {
                minheight = p.getDouble();
            }
            if ((p = g.get("Max Height")) != null) {
                maxheight = p.getDouble();
            }
            if ((p = g.get("Random Seed")) != null) {
                seed = p.getInt();
            }
            if ((p = g.get("Generate")) != null) {
                generate = p.getBoolean();
            }
            if ((p = g.get("Suitability")) != null) {
                suitability = p.getDouble();
            }
            if (strings[0].toLowerCase().equals("land")) {
                ATGBiomeManager.addLandGroup(name, temperature, rainfall, height, minheight, maxheight, seed, generate).modSuitability(suitability);
                continue;
            }
            if (strings[0].toLowerCase().equals("coast")) {
                ATGBiomeManager.addCoastGroup(name, temperature, rainfall, height, minheight, maxheight, seed, generate).modSuitability(suitability);
                continue;
            }
            if (strings[0].toLowerCase().equals("sea")) {
                ATGBiomeManager.addSeaGroup(name, temperature, rainfall, height, minheight, maxheight, seed, generate).modSuitability(suitability);
                continue;
            }
            ATG.logger.info("Invalid group type: " + strings[0]);
        }
        for (ConfigCategory g : catBiomes.getChildren()) {
            strings = g.getName().split("-");
            if (strings.length != 2) continue;
            name = strings[1];
            ATGBiomeGroup group = null;
            if (strings[0].toLowerCase().equals("land")) {
                group = ATGBiomeManager.land(name);
            } else if (strings[0].toLowerCase().equals("coast")) {
                group = ATGBiomeManager.coast(name);
            } else if (strings[0].toLowerCase().equals("sea")) {
                group = ATGBiomeManager.sea(name);
            }
            if (group == null) {
                ATG.logger.warn("Biome group \"" + name + "\" not found, skipping.");
                continue;
            }
            for (Map.Entry e : g.entrySet()) {
                BiomeGenBase b2 = ATGGeneratorConfig.getBiomeFromSaveName((String)e.getKey());
                if (b2 == null) {
                    ATG.logger.warn("Biome \"" + (String)e.getKey() + "\" not found, skipping.");
                    continue;
                }
                double weight = ((Property)e.getValue()).getDouble(0.0);
                if (!(weight > 0.0)) continue;
                group.addBiome(b2, weight);
            }
        }
        for (ConfigCategory g : catSubBiomes.getChildren()) {
            b = ATGGeneratorConfig.getBiomeFromSaveName(g.getName());
            if (b == null) {
                ATG.logger.warn("Biome \"" + g.getName() + "\" not found, skipping sub-biomes.");
                continue;
            }
            for (Map.Entry e : g.entrySet()) {
                BiomeGenBase sub = ATGGeneratorConfig.getBiomeFromSaveName((String)e.getKey());
                if (sub == null) {
                    ATG.logger.warn("Sub-Biome \"" + (String)e.getKey() + "\" not found, skipping.");
                    continue;
                }
                double weight = ((Property)e.getValue()).getDouble(0.0);
                if (!(weight > 0.0)) continue;
                ATGBiomeManager.addBiomeMod(b).addSubBiome(sub, weight);
            }
        }
        for (Map.Entry e : catGenMods.entrySet()) {
            b = ATGGeneratorConfig.getBiomeFromSaveName((String)e.getKey());
            if (b == null) {
                ATG.logger.warn("Biome \"" + (String)e.getKey() + "\" not found, skipping genmod.");
                continue;
            }
            String genmodname = ((Property)e.getValue()).getString();
            IGenMod genmod = genMods.get(genmodname);
            if (genmod == null) {
                ATG.logger.warn("GenMod \"" + genmodname + "\" not found, skipping genmod.");
                continue;
            }
            ATGBiomeManager.addBiomeMod(b).addGenMod(genmod);
        }
        for (ConfigCategory g : catRocks.getChildren()) {
            b = ATGGeneratorConfig.getBiomeFromSaveName(g.getName());
            if (b == null) {
                ATG.logger.warn("Biome \"" + g.getName() + "\" not found, skipping rocks.");
                continue;
            }
            int rocksPerChunk = 1;
            int rockChance = 40;
            int bigRockChance = 50;
            Property p = g.get("Rock frequency");
            if (p != null) {
                rockChance = p.getInt();
            }
            if ((p = g.get("Large rock frequency")) != null) {
                bigRockChance = p.getInt();
            }
            if ((p = g.get("Rocks per chunk")) != null) {
                rocksPerChunk = p.getInt();
            }
            ATGWorldGenRocks.setRockValues(b, rockChance, bigRockChance, rocksPerChunk);
        }
    }

    private static void buildDefaults() {
        String catname;
        ATG.logger.info("Building generator config defaults.");
        regenerate.set(false);
        for (Map.Entry<String, GroupDef> entry : groupDefinitions.entrySet()) {
            catname = catGroupsName + "." + entry.getKey();
            GroupDef groupDef = entry.getValue();
            config.get(catname, "Temperature", groupDef.temp);
            config.get(catname, "Rainfall", groupDef.rain);
            config.get(catname, "Height", groupDef.height);
            config.get(catname, "Min Height", groupDef.min);
            config.get(catname, "Max Height", groupDef.max);
            config.get(catname, "Random Seed", (int)groupDef.seed);
            config.get(catname, "Generate", groupDef.gen);
            config.get(catname, "Suitability", groupDef.suitability);
        }
        for (Map.Entry<String, Object> entry : groupAssignments.entrySet()) {
            catname = catBiomesName + "." + entry.getKey();
            Set set = (Set)entry.getValue();
            for (Tuple e : set) {
                config.get(catname, (String)e.first, ((Double)e.second).doubleValue());
            }
        }
        for (Map.Entry<String, Object> entry : subBiomeAssignments.entrySet()) {
            catname = catSubBiomesName + "." + entry.getKey();
            Set set = (Set)entry.getValue();
            for (Tuple e : set) {
                config.get(catname, (String)e.first, ((Double)e.second).doubleValue());
            }
        }
        String gendesc = genModsDesc;
        for (Map.Entry<String, IGenMod> entry : genMods.entrySet()) {
            gendesc = gendesc + entry.getKey();
            String string = ATGGeneratorConfig.getInfoForGenMod(entry.getValue());
            if (string != null) {
                gendesc = gendesc + "    " + string;
            }
            gendesc = gendesc + "\n";
        }
        catGenMods.setComment(gendesc);
        for (Map.Entry<String, Object> entry : genModAssignments.entrySet()) {
            config.get(catGenModsName, entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : rocks.entrySet()) {
            String catname2 = catRocksName + "." + entry.getKey();
            int[] data = (int[])entry.getValue();
            config.get(catname2, "Rock frequency", data[0]);
            config.get(catname2, "Large rock frequency", data[1]);
            config.get(catname2, "Rocks per chunk", data[2]);
        }
    }

    public static void addBiomeGroup(String name, double temp, double rain, double height, double min, double max, long seed, boolean generate, double suitability) {
        groupDefinitions.put(name, new GroupDef(temp, rain, height, min, max, seed, generate, suitability));
    }

    public static void setGroupSuitability(String name, double suitability) {
        if (groupDefinitions.containsKey(name)) {
            ATGGeneratorConfig.groupDefinitions.get((Object)name).suitability = suitability;
        }
    }

    public static void assignBiome(String group, String biome, double weight) {
        Set<Tuple<String, Double>> biomelist = groupAssignments.get(group);
        if (biomelist == null) {
            biomelist = new HashSet<Tuple<String, Double>>();
            groupAssignments.put(group, biomelist);
        }
        biomelist.add(new Tuple<String, Double>(biome, weight));
    }

    public static void assignBiome(String group, BiomeGenBase biome, double weight) {
        ATGGeneratorConfig.assignBiome(group, ATGGeneratorConfig.getSaveNameForBiome(biome), weight);
    }

    public static void removeBiome(String group, BiomeGenBase biome) {
        ATGGeneratorConfig.removeBiome(group, ATGGeneratorConfig.getSaveNameForBiome(biome));
    }

    public static void removeBiome(String group, String biome) {
        Set<Tuple<String, Double>> biomelist = groupAssignments.get(group);
        if (biomelist == null || biomelist.isEmpty()) {
            return;
        }
        for (Tuple<String, Double> b : biomelist) {
            if (!((String)b.first).equals(group)) continue;
            biomelist.remove(b);
            return;
        }
    }

    public static void assignSubBiome(BiomeGenBase biome, BiomeGenBase subbiome, double weight) {
        ATGGeneratorConfig.assignSubBiome(ATGGeneratorConfig.getSaveNameForBiome(biome), ATGGeneratorConfig.getSaveNameForBiome(subbiome), weight);
    }

    public static void assignSubBiome(String biome, String subbiome, double weight) {
        Set<Tuple<String, Double>> biomelist = subBiomeAssignments.get(biome);
        if (biomelist == null) {
            biomelist = new HashSet<Tuple<String, Double>>();
            subBiomeAssignments.put(biome, biomelist);
        }
        biomelist.add(new Tuple<String, Double>(subbiome, weight));
    }

    private static String getNameForGenMod(IGenMod genmod) {
        String mod = ModFinder.idFromObject(genmod);
        String classname = genmod.getClass().getSimpleName();
        String name = mod + "-" + classname;
        if (!genMods.containsKey(name)) {
            return name;
        }
        int n = 2;
        String namenum;
        while (genMods.containsKey(namenum = name + "-" + n)) {
            ++n;
        }
        return namenum;
    }

    private static String getInfoForGenMod(IGenMod genmod) {
        Field[] fields = genmod.getClass().getDeclaredFields();
        String info = "";
        try {
            for (Field f : fields) {
                f.setAccessible(true);
                Object o = f.get(genmod);
                if (info.length() > 0) {
                    info = info + ", ";
                }
                info = info + f.getName() + ": " + o.toString();
            }
        }
        catch (Exception e) {
            info = "Error getting genmod info";
        }
        if (info.length() > 0) {
            return "( " + info + " )";
        }
        return null;
    }

    public static String addGenMod(IGenMod mod) {
        for (Map.Entry<String, IGenMod> e : genMods.entrySet()) {
            if (e.getValue() != mod) continue;
            return e.getKey();
        }
        String name = ATGGeneratorConfig.getNameForGenMod(mod);
        genMods.put(name, mod);
        return name;
    }

    public static void assignGenMod(String biome, String genmod) {
        genModAssignments.put(biome, genmod);
    }

    public static void assignGenMod(BiomeGenBase biome, IGenMod genmod) {
        ATGGeneratorConfig.assignGenMod(ATGGeneratorConfig.getSaveNameForBiome(biome), genmod);
    }

    public static void assignGenMod(String biome, IGenMod genmod) {
        if (biome == null) {
            return;
        }
        String name = ATGGeneratorConfig.addGenMod(genmod);
        ATGGeneratorConfig.assignGenMod(biome, name);
    }

    public static void assignRockValues(String biome, int chance, int bigchance, int perchunk) {
        rocks.put(biome, new int[]{chance, bigchance, perchunk});
    }

    public static void assignRockValues(BiomeGenBase biome, int chance, int bigchance, int perchunk) {
        ATGGeneratorConfig.assignRockValues(ATGGeneratorConfig.getSaveNameForBiome(biome), chance, bigchance, perchunk);
    }

    public static BiomeGenBase getBiomeFromSaveName(String savename) {
        String[] saveparts = savename.split("-");
        BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
        for (int i = 0; i < biomeList.length; ++i) {
            String mod;
            BiomeGenBase biome = biomeList[i];
            if (biome == null || !saveparts[0].equals(mod = ModFinder.idFromObject(biome)) || !saveparts[1].equals(biome.field_76791_y)) continue;
            return biome;
        }
        return null;
    }

    public static String getSaveNameForBiome(BiomeGenBase biome) {
        String mod = ModFinder.idFromObject(biome);
        return mod + "-" + biome.field_76791_y;
    }

    static {
        catGroupsName = "1 Groups";
        catBiomesName = "2 Biomes";
        catSubBiomesName = "3 Sub-Biomes";
        catGenModsName = "4 GenMods";
        catRocksName = "5 Rocks";
        catControlName = "6 Control";
        groupDefinitions = new HashMap<String, GroupDef>();
        groupAssignments = new HashMap<String, Set<Tuple<String, Double>>>();
        subBiomeAssignments = new HashMap<String, Set<Tuple<String, Double>>>();
        genModAssignments = new HashMap<String, String>();
        rocks = new HashMap<String, int[]>();
    }
}

