/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.eventhandlers;

import com.google.common.base.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.biome.BiomeGenBase;
import ttftcuts.atg.ATG;
import ttftcuts.atg.ATGChunkManager;
import ttftcuts.atg.api.ATGBiomes;
import ttftcuts.atg.api.events.ATGBiomeEvent;
import ttftcuts.atg.api.events.ATGBiomeGroupAddEvent;
import ttftcuts.atg.api.events.ATGBiomeGroupEvent;
import ttftcuts.atg.api.events.ATGBiomeGroupRequestEvent;
import ttftcuts.atg.api.events.ATGBiomeModEvent;
import ttftcuts.atg.api.events.ATGBiomeModRequestEvent;
import ttftcuts.atg.api.events.ATGBiomeRequestEvent;
import ttftcuts.atg.api.events.ATGBiomeRocksEvent;
import ttftcuts.atg.api.events.ATGGeneratorInfoEvent;
import ttftcuts.atg.api.events.listenable.ATGBiomeGroupAssignmentEvent;
import ttftcuts.atg.biome.ATGBiomeGroup;
import ttftcuts.atg.config.ATGBiomeList;
import ttftcuts.atg.config.configfiles.ATGGeneratorConfig;
import ttftcuts.atg.gen.ATGBiomeManager;
import ttftcuts.atg.gen.ATGBiomeMod;

public class ATGAPIEventHandler {
    public static Map<String, Optional<BiomeGenBase>> biomes = new HashMap<String, Optional<BiomeGenBase>>();

    public static ATGBiomeGroup getBiomeGroupByName(ATGBiomes.BiomeType type, String name) {
        if (type.equals((Object)ATGBiomes.BiomeType.LAND)) {
            return ATGBiomeManager.land(name);
        }
        if (type.equals((Object)ATGBiomes.BiomeType.COAST)) {
            return ATGBiomeManager.coast(name);
        }
        if (type.equals((Object)ATGBiomes.BiomeType.SEA)) {
            return ATGBiomeManager.sea(name);
        }
        return null;
    }

    public static String getBiomeGroupNameByName(ATGBiomes.BiomeType type, String name) {
        if (type.equals((Object)ATGBiomes.BiomeType.LAND)) {
            return "Land-" + name;
        }
        if (type.equals((Object)ATGBiomes.BiomeType.COAST)) {
            return "Coast-" + name;
        }
        if (type.equals((Object)ATGBiomes.BiomeType.SEA)) {
            return "Sea-" + name;
        }
        return null;
    }

    @SubscribeEvent
    public void onBiomeRequest(ATGBiomeRequestEvent event) {
        if (biomes.containsKey(event.biomeName.toUpperCase())) {
            event.biome = biomes.get(event.biomeName.toUpperCase());
        }
    }

    @SubscribeEvent
    public void onGeneratorInfoEvent(ATGGeneratorInfoEvent event) {
        int x = (int)Math.round(event.x);
        int z = (int)Math.round(event.z);
        if (ATG.isATG(event.world)) {
            ATGChunkManager m = (ATGChunkManager)event.world.func_72959_q();
            double height = m.getRawHeightDouble(x, z);
            double temp = m.getRawTempDouble(x, z);
            double moisture = m.getRawMoistureDouble(x, z);
            event.info = new double[]{height, temp, moisture};
        }
    }

    @SubscribeEvent
    public void onBiomeModRequest(ATGBiomeModRequestEvent event) {
        ATGBiomeMod bmod = ATGBiomeManager.getMod(event.biome);
        if (bmod != null) {
            event.mod = bmod.genMod;
        }
    }

    @SubscribeEvent
    public void onBiomeGroupRequest(ATGBiomeGroupRequestEvent event) {
        event.groups = ATGBiomeManager.getGroupsFromBiome(event.biome);
    }

    @SubscribeEvent
    public void onBiomeGroupAddEvent(ATGBiomeGroupAddEvent event) {
        ATGGeneratorConfig.addBiomeGroup(ATGAPIEventHandler.getBiomeGroupNameByName(event.type, event.name), event.temp, event.moisture, event.height, event.minHeight, event.maxHeight, event.salt, event.generate, event.suitability);
        event.response = ATGBiomeGroupAddEvent.ResponseType.OK;
    }

    @Deprecated
    @SubscribeEvent
    public void onBiomeGroupEvent(ATGBiomeGroupEvent event) {
        if (event.type == ATGBiomeGroupEvent.EventType.SUITABILITY) {
            String name = ATGAPIEventHandler.getBiomeGroupNameByName(event.biomeType, event.name);
            ATGGeneratorConfig.setGroupSuitability(name, event.modifier);
            event.response = ATGBiomeGroupEvent.ResponseType.OK;
        }
    }

    @SubscribeEvent
    public void onBiomeEvent(ATGBiomeEvent event) {
        String groupname = ATGAPIEventHandler.getBiomeGroupNameByName(event.type, event.group);
        if (event.replaced != null) {
            ATGGeneratorConfig.removeBiome(groupname, event.replaced);
            ATGGeneratorConfig.assignBiome(groupname, event.biome, event.weight);
            event.response = ATGBiomeEvent.ResponseType.REPLACED;
        } else {
            ATGGeneratorConfig.assignBiome(groupname, event.biome, event.weight);
            event.response = ATGBiomeEvent.ResponseType.ADDED;
        }
    }

    @SubscribeEvent
    public void onBiomeModEvent(ATGBiomeModEvent event) {
        if (event.type == ATGBiomeModEvent.EventType.SUBBIOME) {
            if (event.subBiome != null) {
                ATGGeneratorConfig.assignSubBiome(event.biome, event.subBiome, event.weight);
            }
        } else if (event.type == ATGBiomeModEvent.EventType.GENMOD && event.mod != null) {
            ATGGeneratorConfig.assignGenMod(event.biome, event.mod);
        }
    }

    @SubscribeEvent
    public void onBiomeRocksEvent(ATGBiomeRocksEvent event) {
        ATGGeneratorConfig.assignRockValues(event.biome, event.rockChance, event.bigRockChance, event.rocksPerChunk);
    }

    @SubscribeEvent
    public void onGroupActivationEvent(ATGBiomeGroupAssignmentEvent.ATGGroupActivationEvent event) {
        ATGBiomeManager.sendGroupAssignmentEvents = true;
    }

    static {
        biomes.put("STEPPE", ATGBiomeList.steppe);
        biomes.put("SHRUBLAND", ATGBiomeList.shrubland);
        biomes.put("WOODLAND", ATGBiomeList.woodland);
        biomes.put("GRAVELBEACH", ATGBiomeList.gravelBeach);
        biomes.put("TROPICALSHRUBLAND", ATGBiomeList.tropicalShrubland);
        biomes.put("TUNDRA", ATGBiomeList.tundra);
        biomes.put("VOLCANO", ATGBiomeList.volcano);
        biomes.put("SNOWYBEACH", ATGBiomeList.snowyBeach);
    }
}

