/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;
import ttftcuts.atg.gen.ATGGenLayer;
import ttftcuts.atg.gen.ATGPerlin;

public class ATGGenLayerAltNoise
extends ATGGenLayer {
    private Random rand;
    private ATGPerlin[] noise;

    public ATGGenLayerAltNoise(Long seed) {
        super(seed);
        this.func_75903_a(seed * 32857482L + 32985720342L, seed * 4985472834L + 1639572824L);
        this.rand = new Random((long)this.func_75902_a(1000000000) * seed);
        this.noise = new ATGPerlin[4];
        this.noise[1] = new ATGPerlin(this.rand, 67.0);
        this.noise[2] = new ATGPerlin(this.rand, 29.0);
        this.noise[3] = new ATGPerlin(this.rand, 7.0);
    }

    private double getValue(int x, int z) {
        double t1 = this.noise[1].normNoise(x, z, 0.0);
        double t2 = this.noise[2].normNoise(x, z, 0.0);
        double t3 = this.noise[3].normNoise(x, z, 0.0);
        return t1 * 0.5 + t2 * 0.35 + t3 * 0.15;
    }

    public int[] func_75904_a(int x, int z, int w, int h) {
        int[] data = new int[w * h];
        for (int dz = 0; dz < h; ++dz) {
            for (int dx = 0; dx < w; ++dx) {
                this.func_75903_a(x + dx, z + dz);
                int X = x + dx;
                int Z = z + dz;
                double temp = this.getValue(X, Z);
                data[dx + dz * w] = 1 + (int)(temp * 255.0);
            }
        }
        return data;
    }

    @Override
    public int getInt(int x, int z) {
        return 1 + (int)(this.getValue(x, z) * 255.0);
    }

    @Override
    public double getDouble(int x, int z) {
        return this.getValue(x, z);
    }
}

