/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.world.gen.layer.GenLayer;
import ttftcuts.atg.ATG;
import ttftcuts.atg.config.configfiles.ATGMainConfig;
import ttftcuts.atg.utils.ATGBicubic;

public class ATGGenLayerSourceImage
extends GenLayer {
    public boolean active = false;
    private static BufferedImage image = null;
    private double scale;
    private double width;
    private double height;
    private int fading = ATGMainConfig.imageMapFade.getInt(100);
    private boolean looping = ATGMainConfig.imageMapLooping.getBoolean(false);
    private static final int defaultColour = ATGBicubic.colour(255, 255, 255, 0);

    public ATGGenLayerSourceImage() {
        super(0L);
        this.scale = ATGMainConfig.imageMapScale.getDouble(8.0);
        if (ATGMainConfig.useImageMap.getBoolean(false) && image != null) {
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadImage() {
        if (!ATGMainConfig.useImageMap.getBoolean(false)) {
            return;
        }
        String filename = ATGMainConfig.imageMapFile.getString();
        File path = new File(ATG.mapPath, filename);
        if (path.exists()) {
            try {
                image = ImageIO.read(path);
            }
            catch (IOException e) {
                System.out.println("ATG: Failed to load " + filename + " for ImageMap");
                e.printStackTrace();
            }
            finally {
                System.out.println("ATG: Successfully loaded " + filename + " for ImageMap");
            }
        } else {
            System.out.println("ATG: Can't find file path for ImageMap");
        }
    }

    public double[] getImageCoords(int x, int z) {
        double ox;
        double oy = (double)z / this.scale + this.height * 0.5;
        if (this.looping) {
            if (ox < 0.0) {
                for (ox = (double)x / this.scale + this.width * 0.5; ox < 0.0; ox += this.width) {
                }
            } else if (ox >= this.width) {
                while (ox >= this.width) {
                    ox -= this.width;
                }
            }
            if (oy < 0.0) {
                while (oy < 0.0) {
                    oy += this.height;
                }
            } else if (oy >= this.height) {
                while (oy >= this.height) {
                    oy -= this.height;
                }
            }
        } else {
            ox = Math.min(this.width, Math.max(0.0, ox));
            oy = Math.min(this.height, Math.max(0.0, oy));
        }
        double[] out = new double[]{ox, oy};
        return out;
    }

    public int getInt(int x, int z) {
        double[] coords = this.getImageCoords(x, z);
        double ix = coords[0];
        double iy = coords[1];
        if (!this.looping) {
            double sw = this.width * this.scale * 0.5;
            double sh = this.height * this.scale * 0.5;
            double mult = 1.0;
            if ((double)Math.abs(x) >= sw) {
                if ((double)Math.abs(x) >= sw + (double)this.fading) {
                    return defaultColour;
                }
                mult *= 1.0 - ((double)Math.abs(x) - sw) / (double)this.fading;
            }
            if ((double)Math.abs(z) >= sh) {
                if ((double)Math.abs(z) >= sh + (double)this.fading) {
                    return defaultColour;
                }
                mult *= 1.0 - ((double)Math.abs(z) - sh) / (double)this.fading;
            }
            int colour = ATGBicubic.bicubic(image, ix, iy, this.looping);
            int a = ATGBicubic.getAlpha(colour);
            int red = ATGBicubic.getRed(colour);
            int green = ATGBicubic.getGreen(colour);
            int blue = ATGBicubic.getBlue(colour);
            return ATGBicubic.colour(Math.max(2, red), Math.max(2, green), Math.max(2, blue), (int)Math.round((double)a * mult));
        }
        return ATGBicubic.bicubic(image, ix, iy, this.looping);
    }

    public int[] func_75904_a(int x, int z, int w, int h) {
        int[] data = new int[w * h];
        for (int iz = 0; iz < h; ++iz) {
            for (int ix = 0; ix < w; ++ix) {
                data[z * w + x] = this.getInt(x + ix, z + iz);
            }
        }
        return data;
    }
}

