/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.appeng.handlers;

import appeng.api.AEApi;
import appeng.api.features.IInscriberRecipe;
import appeng.api.features.InscriberProcessType;
import appeng.core.features.registries.entries.InscriberRecipe;
import java.util.LinkedList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.appeng.AppliedEnergisticsHelper;
import modtweaker2.utils.ArrayUtils;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.appeng.Inscriber")
public class Inscriber {
    protected static final String name = "Applied Energistics 2 Inscriber";

    @ZenMethod
    public static void addRecipe(IItemStack[] imprintable, IItemStack plateA, IItemStack plateB, IItemStack out, String type) {
        if (imprintable == null || out == null || !type.equals("Press") && !type.equals("Inscribe")) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        InscriberRecipe recipe = new InscriberRecipe(ArrayUtils.toArrayList(InputHelper.toStacks(imprintable)), InputHelper.toStack(out), InputHelper.toStack(plateA), InputHelper.toStack(plateB), InscriberProcessType.valueOf((String)type));
        for (IInscriberRecipe r : AEApi.instance().registries().inscriber().getRecipes()) {
            if (r == null || !AppliedEnergisticsHelper.equals(r, (IInscriberRecipe)recipe)) continue;
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(InputHelper.toStack(out))));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add((IInscriberRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        if (output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        LinkedList<IInscriberRecipe> result = new LinkedList<IInscriberRecipe>();
        for (IInscriberRecipe entry : AEApi.instance().registries().inscriber().getRecipes()) {
            if (entry == null || entry.getOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(entry.getOutput()))) continue;
            result.add(entry);
        }
        if (!result.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(result));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    public static class Remove
    extends BaseListRemoval<IInscriberRecipe> {
        public Remove(LinkedList<IInscriberRecipe> recipes) {
            super(Inscriber.name, AEApi.instance().registries().inscriber().getRecipes(), recipes);
        }

        @Override
        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (IInscriberRecipe recipe : this.recipes) {
                try {
                    AEApi.instance().registries().inscriber().removeRecipe(recipe);
                    this.successful.add(recipe);
                }
                catch (Exception ex) {
                    LogHelper.logError("Error removing inscriber recipe.", ex);
                }
            }
        }

        @Override
        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (IInscriberRecipe recipe : this.successful) {
                try {
                    AEApi.instance().registries().inscriber().addRecipe(recipe);
                }
                catch (Exception ex) {
                    LogHelper.logError("Error restoring inscriber recipe.", ex);
                }
            }
        }

        @Override
        public String getRecipeInfo(IInscriberRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    public static class Add
    extends BaseListAddition<IInscriberRecipe> {
        public Add(IInscriberRecipe recipe) {
            super(Inscriber.name, AEApi.instance().registries().inscriber().getRecipes());
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (IInscriberRecipe recipe : this.recipes) {
                try {
                    AEApi.instance().registries().inscriber().addRecipe(recipe);
                    this.successful.add(recipe);
                }
                catch (Exception ex) {
                    LogHelper.logError("Error adding inscriber recipe.", ex);
                }
            }
        }

        @Override
        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (IInscriberRecipe recipe : this.successful) {
                try {
                    AEApi.instance().registries().inscriber().removeRecipe(recipe);
                }
                catch (Exception ex) {
                    LogHelper.logError("Error removing inscriber recipe.", ex);
                }
            }
        }

        @Override
        public String getRecipeInfo(IInscriberRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }

        @Override
        protected boolean equals(IInscriberRecipe recipe, IInscriberRecipe otherRecipe) {
            return AppliedEnergisticsHelper.equals(recipe, otherRecipe);
        }
    }
}

