/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.factory.gadgets.MachineSqueezer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Squeezer")
public class Squeezer {
    public static final String name = "Forestry Squeezer";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, int timePerItem, IItemStack[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineSqueezer.Recipe(timePerItem, InputHelper.toStacks(ingredients), InputHelper.toFluid(fluidOutput), null, 0)));
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, WeightedItemStack itemOutput, int timePerItem, IItemStack[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineSqueezer.Recipe(timePerItem, InputHelper.toStacks(ingredients), InputHelper.toFluid(fluidOutput), InputHelper.toStack(itemOutput.getStack()), (int)itemOutput.getPercent())));
    }

    @ZenMethod
    @Deprecated
    public static void addRecipe(int timePerItem, IItemStack[] resources, ILiquidStack liquid, IItemStack remnants, int chance) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineSqueezer.Recipe(timePerItem, InputHelper.toStacks(resources), InputHelper.toFluid(liquid), InputHelper.toStack(remnants), chance)));
        MachineSqueezer.RecipeManager.recipeFluids.add(InputHelper.getFluid(liquid));
        MachineSqueezer.RecipeManager.recipeInputs.addAll(Arrays.asList(InputHelper.toStacks(resources)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient liquid, @Optional IIngredient[] ingredients) {
        LinkedList<MachineSqueezer.Recipe> recipes = new LinkedList<MachineSqueezer.Recipe>();
        for (MachineSqueezer.Recipe r : MachineSqueezer.RecipeManager.recipes) {
            if (r == null || r.liquid == null || !StackHelper.matches(liquid, InputHelper.toILiquidStack(r.liquid))) continue;
            if (ingredients != null) {
                boolean matched = false;
                for (int i = 0; i < ingredients.length; ++i) {
                    if (!StackHelper.matches(ingredients[i], InputHelper.toIItemStack(r.resources[i]))) {
                        matched = false;
                        break;
                    }
                    matched = true;
                }
                if (!matched) continue;
                recipes.add(r);
                continue;
            }
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, liquid.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<MachineSqueezer.Recipe> {
        public Remove(List<MachineSqueezer.Recipe> recipes) {
            super(Squeezer.name, MachineSqueezer.RecipeManager.recipes, recipes);
        }

        @Override
        public void apply() {
            super.apply();
        }

        @Override
        public String getRecipeInfo(MachineSqueezer.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.liquid);
        }
    }

    private static class Add
    extends BaseListAddition<MachineSqueezer.Recipe> {
        public Add(MachineSqueezer.Recipe recipe) {
            super(Squeezer.name, MachineSqueezer.RecipeManager.recipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(MachineSqueezer.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.liquid);
        }
    }
}

