/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.commands;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.ICommandFunction;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StringHelper;

public class MekanismLogger
implements ICommandFunction {
    private static final List<String> validArguments = new LinkedList<String>();

    public void execute(String[] arguments, IPlayer player) {
        List<String> args = StringHelper.toLowerCase(Arrays.asList(arguments));
        if (!validArguments.containsAll(args)) {
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("Invalid arguments for command. Valid arguments: " + StringHelper.join(validArguments, ", ")));
            }
        } else {
            if (args.isEmpty() || args.contains("crystallizer")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.Crystallizer.addRecipe(%s, %s);", LogHelper.getStackDescription(((GasInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("dissolution")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.Dissolution.addRecipe(%s, %s);", LogHelper.getStackDescription(((ItemStackInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((GasOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("infuser")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CHEMICAL_INFUSER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.Infuser.addRecipe(%s, %s, %s);", LogHelper.getStackDescription(((ChemicalPairInput)recipe.recipeInput).leftGas), LogHelper.getStackDescription(((ChemicalPairInput)recipe.recipeInput).rightGas), LogHelper.getStackDescription(((GasOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("injection")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.Injection.addRecipe(%s, %s, %s);", LogHelper.getStackDescription(((AdvancedMachineInput)recipe.recipeInput).itemStack), LogHelper.getStackDescription(new GasStack(((AdvancedMachineInput)recipe.recipeInput).gasType, 1)), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("oxidizer")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.Oxidizer.addRecipe(%s, %s);", LogHelper.getStackDescription(((ItemStackInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((GasOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("washer")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CHEMICAL_WASHER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.Washer.addRecipe(%s, %s);", LogHelper.getStackDescription(((GasInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((GasOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("combiner")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.COMBINER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Combiner.addRecipe(%s, %s, %s);", LogHelper.getStackDescription(((AdvancedMachineInput)recipe.recipeInput).itemStack), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output), LogHelper.getStackDescription(new GasStack(((AdvancedMachineInput)recipe.recipeInput).gasType, 1))));
                }
            }
            if (args.isEmpty() || args.contains("compressor")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.COMBINER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Compressor.addRecipe(%s, %s, %s);", LogHelper.getStackDescription(((AdvancedMachineInput)recipe.recipeInput).itemStack), LogHelper.getStackDescription(new GasStack(((AdvancedMachineInput)recipe.recipeInput).gasType, 1)), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("crusher")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CRUSHER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Crusher.addRecipe(%s, %s);", LogHelper.getStackDescription(((ItemStackInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("crusher")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.ENERGIZED_SMELTER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Smelter.addRecipe(%s, %s);", LogHelper.getStackDescription(((ItemStackInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("enrichment")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Enrichment.addRecipe(%s, %s);", LogHelper.getStackDescription(((ItemStackInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("infuser")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Infuser.addRecipe(\"%s\", %d, %s, %s);", ((InfusionInput)recipe.getInput()).infuse.type.name, ((InfusionInput)recipe.getInput()).infuse.amount, LogHelper.getStackDescription(((InfusionInput)recipe.recipeInput).inputStack), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("purification")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.PURIFICATION_CHAMBER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Purification.addRecipe(%s, %s, %s);", LogHelper.getStackDescription(((AdvancedMachineInput)recipe.recipeInput).itemStack), LogHelper.getStackDescription(new GasStack(((AdvancedMachineInput)recipe.recipeInput).gasType, 1)), LogHelper.getStackDescription(((ItemStackOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("reaction")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Reaction.addRecipe(%s, %s, %s, %s, %s, %s, %d);", LogHelper.getStackDescription(((PressurizedInput)recipe.recipeInput).getSolid()), LogHelper.getStackDescription(((PressurizedInput)recipe.recipeInput).getFluid()), LogHelper.getStackDescription(((PressurizedInput)recipe.recipeInput).getGas()), LogHelper.getStackDescription(((PressurizedOutput)recipe.recipeOutput).getItemOutput()), LogHelper.getStackDescription(((PressurizedOutput)recipe.recipeOutput).getGasOutput()), recipe.extraEnergy, recipe.ticks));
                }
            }
            if (args.isEmpty() || args.contains("sawmill")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.PRECISION_SAWMILL.get().values()) {
                    if (((ChanceOutput)recipe.getOutput()).hasSecondary()) {
                        MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Sawmill.addRecipe(%s, %s, %s, %s);", LogHelper.getStackDescription(((ItemStackInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((ChanceOutput)recipe.recipeOutput).primaryOutput), LogHelper.getStackDescription(((ChanceOutput)recipe.recipeOutput).secondaryOutput), ((ChanceOutput)recipe.recipeOutput).secondaryChance));
                        continue;
                    }
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Sawmill.addRecipe(%s, %s);", LogHelper.getStackDescription(((ItemStackInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((ChanceOutput)recipe.recipeOutput).primaryOutput)));
                }
            }
            if (args.isEmpty() || args.contains("separator")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.Separator.addRecipe(%s, %s, %s, %s);", LogHelper.getStackDescription(((FluidInput)recipe.recipeInput).ingredient), recipe.energyUsage, LogHelper.getStackDescription(((ChemicalPairOutput)recipe.recipeOutput).leftGas), LogHelper.getStackDescription(((ChemicalPairOutput)recipe.recipeOutput).rightGas)));
                }
            }
            if (args.isEmpty() || args.contains("evaporation")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.SOLAR_EVAPORATION_PLANT.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.SolarEvaporation.addRecipe(%s, %s);", LogHelper.getStackDescription(((FluidInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((FluidOutput)recipe.recipeOutput).output)));
                }
            }
            if (args.isEmpty() || args.contains("neutron")) {
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get().values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.mekanism.SolarNeutronActivator.addRecipe(%s, %s);", LogHelper.getStackDescription(((GasInput)recipe.recipeInput).ingredient), LogHelper.getStackDescription(((GasOutput)recipe.recipeOutput).output)));
                }
            }
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
            }
        }
    }

    static {
        validArguments.add("combiner");
        validArguments.add("compressor");
        validArguments.add("crusher");
        validArguments.add("crystallizer");
        validArguments.add("dissolution");
        validArguments.add("enrichment");
        validArguments.add("evaporation");
        validArguments.add("infuser");
        validArguments.add("injection");
        validArguments.add("neutron");
        validArguments.add("oxidizer");
        validArguments.add("purification");
        validArguments.add("reaction");
        validArguments.add("sawmill");
        validArguments.add("separator");
        validArguments.add("washer");
    }
}

