/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.InsolatorManager;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Insolator")
public class Insolator {
    public static final String name = "Thermal Expansion Insolator";

    @ZenMethod
    public static void addRecipe(int energy, IItemStack secondaryInput, IItemStack primaryInput, IItemStack primaryOutput, @Optional IItemStack secondaryOutput, @Optional int secondaryChance) {
        if (primaryInput == null || secondaryInput == null || primaryOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (InsolatorManager.recipeExists((ItemStack)InputHelper.toStack(primaryInput), (ItemStack)InputHelper.toStack(secondaryInput))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s and %s. Command ignored!", name, primaryInput.toString(), secondaryInput.toString()));
            return;
        }
        InsolatorManager.RecipeInsolator recipe = ReflectionHelper.getInstance(ThermalHelper.insolatorRecipe, InputHelper.toStack(primaryInput), InputHelper.toStack(secondaryInput), InputHelper.toStack(primaryOutput), InputHelper.toStack(secondaryOutput), secondaryChance, energy);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", name));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input2, IIngredient input1) {
        LinkedList<InsolatorManager.RecipeInsolator> recipes = new LinkedList<InsolatorManager.RecipeInsolator>();
        for (InsolatorManager.RecipeInsolator recipe : InsolatorManager.getRecipeList()) {
            if (recipe == null || !StackHelper.matches(input1, InputHelper.toIItemStack(recipe.getPrimaryInput())) || !StackHelper.matches(input2, InputHelper.toIItemStack(recipe.getSecondaryInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipes found for %s and %s.", name, input1.toString(), input2.toString()));
        }
    }

    @ZenMethod
    public static void refreshRecipes() {
        MineTweakerAPI.apply((IUndoableAction)new Refresh());
    }

    private static class Refresh
    implements IUndoableAction {
        private Refresh() {
        }

        public void apply() {
            InsolatorManager.refreshRecipes();
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Refreshing Thermal Expansion Insolator recipes";
        }

        public void undo() {
        }

        public String describeUndo() {
            return "Ignoring undo of Thermal Expansion Insolator recipe refresh";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    extends BaseListRemoval<InsolatorManager.RecipeInsolator> {
        public Remove(List<InsolatorManager.RecipeInsolator> recipes) {
            super(Insolator.name, null, recipes);
        }

        @Override
        public void apply() {
            for (InsolatorManager.RecipeInsolator recipe : this.recipes) {
                boolean removed = InsolatorManager.removeRecipe((ItemStack)recipe.getPrimaryInput(), (ItemStack)recipe.getSecondaryInput());
                if (!removed) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (InsolatorManager.RecipeInsolator recipe : this.recipes) {
                InsolatorManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getPrimaryInput(), (ItemStack)recipe.getSecondaryInput(), (ItemStack)recipe.getPrimaryOutput(), (ItemStack)recipe.getSecondaryOutput(), (int)recipe.getSecondaryOutputChance());
            }
        }

        @Override
        protected boolean equals(InsolatorManager.RecipeInsolator recipe, InsolatorManager.RecipeInsolator otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        public String getRecipeInfo(InsolatorManager.RecipeInsolator recipe) {
            return LogHelper.getStackDescription(recipe.getPrimaryOutput());
        }
    }

    private static class Add
    extends BaseListAddition<InsolatorManager.RecipeInsolator> {
        public Add(InsolatorManager.RecipeInsolator recipe) {
            super(Insolator.name, null);
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            for (InsolatorManager.RecipeInsolator recipe : this.recipes) {
                boolean applied = InsolatorManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getPrimaryInput(), (ItemStack)recipe.getSecondaryInput(), (ItemStack)recipe.getPrimaryOutput(), (ItemStack)recipe.getSecondaryOutput(), (int)recipe.getSecondaryOutputChance(), (boolean)false);
                if (!applied) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (InsolatorManager.RecipeInsolator recipe : this.recipes) {
                InsolatorManager.removeRecipe((ItemStack)recipe.getPrimaryInput(), (ItemStack)recipe.getSecondaryInput());
            }
        }

        @Override
        protected boolean equals(InsolatorManager.RecipeInsolator recipe, InsolatorManager.RecipeInsolator otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(InsolatorManager.RecipeInsolator recipe) {
            return LogHelper.getStackDescription(recipe.getPrimaryOutput());
        }
    }
}

